/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.spark.agent.lifecycle;

import com.google.common.collect.ImmutableList;
import io.openlineage.client.OpenLineage;
import io.openlineage.spark.agent.lifecycle.DatasetBuilderFactory;
import io.openlineage.spark.agent.lifecycle.plan.CommandPlanVisitor;
import io.openlineage.spark.agent.lifecycle.plan.SaveIntoDataSourceCommandVisitor;
import io.openlineage.spark.agent.lifecycle.plan.column.ColumnLevelLineageVisitor;
import io.openlineage.spark.agent.util.DeltaUtils;
import io.openlineage.spark.api.DatasetFactory;
import io.openlineage.spark.api.OpenLineageContext;
import io.openlineage.spark3.agent.lifecycle.plan.AlterTableDatasetBuilder;
import io.openlineage.spark3.agent.lifecycle.plan.AppendDataDatasetBuilder;
import io.openlineage.spark3.agent.lifecycle.plan.CreateReplaceDatasetBuilder;
import io.openlineage.spark3.agent.lifecycle.plan.DataSourceV2RelationInputDatasetBuilder;
import io.openlineage.spark3.agent.lifecycle.plan.DataSourceV2RelationOutputDatasetBuilder;
import io.openlineage.spark3.agent.lifecycle.plan.DataSourceV2ScanRelationInputDatasetBuilder;
import io.openlineage.spark3.agent.lifecycle.plan.InMemoryRelationInputDatasetBuilder;
import io.openlineage.spark3.agent.lifecycle.plan.LogicalRelationDatasetBuilder;
import io.openlineage.spark3.agent.lifecycle.plan.MergeIntoCommandInputDatasetBuilder;
import io.openlineage.spark3.agent.lifecycle.plan.MergeIntoCommandOutputDatasetBuilder;
import io.openlineage.spark3.agent.lifecycle.plan.SubqueryAliasInputDatasetBuilder;
import io.openlineage.spark3.agent.lifecycle.plan.SubqueryAliasOutputDatasetBuilder;
import io.openlineage.spark3.agent.lifecycle.plan.TableContentChangeDatasetBuilder;
import io.openlineage.spark32.agent.lifecycle.plan.column.MergeIntoDelta11ColumnLineageVisitor;
import io.openlineage.spark32.agent.lifecycle.plan.column.MergeIntoIceberg013ColumnLineageVisitor;
import io.openlineage.spark34.agent.lifecycle.plan.column.MergeIntoDelta24ColumnLineageVisitor;
import io.openlineage.spark34.agent.lifecycle.plan.column.MergeIntoIceberg13ColumnLineageVisitor;
import java.util.Collection;
import java.util.List;
import scala.PartialFunction;

public class Spark3DatasetBuilderFactory
implements DatasetBuilderFactory {
    @Override
    public Collection<PartialFunction<Object, List<OpenLineage.InputDataset>>> getInputBuilders(OpenLineageContext context) {
        DatasetFactory<OpenLineage.InputDataset> datasetFactory = DatasetFactory.input(context);
        ImmutableList.Builder builder = ImmutableList.builder().add(new LogicalRelationDatasetBuilder(context, (DatasetFactory)datasetFactory, true)).add((Object)new InMemoryRelationInputDatasetBuilder(context)).add((Object)new CommandPlanVisitor(context)).add((Object)new DataSourceV2ScanRelationInputDatasetBuilder(context, datasetFactory)).add((Object)new DataSourceV2RelationInputDatasetBuilder(context, datasetFactory)).add((Object)new SubqueryAliasInputDatasetBuilder(context));
        if (DeltaUtils.hasMergeIntoCommandClass()) {
            builder.add((Object)new MergeIntoCommandInputDatasetBuilder(context));
        }
        return builder.build();
    }

    @Override
    public Collection<PartialFunction<Object, List<OpenLineage.OutputDataset>>> getOutputBuilders(OpenLineageContext context) {
        DatasetFactory<OpenLineage.OutputDataset> datasetFactory = DatasetFactory.output(context);
        ImmutableList.Builder builder = ImmutableList.builder().add(new LogicalRelationDatasetBuilder(context, (DatasetFactory)datasetFactory, false)).add((Object)new SaveIntoDataSourceCommandVisitor(context)).add((Object)new AppendDataDatasetBuilder(context, datasetFactory)).add((Object)new DataSourceV2RelationOutputDatasetBuilder(context, datasetFactory)).add((Object)new TableContentChangeDatasetBuilder(context)).add((Object)new CreateReplaceDatasetBuilder(context)).add((Object)new SubqueryAliasOutputDatasetBuilder(context)).add((Object)new AlterTableDatasetBuilder(context));
        if (DeltaUtils.hasMergeIntoCommandClass()) {
            builder.add((Object)new MergeIntoCommandOutputDatasetBuilder(context));
        }
        return builder.build();
    }

    @Override
    public Collection<ColumnLevelLineageVisitor> getColumnLevelLineageVisitors(OpenLineageContext context) {
        ImmutableList.Builder builder = ImmutableList.builder();
        if (MergeIntoDelta24ColumnLineageVisitor.hasClasses()) {
            builder.add((Object)new MergeIntoDelta24ColumnLineageVisitor(context));
        }
        if (MergeIntoDelta11ColumnLineageVisitor.hasClasses()) {
            builder.add((Object)new MergeIntoDelta11ColumnLineageVisitor(context));
        }
        if (MergeIntoIceberg13ColumnLineageVisitor.hasClasses()) {
            builder.add((Object)new MergeIntoIceberg13ColumnLineageVisitor(context));
        }
        if (MergeIntoIceberg013ColumnLineageVisitor.hasClasses()) {
            builder.add((Object)new MergeIntoIceberg013ColumnLineageVisitor(context));
        }
        return builder.build();
    }
}

