/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.spark.agent.lifecycle;

import com.google.common.collect.ImmutableList;
import io.openlineage.client.OpenLineage;
import io.openlineage.spark.agent.lifecycle.DatasetBuilderFactory;
import io.openlineage.spark.agent.lifecycle.Spark32DatasetBuilderFactory;
import io.openlineage.spark.agent.lifecycle.plan.SaveIntoDataSourceCommandVisitor;
import io.openlineage.spark.agent.util.DeltaUtils;
import io.openlineage.spark.api.DatasetFactory;
import io.openlineage.spark.api.OpenLineageContext;
import io.openlineage.spark3.agent.lifecycle.plan.AppendDataDatasetBuilder;
import io.openlineage.spark3.agent.lifecycle.plan.DataSourceV2RelationOutputDatasetBuilder;
import io.openlineage.spark3.agent.lifecycle.plan.LogicalRelationDatasetBuilder;
import io.openlineage.spark3.agent.lifecycle.plan.MergeIntoCommandOutputDatasetBuilder;
import io.openlineage.spark3.agent.lifecycle.plan.SubqueryAliasOutputDatasetBuilder;
import io.openlineage.spark3.agent.lifecycle.plan.TableContentChangeDatasetBuilder;
import io.openlineage.spark32.agent.lifecycle.plan.AlterTableCommandDatasetBuilder;
import io.openlineage.spark33.agent.lifecycle.plan.CreateReplaceDatasetBuilder;
import io.openlineage.spark33.agent.lifecycle.plan.ReplaceIcebergDataDatasetBuilder;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.PartialFunction;

public class Spark33DatasetBuilderFactory
extends Spark32DatasetBuilderFactory
implements DatasetBuilderFactory {
    private static final Logger log = LoggerFactory.getLogger(Spark33DatasetBuilderFactory.class);

    @Override
    public Collection<PartialFunction<Object, List<OpenLineage.OutputDataset>>> getOutputBuilders(OpenLineageContext context) {
        DatasetFactory<OpenLineage.OutputDataset> datasetFactory = DatasetFactory.output(context);
        ImmutableList.Builder builder = ImmutableList.builder().add(new LogicalRelationDatasetBuilder(context, (DatasetFactory)datasetFactory, false)).add((Object)new SaveIntoDataSourceCommandVisitor(context)).add((Object)new AppendDataDatasetBuilder(context, datasetFactory)).add((Object)new DataSourceV2RelationOutputDatasetBuilder(context, datasetFactory)).add((Object)new TableContentChangeDatasetBuilder(context)).add((Object)new SubqueryAliasOutputDatasetBuilder(context)).add((Object)new CreateReplaceDatasetBuilder(context)).add((Object)new AlterTableCommandDatasetBuilder(context));
        if (DeltaUtils.hasMergeIntoCommandClass()) {
            builder.add((Object)new MergeIntoCommandOutputDatasetBuilder(context));
        }
        if (ReplaceIcebergDataDatasetBuilder.hasClasses()) {
            builder.add((Object)new ReplaceIcebergDataDatasetBuilder(context));
        }
        return builder.build();
    }
}

