/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.spark.agent.lifecycle;

import java.net.URI;

public class DatasetParser {
    public static DatasetParseResult parse(URI uri) {
        return new DatasetParseResult(DatasetParser.getName(uri), DatasetParser.getNamespace(uri));
    }

    private static String getName(URI uri) {
        return uri.toASCIIString();
    }

    private static String getNamespace(URI uri) {
        if (DatasetParser.isNullOrEmpty(uri.getScheme()) && DatasetParser.isNullOrEmpty(uri.getHost())) {
            return "default";
        }
        if (DatasetParser.isNullOrEmpty(uri.getHost())) {
            return uri.getScheme();
        }
        if (DatasetParser.isNullOrEmpty(uri.getScheme())) {
            return uri.getHost();
        }
        return String.format("%s.%s", uri.getScheme(), uri.getHost());
    }

    private static boolean isNullOrEmpty(String str) {
        return str == null || str.isEmpty();
    }

    public static DatasetParseResult parse(String value) {
        try {
            URI uri = URI.create(value);
            return DatasetParser.parse(uri);
        }
        catch (Exception e) {
            return new DatasetParseResult(value, "default");
        }
    }

    public static final class DatasetParseResult {
        private final String name;
        private final String namespace;

        public DatasetParseResult(String name, String namespace) {
            this.name = name;
            this.namespace = namespace;
        }

        public String getName() {
            return this.name;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DatasetParseResult)) {
                return false;
            }
            DatasetParseResult other = (DatasetParseResult)o;
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$namespace = this.getNamespace();
            String other$namespace = other.getNamespace();
            return !(this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $namespace = this.getNamespace();
            result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
            return result;
        }

        public String toString() {
            return "DatasetParser.DatasetParseResult(name=" + this.getName() + ", namespace=" + this.getNamespace() + ")";
        }
    }
}

