/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.spark.agent.lifecycle;

import io.openlineage.spark.agent.lifecycle.DatasetBuilderFactory;
import org.apache.spark.package$;

public class DatasetBuilderFactoryProvider {
    private static final String SPARK2_FACTORY_NAME = "io.openlineage.spark.agent.lifecycle.Spark2DatasetBuilderFactory";
    private static final String SPARK3_FACTORY_NAME = "io.openlineage.spark.agent.lifecycle.Spark3DatasetBuilderFactory";
    private static final String SPARK32_FACTORY_NAME = "io.openlineage.spark.agent.lifecycle.Spark32DatasetBuilderFactory";
    private static final String SPARK33_FACTORY_NAME = "io.openlineage.spark.agent.lifecycle.Spark33DatasetBuilderFactory";
    private static final String SPARK34_FACTORY_NAME = "io.openlineage.spark.agent.lifecycle.Spark34DatasetBuilderFactory";
    private static final String SPARK35_FACTORY_NAME = "io.openlineage.spark.agent.lifecycle.Spark35DatasetBuilderFactory";

    public static DatasetBuilderFactory getInstance() {
        String version = package$.MODULE$.SPARK_VERSION();
        try {
            return (DatasetBuilderFactory)Class.forName(DatasetBuilderFactoryProvider.getDatasetBuilderFactoryForVersion(version)).newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Can't instantiate dataset builder factory factory for version: %s", version), e);
        }
    }

    static String getDatasetBuilderFactoryForVersion(String version) {
        if (version.startsWith("2.")) {
            return SPARK2_FACTORY_NAME;
        }
        if (version.startsWith("3.2")) {
            return SPARK32_FACTORY_NAME;
        }
        if (version.startsWith("3.3")) {
            return SPARK33_FACTORY_NAME;
        }
        if (version.startsWith("3.4")) {
            return SPARK34_FACTORY_NAME;
        }
        if (version.startsWith("3.5")) {
            return SPARK35_FACTORY_NAME;
        }
        return SPARK3_FACTORY_NAME;
    }
}

