/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.spark.agent.lifecycle;

import io.openlineage.client.OpenLineage;
import io.openlineage.spark.agent.EventEmitter;
import io.openlineage.spark.agent.Versions;
import io.openlineage.spark.agent.lifecycle.ExecutionContext;
import io.openlineage.spark.agent.lifecycle.InternalEventHandlerFactory;
import io.openlineage.spark.agent.lifecycle.OpenLineageRunEventBuilder;
import io.openlineage.spark.agent.lifecycle.RddExecutionContext;
import io.openlineage.spark.agent.lifecycle.SparkSQLExecutionContext;
import io.openlineage.spark.api.OpenLineageContext;
import io.openlineage.spark.api.OpenLineageEventHandlerFactory;
import java.lang.reflect.InvocationTargetException;
import java.util.Optional;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.execution.QueryExecution;
import org.apache.spark.sql.execution.SQLExecution;
import org.apache.spark.sql.execution.ui.SparkListenerSQLExecutionEnd;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextFactory {
    private static final Logger log = LoggerFactory.getLogger(ContextFactory.class);
    public final EventEmitter openLineageEventEmitter;
    private final OpenLineageEventHandlerFactory handlerFactory;

    public ContextFactory(EventEmitter openLineageEventEmitter) {
        this.openLineageEventEmitter = openLineageEventEmitter;
        this.handlerFactory = new InternalEventHandlerFactory();
    }

    public ExecutionContext createRddExecutionContext(int jobId) {
        return new RddExecutionContext(this.openLineageEventEmitter);
    }

    public Optional<ExecutionContext> createSparkSQLExecutionContext(long executionId) {
        return Optional.ofNullable(SQLExecution.getQueryExecution((long)executionId)).map(queryExecution -> {
            SparkSession sparkSession = queryExecution.sparkSession();
            OpenLineageContext olContext = OpenLineageContext.builder().sparkSession(Optional.of(sparkSession)).sparkContext(sparkSession.sparkContext()).openLineage(new OpenLineage(Versions.OPEN_LINEAGE_PRODUCER_URI)).queryExecution((QueryExecution)queryExecution).customEnvironmentVariables(this.openLineageEventEmitter.getCustomEnvironmentVariables()).build();
            OpenLineageRunEventBuilder runEventBuilder = new OpenLineageRunEventBuilder(olContext, this.handlerFactory);
            return new SparkSQLExecutionContext(executionId, this.openLineageEventEmitter, olContext, runEventBuilder);
        });
    }

    public Optional<ExecutionContext> createSparkSQLExecutionContext(SparkListenerSQLExecutionEnd event) {
        return ContextFactory.executionFromCompleteEvent(event).map(queryExecution -> {
            SparkSession sparkSession = queryExecution.sparkSession();
            OpenLineageContext olContext = OpenLineageContext.builder().sparkSession(Optional.of(sparkSession)).sparkContext(sparkSession.sparkContext()).openLineage(new OpenLineage(Versions.OPEN_LINEAGE_PRODUCER_URI)).queryExecution((QueryExecution)queryExecution).customEnvironmentVariables(this.openLineageEventEmitter.getCustomEnvironmentVariables()).build();
            OpenLineageRunEventBuilder runEventBuilder = new OpenLineageRunEventBuilder(olContext, this.handlerFactory);
            return new SparkSQLExecutionContext(event.executionId(), this.openLineageEventEmitter, olContext, runEventBuilder);
        });
    }

    public static Optional<QueryExecution> executionFromCompleteEvent(SparkListenerSQLExecutionEnd event) {
        try {
            return Optional.of((QueryExecution)MethodUtils.invokeMethod((Object)event, "qe", null));
        }
        catch (NoSuchMethodException e) {
            return Optional.empty();
        }
        catch (ClassCastException | IllegalAccessException | InvocationTargetException e) {
            log.warn("Invoking qe method failed", (Throwable)e);
            return Optional.empty();
        }
    }
}

