/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.spark.agent.hooks;

import io.openlineage.client.OpenLineage;
import io.openlineage.spark.agent.hooks.RunEventBuilderHook;
import io.openlineage.spark.agent.util.DatabricksUtils;
import io.openlineage.spark.api.OpenLineageContext;

public class JobNameHook
implements RunEventBuilderHook {
    public static final String SPARK_CONF_JOB_NAME_APPEND_DATASET_NAME = "spark.openlineage.jobName.appendDatasetName";
    public static final String SPARK_CONF_JOB_NAME_REPLACE_DOT_WITH_UNDERSCORE = "spark.openlineage.jobName.replaceDotWithUnderscore";
    private static final String JOB_NAME_PARTS_SEPARATOR = ".";
    private static final String INNER_SEPARATOR = "_";
    private final OpenLineageContext openLineageContext;

    public JobNameHook(OpenLineageContext openLineageContext) {
        this.openLineageContext = openLineageContext;
    }

    @Override
    public void preBuild(OpenLineage.RunEventBuilder runEventBuilder) {
        if (this.openLineageContext != null && this.openLineageContext.getSparkContext() != null && this.openLineageContext.getSparkContext().conf() != null && !Boolean.valueOf(this.openLineageContext.getSparkContext().conf().get(SPARK_CONF_JOB_NAME_APPEND_DATASET_NAME, "true")).booleanValue()) {
            return;
        }
        OpenLineage.RunEvent runEvent = runEventBuilder.build();
        OpenLineage.Job job = runEvent.getJob();
        OpenLineage.Job newJob = this.openLineageContext.getOpenLineage().newJobBuilder().facets(job.getFacets()).namespace(job.getNamespace()).name(this.buildJobName(job, runEvent)).build();
        runEventBuilder.job(newJob);
    }

    private String buildJobName(OpenLineage.Job job, OpenLineage.RunEvent runEvent) {
        if (!this.openLineageContext.getJobName().isEmpty()) {
            return this.openLineageContext.getJobName().get(0);
        }
        StringBuilder jobNameBuilder = new StringBuilder();
        if (!DatabricksUtils.isRunOnDatabricksPlatform(this.openLineageContext)) {
            jobNameBuilder.append(job.getName());
        } else {
            jobNameBuilder.append(DatabricksUtils.prettifyDatabricksJobName(this.openLineageContext, job.getName()));
        }
        if (runEvent.getOutputs() != null && runEvent.getOutputs().size() > 0) {
            jobNameBuilder.append(JOB_NAME_PARTS_SEPARATOR).append(JobNameHook.trimPath(runEvent.getOutputs().get(0).getName()).replace(JOB_NAME_PARTS_SEPARATOR, INNER_SEPARATOR));
        }
        String jobName = jobNameBuilder.toString();
        if (this.openLineageContext != null && this.openLineageContext.getSparkContext() != null && this.openLineageContext.getSparkContext().conf() != null && Boolean.valueOf(this.openLineageContext.getSparkContext().conf().get(SPARK_CONF_JOB_NAME_REPLACE_DOT_WITH_UNDERSCORE, "false")).booleanValue()) {
            jobName = jobName.replace(JOB_NAME_PARTS_SEPARATOR, INNER_SEPARATOR);
        }
        this.openLineageContext.getJobName().add(jobName);
        return jobName;
    }

    private static String trimPath(String path) {
        if (path.lastIndexOf("/") > 0) {
            String[] parts = path.split("/");
            if (parts.length >= 2) {
                return parts[parts.length - 2] + INNER_SEPARATOR + parts[parts.length - 1];
            }
            return parts[parts.length - 1];
        }
        return path;
    }
}

