/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.spark.agent.filters;

import io.openlineage.spark.agent.filters.EventFilter;
import io.openlineage.spark.agent.filters.EventFilterUtils;
import io.openlineage.spark.api.OpenLineageContext;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.spark.scheduler.SparkListenerEvent;
import org.apache.spark.scheduler.SparkListenerJobEnd;
import org.apache.spark.scheduler.SparkListenerJobStart;
import org.apache.spark.sql.catalyst.plans.logical.Filter;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.plans.logical.SerializeFromObject;
import org.apache.spark.sql.execution.LogicalRDD;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.collection.JavaConverters;
import scala.collection.Seq;

public class DeltaEventFilter
implements EventFilter {
    private static final Logger log = LoggerFactory.getLogger(DeltaEventFilter.class);
    private final OpenLineageContext context;
    private static final List<String> DELTA_INTERNAL_RDD_COLUMNS = Arrays.asList("txn", "add", "remove", "metaData", "cdc", "protocol", "commitInfo");
    private static final List<String> DELTA_LOG_INTERNAL_COLUMNS = Arrays.asList("protocol", "metaData", "action_sort_column");

    public DeltaEventFilter(OpenLineageContext context) {
        this.context = context;
    }

    @Override
    public boolean isDisabled(SparkListenerEvent event) {
        if (!EventFilterUtils.isDeltaPlan()) {
            return false;
        }
        return this.isFilterRoot() || this.isLocalRelationOnly() || this.isLogicalRDDWithInternalDataColumns() || this.isDeltaLogProjection() || this.isSerializeFromObject() || this.isOnJobStartOrEnd(event);
    }

    private boolean isOnJobStartOrEnd(SparkListenerEvent event) {
        return event instanceof SparkListenerJobStart || event instanceof SparkListenerJobEnd;
    }

    private boolean isLocalRelationOnly() {
        return EventFilterUtils.getLogicalPlan(this.context).filter(plan -> plan.children() != null).filter(plan -> plan.children().size() == 0).filter(plan -> plan instanceof LocalRelation).isPresent();
    }

    private boolean isFilterRoot() {
        return EventFilterUtils.getLogicalPlan(this.context).filter(plan -> plan instanceof Filter).isPresent();
    }

    private boolean isDeltaLogProjection() {
        return EventFilterUtils.getLogicalPlan(this.context).filter(plan -> plan instanceof Project).map(project -> (List)JavaConverters.seqAsJavaListConverter((Seq)project.output()).asJava()).map(attributes -> attributes.stream().map(a -> a.name()).collect(Collectors.toList()).containsAll(DELTA_LOG_INTERNAL_COLUMNS)).orElse(false);
    }

    private boolean isLogicalRDDWithInternalDataColumns() {
        return EventFilterUtils.getLogicalPlan(this.context).map(plan -> ((List)JavaConverters.seqAsJavaListConverter((Seq)plan.collectLeaves()).asJava()).stream().filter(node -> node instanceof LogicalRDD).map(node -> (LogicalRDD)node).map(node -> (List)JavaConverters.seqAsJavaListConverter((Seq)node.output()).asJava()).map(attributes -> attributes.stream().map(a -> a.name()).collect(Collectors.toList())).filter(attrs -> attrs.containsAll(DELTA_INTERNAL_RDD_COLUMNS)).findAny().isPresent()).orElse(false);
    }

    private boolean isSerializeFromObject() {
        return EventFilterUtils.getLogicalPlan(this.context).map(plan -> plan instanceof SerializeFromObject).orElse(false);
    }
}

