/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.spark.agent.filters;

import io.openlineage.spark.agent.filters.EventFilter;
import io.openlineage.spark.agent.filters.EventFilterUtils;
import io.openlineage.spark.agent.util.DatabricksUtils;
import io.openlineage.spark.api.OpenLineageContext;
import java.util.Arrays;
import java.util.List;
import org.apache.spark.scheduler.SparkListenerEvent;
import org.apache.spark.sql.catalyst.plans.logical.SerializeFromObject;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.WholeStageCodegenExec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabricksEventFilter
implements EventFilter {
    private static final Logger log = LoggerFactory.getLogger(DatabricksEventFilter.class);
    private final OpenLineageContext context;
    private static final List<String> excludedNodes = Arrays.asList("collect_limit", "describe_table", "local_table_scan", "serialize_from_object", "execute_set_catalog_command");

    public DatabricksEventFilter(OpenLineageContext context) {
        this.context = context;
    }

    @Override
    public boolean isDisabled(SparkListenerEvent event) {
        return this.isSerializeFromObject() || this.isWriteIntoDeltaCommand() || this.isDisabledDatabricksPlan(event);
    }

    public boolean isDisabledDatabricksPlan(SparkListenerEvent event) {
        if (!DatabricksUtils.isRunOnDatabricksPlatform(this.context) || !this.context.getQueryExecution().isPresent()) {
            return false;
        }
        SparkPlan node = this.context.getQueryExecution().get().executedPlan();
        if (node instanceof WholeStageCodegenExec) {
            node = ((WholeStageCodegenExec)node).child();
        }
        String nodeName = node.nodeName().replace("_", "");
        return excludedNodes.stream().map(n -> n.replace("_", "")).filter(n -> n.equalsIgnoreCase(nodeName)).findAny().isPresent();
    }

    private boolean isSerializeFromObject() {
        return EventFilterUtils.getLogicalPlan(this.context).map(plan -> plan instanceof SerializeFromObject).orElse(false);
    }

    private boolean isWriteIntoDeltaCommand() {
        return EventFilterUtils.getLogicalPlan(this.context).map(plan -> plan.getClass().getCanonicalName().contains("sql.transaction.tahoe.commands.WriteIntoDeltaCommand")).orElse(false);
    }
}

