/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.spark.agent.facets.builder;

import io.openlineage.spark.agent.facets.SparkPropertyFacet;
import io.openlineage.spark.api.CustomFacetBuilder;
import io.openlineage.spark.api.OpenLineageContext;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.spark.SparkConf;
import org.apache.spark.scheduler.SparkListenerJobStart;

public class SparkPropertyFacetBuilder
extends CustomFacetBuilder<SparkListenerJobStart, SparkPropertyFacet> {
    private static final Set<String> DEFAULT_ALLOWED_PROPERTIES = new HashSet<String>(Arrays.asList("spark.master", "spark.app.name"));
    private static final String ALLOWED_PROPERTIES_KEY = "spark.openlineage.capturedProperties";
    private final SparkConf conf;
    private final Set<String> allowerProperties;

    public SparkPropertyFacetBuilder(OpenLineageContext context) {
        this.conf = context.getSparkContext().getConf();
        this.allowerProperties = this.conf.contains(ALLOWED_PROPERTIES_KEY) ? Arrays.stream(this.conf.get(ALLOWED_PROPERTIES_KEY).split(",")).collect(Collectors.toSet()) : DEFAULT_ALLOWED_PROPERTIES;
    }

    @Override
    protected void build(SparkListenerJobStart event, BiConsumer<String, ? super SparkPropertyFacet> consumer) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        Arrays.stream(this.conf.getAll()).filter(t -> this.allowerProperties.contains(t._1)).forEach(t -> m.putIfAbsent((String)t._1, t._2));
        event.properties().entrySet().stream().filter(e -> this.allowerProperties.contains(e.getKey())).forEach(e -> m.putIfAbsent(e.getKey().toString(), e.getValue()));
        consumer.accept("spark_properties", new SparkPropertyFacet(m));
    }
}

