/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.spark.agent.facets.builder;

import io.openlineage.spark.agent.facets.DebugRunFacet;
import io.openlineage.spark.agent.util.ScalaConversionUtils;
import io.openlineage.spark.api.OpenLineageContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.SystemUtils;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import scala.util.Properties;

public class DebugRunFacetBuilderDelegate {
    private final OpenLineageContext olContext;
    private static List<String> classesToDebug = Arrays.asList("org.apache.spark.sql.delta.catalog.DeltaCatalog", "org.apache.iceberg.catalog.Catalog", "com.google.cloud.spark.bigquery.BigQueryRelation");

    public DebugRunFacetBuilderDelegate(OpenLineageContext olContext) {
        this.olContext = olContext;
    }

    protected DebugRunFacet buildFacet() {
        return new DebugRunFacet(this.buildSparkConfigDebugFacet(), this.buildClasspathDebugFacet(), this.buildSystemDebugFacet(), this.buildLogicalPlanDebugFacet());
    }

    private DebugRunFacet.SparkConfigDebugFacet buildSparkConfigDebugFacet() {
        return DebugRunFacet.SparkConfigDebugFacet.builder().extraListeners(this.getSparkConfOrNull("spark.extraListeners")).openLineageConfig(this.getOpenLineageConfig()).catalogClass(this.getCatalogClass()).extensions(this.getSparkConfOrNull("spark.sql.extensions")).build();
    }

    private DebugRunFacet.ClasspathDebugFacet buildClasspathDebugFacet() {
        return DebugRunFacet.ClasspathDebugFacet.builder().openLineageVersion(this.toClasspathDebugClassDetails(this.getClass().getCanonicalName()).getPackageVersion()).sparkVersion(this.olContext.getSparkVersion()).scalaVersion(Properties.versionNumberString()).jars(this.getSparkJars()).classDetails(classesToDebug.stream().map(this::toClasspathDebugClassDetails).collect(Collectors.toList())).build();
    }

    private List<String> getSparkJars() {
        return Optional.ofNullable(this.olContext.getSparkContext()).map(sc -> sc.listJars()).map(jars -> ScalaConversionUtils.fromSeq(jars)).orElse(null);
    }

    private DebugRunFacet.SystemDebugFacet buildSystemDebugFacet() {
        return DebugRunFacet.SystemDebugFacet.builder().sparkDeployMode(this.getDeployMode()).javaVersion(SystemUtils.JAVA_VERSION).javaVendor(SystemUtils.JAVA_VENDOR).osArch(SystemUtils.OS_ARCH).osName(SystemUtils.OS_NAME).osVersion(SystemUtils.OS_VERSION).userLanguage(SystemUtils.USER_LANGUAGE).userTimezone(SystemUtils.USER_TIMEZONE).build();
    }

    private DebugRunFacet.LogicalPlanDebugFacet buildLogicalPlanDebugFacet() {
        return this.olContext.getQueryExecution().map(qe -> qe.optimizedPlan()).map(plan -> this.scanLogicalPlan((LogicalPlan)plan)).map(list -> new DebugRunFacet.LogicalPlanDebugFacet((List<DebugRunFacet.LogicalPlanNode>)list)).orElse(null);
    }

    private List<DebugRunFacet.LogicalPlanNode> scanLogicalPlan(LogicalPlan node) {
        ArrayList<DebugRunFacet.LogicalPlanNode> result = new ArrayList<DebugRunFacet.LogicalPlanNode>();
        DebugRunFacet.LogicalPlanNode.LogicalPlanNodeBuilder builder = DebugRunFacet.LogicalPlanNode.builder().id(this.nodeId(node)).desc(node.toString());
        if (node.children() != null) {
            builder.children(ScalaConversionUtils.fromSeq(node.children()).stream().map(this::nodeId).collect(Collectors.toList()));
        }
        result.add(builder.build());
        if (node.children() != null) {
            ScalaConversionUtils.fromSeq(node.children()).stream().forEach(child -> result.addAll(this.scanLogicalPlan((LogicalPlan)child)));
        }
        return result;
    }

    private String nodeId(LogicalPlan node) {
        return String.format("%s@%s", node.nodeName(), node.hashCode());
    }

    private String getDeployMode() {
        return Optional.ofNullable(this.olContext.getSparkContext()).map(sc -> sc.deployMode()).orElse(null);
    }

    private String getSparkConfOrNull(String confKey) {
        return Optional.ofNullable(this.olContext.getSparkContext()).map(sc -> sc.conf()).map(c -> c.get(confKey, null)).orElse(null);
    }

    private Map<String, String> getOpenLineageConfig() {
        return Optional.ofNullable(this.olContext.getSparkContext()).map(sc -> sc.conf()).map(conf -> conf.getAllWithPrefix("spark.openlineage.")).map(arr -> Arrays.stream(arr)).map(stream -> stream.filter(tuple -> !((String)tuple._1()).toLowerCase().contains("key")).collect(Collectors.toMap(t -> (String)t._1(), t -> (String)t._2()))).orElse(Collections.emptyMap());
    }

    private String getCatalogClass() {
        return this.olContext.getSparkSession().map(sparkSession -> sparkSession.catalog()).map(catalog -> catalog.getClass().getCanonicalName()).orElse(null);
    }

    private boolean isOnClassPath(String aClass) {
        try {
            this.getClass().getClassLoader().loadClass(aClass);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private DebugRunFacet.ClasspathDebugClassDetails toClasspathDebugClassDetails(String aClass) {
        DebugRunFacet.ClasspathDebugClassDetails.ClasspathDebugClassDetailsBuilder builder = DebugRunFacet.ClasspathDebugClassDetails.builder();
        builder.className(aClass);
        try {
            Class<?> clazz = this.getClass().getClassLoader().loadClass(aClass);
            String aClassPackage = Optional.ofNullable(clazz).map(c -> c.getPackage()).map(p -> p.getImplementationVersion()).orElse(null);
            builder.isOnClasspath(true).packageVersion(aClassPackage);
        }
        catch (Exception e) {
            builder.isOnClasspath(false);
        }
        return builder.build();
    }
}

