/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.spark.agent.facets.builder;

import com.databricks.backend.daemon.dbutils.MountInfo;
import com.databricks.dbutils_v1.DbfsUtils;
import io.openlineage.spark.agent.facets.EnvironmentFacet;
import io.openlineage.spark.agent.models.DatabricksMountpoint;
import io.openlineage.spark.api.CustomFacetBuilder;
import io.openlineage.spark.api.OpenLineageContext;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import org.apache.spark.scheduler.SparkListenerJobStart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.collection.JavaConversions;
import scala.collection.Seq;

public class DatabricksEnvironmentFacetBuilder
extends CustomFacetBuilder<SparkListenerJobStart, EnvironmentFacet> {
    private static final Logger log = LoggerFactory.getLogger(DatabricksEnvironmentFacetBuilder.class);
    private Map<String, Object> dbProperties;
    private Class dbutilsClass;
    private DbfsUtils dbutils;

    public static boolean isDatabricksRuntime() {
        return System.getenv().containsKey("DATABRICKS_RUNTIME_VERSION");
    }

    public DatabricksEnvironmentFacetBuilder() {
    }

    public DatabricksEnvironmentFacetBuilder(OpenLineageContext openLineageContext) {
        this.dbProperties = new HashMap<String, Object>();
        openLineageContext.getCustomEnvironmentVariables().ifPresent(envVars -> envVars.forEach(envVar -> this.dbProperties.put((String)envVar, System.getenv().get(envVar))));
    }

    @Override
    protected void build(SparkListenerJobStart event, BiConsumer<String, ? super EnvironmentFacet> consumer) {
        consumer.accept("environment-properties", new EnvironmentFacet(this.getDatabricksEnvironmentalAttributes(event)));
    }

    private Map<String, Object> getDatabricksEnvironmentalAttributes(SparkListenerJobStart jobStart) {
        if (this.dbProperties == null) {
            this.dbProperties = new HashMap<String, Object>();
        }
        List<String> dbPropertiesKeys = Arrays.asList("orgId", "spark.databricks.clusterUsageTags.clusterOwnerOrgId", "spark.databricks.notebook.path", "spark.databricks.job.type", "spark.databricks.job.id", "spark.databricks.job.runId", "user", "userId", "spark.databricks.clusterUsageTags.clusterName", "spark.databricks.clusterUsageTags.clusterAllTags", "spark.databricks.clusterUsageTags.azureSubscriptionId");
        dbPropertiesKeys.stream().forEach(p -> this.dbProperties.put((String)p, jobStart.properties().getProperty((String)p)));
        try {
            Optional<DbfsUtils> dbfsUtils = DatabricksEnvironmentFacetBuilder.getDbfsUtils();
            if (!dbfsUtils.isPresent()) {
                this.dbProperties.put("mountPoints", new ArrayList());
            } else {
                this.dbProperties.put("mountPoints", DatabricksEnvironmentFacetBuilder.getDatabricksMountpoints(dbfsUtils.get()));
            }
        }
        catch (Exception e) {
            log.warn("Failed to load dbutils in OpenLineageListener:", (Throwable)e);
            this.dbProperties.put("mountPoints", new ArrayList());
        }
        return this.dbProperties;
    }

    private static Optional<DbfsUtils> getDbfsUtils() throws ClassNotFoundException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Class<?> dbutilsClass = Class.forName("com.databricks.dbutils_v1.impl.DbfsUtilsImpl");
        Constructor<?>[] dbutilsConstructors = dbutilsClass.getDeclaredConstructors();
        if (dbutilsConstructors.length == 0) {
            log.warn("Failed to load dbutils in OpenLineageListener as there were no declared constructors");
            return Optional.empty();
        }
        Constructor<?> firstConstructor = dbutilsConstructors[0];
        Parameter[] constructorParams = firstConstructor.getParameters();
        if (constructorParams.length == 0) {
            log.debug("DbUtils constructor had no parameters");
            return Optional.of((DbfsUtils)firstConstructor.newInstance(new Object[0]));
        }
        if (constructorParams.length == 1 && constructorParams[0].getName().equals("allowMountOperations")) {
            log.debug("DbUtils constructor had one parameter named allowMountOperations");
            return Optional.of((DbfsUtils)firstConstructor.newInstance(true));
        }
        log.warn("dbutils had {} constructors and the first constructor had {} params", (Object)dbutilsConstructors.length, (Object)constructorParams.length);
        return Optional.empty();
    }

    private static List<DatabricksMountpoint> getDatabricksMountpoints(DbfsUtils dbutils) {
        ArrayList<DatabricksMountpoint> mountpoints = new ArrayList<DatabricksMountpoint>();
        List mountsList = JavaConversions.seqAsJavaList((Seq)dbutils.mounts());
        for (MountInfo mount : mountsList) {
            mountpoints.add(new DatabricksMountpoint(mount.mountPoint(), mount.source()));
        }
        return mountpoints;
    }
}

