/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.spark.agent;

import io.openlineage.spark.shaded.org.apache.hc.core5.http.NameValuePair;
import io.openlineage.spark.shaded.org.apache.hc.core5.net.URLEncodedUtils;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UrlParser {
    private static final Logger log = LoggerFactory.getLogger(UrlParser.class);
    public static final String SPARK_CONF_API_ENDPOINT = "spark.openlineage.transport.endpoint";
    public static final String SPARK_CONF_TIMEOUT = "spark.openlineage.transport.timeout";
    public static final String SPARK_CONF_API_KEY = "spark.openlineage.transport.auth.apiKey";
    public static final String SPARK_CONF_AUTH_TYPE = "spark.openlineage.transport.auth.type";
    public static final String SPARK_CONF_URL_PARAM_PREFIX = "spark.openlineage.transport.urlParams";
    public static final String SPARK_CONF_HTTP_URL = "spark.openlineage.transport.url";
    public static final String SPARK_CONF_DISABLED_FACETS = "spark.openlineage.facets.disabled.";
    public static final Set<String> namedParams = new HashSet<String>(Arrays.asList("timeout", "api_key", "app_name", "disabled"));

    public static Map<String, String> parseUrl(String clientUrl) {
        URI uri = URI.create(clientUrl);
        String path = uri.getPath();
        String[] elements = path.split("/");
        List<NameValuePair> nameValuePairList = URLEncodedUtils.parse(uri, StandardCharsets.UTF_8);
        HashMap<String, String> parsedProperties = new HashMap<String, String>();
        parsedProperties.put(SPARK_CONF_HTTP_URL, uri.getScheme() + "://" + uri.getAuthority());
        UrlParser.get(elements, "namespaces", 3).ifPresent(p -> parsedProperties.put("spark.openlineage.namespace", (String)p));
        UrlParser.get(elements, "jobs", 5).ifPresent(p -> parsedProperties.put("spark.openlineage.parentJobName", (String)p));
        UrlParser.get(elements, "runs", 7).ifPresent(p -> parsedProperties.put("spark.openlineage.parentRunId", (String)p));
        UrlParser.get(elements, "api", 1).ifPresent(p -> parsedProperties.put(SPARK_CONF_API_ENDPOINT, String.format("/api/%s/lineage", p)));
        UrlParser.getNamedStringParameter(nameValuePairList, "disabled").ifPresent(p -> parsedProperties.put(SPARK_CONF_DISABLED_FACETS, (String)p));
        UrlParser.getNamedStringParameter(nameValuePairList, "timeout").ifPresent(p -> parsedProperties.put(SPARK_CONF_TIMEOUT, (String)p));
        UrlParser.getNamedStringParameter(nameValuePairList, "api_key").ifPresent(p -> {
            parsedProperties.put(SPARK_CONF_API_KEY, (String)p);
            parsedProperties.put(SPARK_CONF_AUTH_TYPE, "api_key");
        });
        UrlParser.getNamedStringParameter(nameValuePairList, "app_name").ifPresent(p -> parsedProperties.put("spark.openlineage.appName", (String)p));
        UrlParser.getUrlParams(nameValuePairList).orElseGet(HashMap::new).forEach((key, value) -> parsedProperties.put(SPARK_CONF_URL_PARAM_PREFIX + key, (String)value));
        return parsedProperties;
    }

    private static Optional<String> getNamedStringParameter(List<NameValuePair> nameValuePairList, String name) {
        return Optional.ofNullable(UrlParser.getNamedParameter(nameValuePairList, name)).filter(xva$0 -> StringUtils.isNoneBlank(xva$0));
    }

    private static Optional<Map<String, String>> getUrlParams(List<NameValuePair> nameValuePairList) {
        HashMap urlParams = new HashMap();
        nameValuePairList.stream().filter(pair -> !namedParams.contains(pair.getName())).forEach(pair -> urlParams.put(pair.getName(), pair.getValue()));
        return urlParams.isEmpty() ? Optional.empty() : Optional.ofNullable(urlParams);
    }

    protected static String getNamedParameter(List<NameValuePair> nameValuePairList, String param) {
        for (NameValuePair nameValuePair : nameValuePairList) {
            if (!nameValuePair.getName().equalsIgnoreCase(param)) continue;
            return nameValuePair.getValue();
        }
        return null;
    }

    private static Optional<String> get(String[] elements, String name, int index) {
        boolean check;
        boolean bl = check = elements.length > index + 1 && name.equals(elements[index]);
        if (check) {
            return Optional.of(elements[index + 1]);
        }
        return Optional.empty();
    }
}

