/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.spark.agent;

import io.openlineage.client.OpenLineage;
import io.openlineage.client.OpenLineageClient;
import io.openlineage.client.OpenLineageClientException;
import io.openlineage.client.OpenLineageClientUtils;
import io.openlineage.client.transports.FacetsConfig;
import io.openlineage.client.transports.TransportFactory;
import io.openlineage.spark.agent.ArgumentParser;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventEmitter {
    private static final Logger log = LoggerFactory.getLogger(EventEmitter.class);
    private OpenLineageClient client;
    private Optional<String> appName;
    private String jobNamespace;
    private String parentJobName;
    private Optional<UUID> parentRunId;
    private Optional<List<String>> customEnvironmentVariables;

    public EventEmitter(ArgumentParser argument) throws URISyntaxException {
        this.jobNamespace = argument.getNamespace();
        this.parentJobName = argument.getJobName();
        this.parentRunId = EventEmitter.convertToUUID(argument.getParentRunId());
        this.appName = Optional.ofNullable(argument.getAppName());
        this.customEnvironmentVariables = argument.getOpenLineageYaml().getFacetsConfig() != null ? (argument.getOpenLineageYaml().getFacetsConfig().getCustomEnvironmentVariables() != null ? Optional.of(Arrays.asList(argument.getOpenLineageYaml().getFacetsConfig().getCustomEnvironmentVariables())) : Optional.empty()) : Optional.empty();
        String[] disabledFacets = Optional.ofNullable(argument.getOpenLineageYaml().getFacetsConfig()).orElse(new FacetsConfig().withDisabledFacets(new String[0])).getDisabledFacets();
        this.client = OpenLineageClient.builder().transport(new TransportFactory(argument.getOpenLineageYaml().getTransportConfig()).build()).disableFacets(disabledFacets).build();
    }

    public void emit(OpenLineage.RunEvent event) {
        try {
            this.client.emit(event);
            log.debug("Emitting lineage completed successfully: {}", (Object)OpenLineageClientUtils.toJson(event));
        }
        catch (OpenLineageClientException exception) {
            log.error("Could not emit lineage w/ exception", (Throwable)exception);
        }
    }

    private static Optional<UUID> convertToUUID(String uuid) {
        try {
            return Optional.ofNullable(uuid).map(UUID::fromString);
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public OpenLineageClient getClient() {
        return this.client;
    }

    public Optional<String> getAppName() {
        return this.appName;
    }

    public String getJobNamespace() {
        return this.jobNamespace;
    }

    public String getParentJobName() {
        return this.parentJobName;
    }

    public Optional<UUID> getParentRunId() {
        return this.parentRunId;
    }

    public Optional<List<String>> getCustomEnvironmentVariables() {
        return this.customEnvironmentVariables;
    }
}

