/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.spark.agent;

import io.openlineage.client.OpenLineageClientUtils;
import io.openlineage.client.OpenLineageYaml;
import io.openlineage.spark.agent.UrlParser;
import io.openlineage.spark.agent.util.SparkConfUtils;
import io.openlineage.spark.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import io.openlineage.spark.shaded.com.fasterxml.jackson.databind.node.ArrayNode;
import io.openlineage.spark.shaded.com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.spark.SparkConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;

public class ArgumentParser {
    private static final Logger log = LoggerFactory.getLogger(ArgumentParser.class);
    public static final String SPARK_CONF_NAMESPACE = "spark.openlineage.namespace";
    public static final String SPARK_CONF_JOB_NAME = "spark.openlineage.parentJobName";
    public static final String SPARK_CONF_PARENT_RUN_ID = "spark.openlineage.parentRunId";
    public static final String SPARK_CONF_APP_NAME = "spark.openlineage.appName";
    public static final String SPARK_CONF_DISABLED_FACETS = "spark.openlineage.facets.disabled";
    public static final String DEFAULT_DISABLED_FACETS = "[spark_unknown;]";
    public static final String ARRAY_PREFIX_CHAR = "[";
    public static final String ARRAY_SUFFIX_CHAR = "]";
    public static final String DISABLED_FACETS_SEPARATOR = ";";
    public static final String SPARK_CONF_TRANSPORT_TYPE = "spark.openlineage.transport.type";
    public static final String SPARK_CONF_HTTP_URL = "spark.openlineage.transport.url";
    public static final Set<String> PROPERTIES_PREFIXES = new HashSet<String>(Arrays.asList("transport.properties.", "transport.urlParams.", "transport.headers."));
    public static final String SPARK_CONF_CUSTOM_ENVIRONMENT_VARIABLES = "spark.openlineage.facets.custom_environment_variables";
    private String namespace;
    private String jobName;
    private String parentRunId;
    private String appName;
    private OpenLineageYaml openLineageYaml;

    public static ArgumentParser parse(SparkConf conf) {
        ArgumentParserBuilder builder = ArgumentParser.builder();
        conf.setIfMissing(SPARK_CONF_DISABLED_FACETS, DEFAULT_DISABLED_FACETS);
        conf.setIfMissing(SPARK_CONF_TRANSPORT_TYPE, "console");
        if (conf.get(SPARK_CONF_TRANSPORT_TYPE).equals("http")) {
            SparkConfUtils.findSparkConfigKey(conf, SPARK_CONF_HTTP_URL).ifPresent(url -> UrlParser.parseUrl(url).forEach((arg_0, arg_1) -> ((SparkConf)conf).set(arg_0, arg_1)));
        }
        SparkConfUtils.findSparkConfigKey(conf, SPARK_CONF_APP_NAME).filter(str -> !str.isEmpty()).ifPresent(builder::appName);
        SparkConfUtils.findSparkConfigKey(conf, SPARK_CONF_NAMESPACE).ifPresent(builder::namespace);
        SparkConfUtils.findSparkConfigKey(conf, SPARK_CONF_JOB_NAME).ifPresent(builder::jobName);
        SparkConfUtils.findSparkConfigKey(conf, SPARK_CONF_PARENT_RUN_ID).ifPresent(builder::parentRunId);
        builder.openLineageYaml(ArgumentParser.extractOpenlineageConfFromSparkConf(conf));
        return builder.build();
    }

    public static OpenLineageYaml extractOpenlineageConfFromSparkConf(SparkConf conf) {
        List<Tuple2<String, String>> properties = ArgumentParser.filterProperties(conf);
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode objectNode = objectMapper.createObjectNode();
        for (Tuple2<String, String> c : properties) {
            ObjectNode nodePointer = objectNode;
            String keyPath = (String)c._1;
            String value = (String)c._2;
            if (!StringUtils.isNotBlank(value)) continue;
            List<String> pathKeys = ArgumentParser.getJsonPath(keyPath);
            List<String> nonLeafs = pathKeys.subList(0, pathKeys.size() - 1);
            String leaf = pathKeys.get(pathKeys.size() - 1);
            for (String node : nonLeafs) {
                if (nodePointer.get(node) == null) {
                    nodePointer.putObject(node);
                }
                nodePointer = (ObjectNode)nodePointer.get(node);
            }
            if (ArgumentParser.isArrayType(value) || SPARK_CONF_DISABLED_FACETS.equals("spark.openlineage." + keyPath)) {
                ArrayNode arrayNode = nodePointer.putArray(leaf);
                String valueWithoutBrackets = ArgumentParser.isArrayType(value) ? value.substring(1, value.length() - 1) : value;
                Arrays.stream(valueWithoutBrackets.split(DISABLED_FACETS_SEPARATOR)).filter(StringUtils::isNotBlank).forEach(arrayNode::add);
                continue;
            }
            nodePointer.put(leaf, value);
        }
        try {
            return OpenLineageClientUtils.loadOpenLineageYaml(new ByteArrayInputStream(objectMapper.writeValueAsBytes(objectNode)));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static List<Tuple2<String, String>> filterProperties(SparkConf conf) {
        return Arrays.stream(conf.getAllWithPrefix("spark.openlineage.")).filter(e -> ((String)e._1).startsWith("transport") || ((String)e._1).startsWith("facets")).collect(Collectors.toList());
    }

    private static List<String> getJsonPath(String keyPath) {
        Optional<String> propertyPath = PROPERTIES_PREFIXES.stream().filter(keyPath::startsWith).findAny();
        List pathKeys = propertyPath.map(s -> {
            ArrayList<String> path = new ArrayList<String>(Arrays.asList(s.split("\\.")));
            path.add(keyPath.replaceFirst((String)s, ""));
            return path;
        }).orElseGet(() -> Arrays.asList(keyPath.split("\\.")));
        return pathKeys;
    }

    private static boolean isArrayType(String value) {
        return value.startsWith(ARRAY_PREFIX_CHAR) && value.endsWith(ARRAY_SUFFIX_CHAR) && value.contains(DISABLED_FACETS_SEPARATOR);
    }

    private static String $default$namespace() {
        return "default";
    }

    private static String $default$jobName() {
        return "default";
    }

    private static String $default$parentRunId() {
        return null;
    }

    private static String $default$appName() {
        return null;
    }

    private static OpenLineageYaml $default$openLineageYaml() {
        return new OpenLineageYaml();
    }

    public static ArgumentParserBuilder builder() {
        return new ArgumentParserBuilder();
    }

    public ArgumentParser(String namespace, String jobName, String parentRunId, String appName, OpenLineageYaml openLineageYaml) {
        this.namespace = namespace;
        this.jobName = jobName;
        this.parentRunId = parentRunId;
        this.appName = appName;
        this.openLineageYaml = openLineageYaml;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getJobName() {
        return this.jobName;
    }

    public String getParentRunId() {
        return this.parentRunId;
    }

    public String getAppName() {
        return this.appName;
    }

    public OpenLineageYaml getOpenLineageYaml() {
        return this.openLineageYaml;
    }

    public String toString() {
        return "ArgumentParser(namespace=" + this.getNamespace() + ", jobName=" + this.getJobName() + ", parentRunId=" + this.getParentRunId() + ", appName=" + this.getAppName() + ", openLineageYaml=" + this.getOpenLineageYaml() + ")";
    }

    public static class ArgumentParserBuilder {
        private boolean namespace$set;
        private String namespace$value;
        private boolean jobName$set;
        private String jobName$value;
        private boolean parentRunId$set;
        private String parentRunId$value;
        private boolean appName$set;
        private String appName$value;
        private boolean openLineageYaml$set;
        private OpenLineageYaml openLineageYaml$value;

        ArgumentParserBuilder() {
        }

        public ArgumentParserBuilder namespace(String namespace) {
            this.namespace$value = namespace;
            this.namespace$set = true;
            return this;
        }

        public ArgumentParserBuilder jobName(String jobName) {
            this.jobName$value = jobName;
            this.jobName$set = true;
            return this;
        }

        public ArgumentParserBuilder parentRunId(String parentRunId) {
            this.parentRunId$value = parentRunId;
            this.parentRunId$set = true;
            return this;
        }

        public ArgumentParserBuilder appName(String appName) {
            this.appName$value = appName;
            this.appName$set = true;
            return this;
        }

        public ArgumentParserBuilder openLineageYaml(OpenLineageYaml openLineageYaml) {
            this.openLineageYaml$value = openLineageYaml;
            this.openLineageYaml$set = true;
            return this;
        }

        public ArgumentParser build() {
            String namespace$value = this.namespace$value;
            if (!this.namespace$set) {
                namespace$value = ArgumentParser.$default$namespace();
            }
            String jobName$value = this.jobName$value;
            if (!this.jobName$set) {
                jobName$value = ArgumentParser.$default$jobName();
            }
            String parentRunId$value = this.parentRunId$value;
            if (!this.parentRunId$set) {
                parentRunId$value = ArgumentParser.$default$parentRunId();
            }
            String appName$value = this.appName$value;
            if (!this.appName$set) {
                appName$value = ArgumentParser.$default$appName();
            }
            OpenLineageYaml openLineageYaml$value = this.openLineageYaml$value;
            if (!this.openLineageYaml$set) {
                openLineageYaml$value = ArgumentParser.$default$openLineageYaml();
            }
            return new ArgumentParser(namespace$value, jobName$value, parentRunId$value, appName$value, openLineageYaml$value);
        }

        public String toString() {
            return "ArgumentParser.ArgumentParserBuilder(namespace$value=" + this.namespace$value + ", jobName$value=" + this.jobName$value + ", parentRunId$value=" + this.parentRunId$value + ", appName$value=" + this.appName$value + ", openLineageYaml$value=" + this.openLineageYaml$value + ")";
        }
    }
}

