/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.client.transports;

import io.openlineage.client.OpenLineage;
import io.openlineage.client.OpenLineageClientUtils;
import io.openlineage.client.transports.FileConfig;
import io.openlineage.client.transports.Transport;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import lombok.NonNull;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileTransport
extends Transport {
    private static final Logger log = LoggerFactory.getLogger(FileTransport.class);
    File file;

    public FileTransport(@NonNull FileConfig fileConfig) {
        super(Transport.Type.FILE);
        if (fileConfig == null) {
            throw new NullPointerException("fileConfig is marked non-null but is null");
        }
        this.file = new File(fileConfig.getLocation());
    }

    @Override
    public void emit(OpenLineage.RunEvent runEvent) {
        this.emit(OpenLineageClientUtils.toJson(runEvent));
    }

    @Override
    public void emit(String eventAsJson) {
        try {
            FileUtils.writeStringToFile((File)this.file, (String)(eventAsJson.replace(System.lineSeparator(), "") + System.lineSeparator()), (Charset)StandardCharsets.UTF_8, (boolean)true);
            log.info("emitted event: " + eventAsJson);
        }
        catch (IOException | IllegalArgumentException e) {
            log.error("Writing event to a file {} failed: {}", (Object)this.file.getPath(), (Object)e);
        }
    }
}

