/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.client;

import io.openlineage.spark.shaded.com.fasterxml.jackson.annotation.JsonAnyGetter;
import io.openlineage.spark.shaded.com.fasterxml.jackson.annotation.JsonAnySetter;
import io.openlineage.spark.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import io.openlineage.spark.shaded.com.fasterxml.jackson.annotation.JsonIgnore;
import io.openlineage.spark.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import io.openlineage.spark.shaded.com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.openlineage.spark.shaded.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public final class OpenLineage {
    private final URI producer;

    public OpenLineage(URI producer) {
        this.producer = producer;
    }

    public RunEvent newRunEvent(ZonedDateTime eventTime, RunEvent.EventType eventType, Run run, Job job, List<InputDataset> inputs, List<OutputDataset> outputs) {
        return new RunEvent(eventTime, this.producer, eventType, run, job, inputs, outputs);
    }

    public RunEventBuilder newRunEventBuilder() {
        return new RunEventBuilder();
    }

    public SchemaDatasetFacetFields newSchemaDatasetFacetFields(String name, String type, String description) {
        return new SchemaDatasetFacetFields(name, type, description);
    }

    public SchemaDatasetFacetFieldsBuilder newSchemaDatasetFacetFieldsBuilder() {
        return new SchemaDatasetFacetFieldsBuilder();
    }

    public ParentRunFacet newParentRunFacet(ParentRunFacetRun run, ParentRunFacetJob job) {
        return new ParentRunFacet(this.producer, run, job);
    }

    public ParentRunFacetBuilder newParentRunFacetBuilder() {
        return new ParentRunFacetBuilder();
    }

    public OutputStatisticsOutputDatasetFacet newOutputStatisticsOutputDatasetFacet(Long rowCount, Long size) {
        return new OutputStatisticsOutputDatasetFacet(this.producer, rowCount, size);
    }

    public OutputStatisticsOutputDatasetFacetBuilder newOutputStatisticsOutputDatasetFacetBuilder() {
        return new OutputStatisticsOutputDatasetFacetBuilder();
    }

    public ExtractionErrorRunFacetErrors newExtractionErrorRunFacetErrors(String errorMessage, String stackTrace, String task, Long taskNumber) {
        return new ExtractionErrorRunFacetErrors(errorMessage, stackTrace, task, taskNumber);
    }

    public ExtractionErrorRunFacetErrorsBuilder newExtractionErrorRunFacetErrorsBuilder() {
        return new ExtractionErrorRunFacetErrorsBuilder();
    }

    public Run newRun(UUID runId, RunFacets facets) {
        return new Run(runId, facets);
    }

    public RunBuilder newRunBuilder() {
        return new RunBuilder();
    }

    public DataQualityMetricsInputDatasetFacetColumnMetricsAdditionalQuantiles newDataQualityMetricsInputDatasetFacetColumnMetricsAdditionalQuantiles() {
        return new DataQualityMetricsInputDatasetFacetColumnMetricsAdditionalQuantiles();
    }

    public DataQualityMetricsInputDatasetFacetColumnMetricsAdditionalQuantilesBuilder newDataQualityMetricsInputDatasetFacetColumnMetricsAdditionalQuantilesBuilder() {
        return new DataQualityMetricsInputDatasetFacetColumnMetricsAdditionalQuantilesBuilder();
    }

    public ExternalQueryRunFacet newExternalQueryRunFacet(String externalQueryId, String source) {
        return new ExternalQueryRunFacet(this.producer, externalQueryId, source);
    }

    public ExternalQueryRunFacetBuilder newExternalQueryRunFacetBuilder() {
        return new ExternalQueryRunFacetBuilder();
    }

    public OutputDatasetOutputFacets newOutputDatasetOutputFacets(OutputStatisticsOutputDatasetFacet outputStatistics) {
        return new OutputDatasetOutputFacets(outputStatistics);
    }

    public OutputDatasetOutputFacetsBuilder newOutputDatasetOutputFacetsBuilder() {
        return new OutputDatasetOutputFacetsBuilder();
    }

    public NominalTimeRunFacet newNominalTimeRunFacet(ZonedDateTime nominalStartTime, ZonedDateTime nominalEndTime) {
        return new NominalTimeRunFacet(this.producer, nominalStartTime, nominalEndTime);
    }

    public NominalTimeRunFacetBuilder newNominalTimeRunFacetBuilder() {
        return new NominalTimeRunFacetBuilder();
    }

    public RunFacet newRunFacet() {
        return new DefaultRunFacet(this.producer);
    }

    public OwnershipJobFacetOwners newOwnershipJobFacetOwners(String name, String type) {
        return new OwnershipJobFacetOwners(name, type);
    }

    public OwnershipJobFacetOwnersBuilder newOwnershipJobFacetOwnersBuilder() {
        return new OwnershipJobFacetOwnersBuilder();
    }

    public InputDatasetFacet newInputDatasetFacet() {
        return new DefaultInputDatasetFacet(this.producer);
    }

    public JobEvent newJobEvent(ZonedDateTime eventTime, Job job, List<InputDataset> inputs, List<OutputDataset> outputs) {
        return new JobEvent(eventTime, this.producer, job, inputs, outputs);
    }

    public JobEventBuilder newJobEventBuilder() {
        return new JobEventBuilder();
    }

    public ColumnLineageDatasetFacetFieldsAdditional newColumnLineageDatasetFacetFieldsAdditional(List<ColumnLineageDatasetFacetFieldsAdditionalInputFields> inputFields, String transformationDescription, String transformationType) {
        return new ColumnLineageDatasetFacetFieldsAdditional(inputFields, transformationDescription, transformationType);
    }

    public ColumnLineageDatasetFacetFieldsAdditionalBuilder newColumnLineageDatasetFacetFieldsAdditionalBuilder() {
        return new ColumnLineageDatasetFacetFieldsAdditionalBuilder();
    }

    public ExtractionErrorRunFacet newExtractionErrorRunFacet(Long totalTasks, Long failedTasks, List<ExtractionErrorRunFacetErrors> errors) {
        return new ExtractionErrorRunFacet(this.producer, totalTasks, failedTasks, errors);
    }

    public ExtractionErrorRunFacetBuilder newExtractionErrorRunFacetBuilder() {
        return new ExtractionErrorRunFacetBuilder();
    }

    public OwnershipDatasetFacetOwners newOwnershipDatasetFacetOwners(String name, String type) {
        return new OwnershipDatasetFacetOwners(name, type);
    }

    public OwnershipDatasetFacetOwnersBuilder newOwnershipDatasetFacetOwnersBuilder() {
        return new OwnershipDatasetFacetOwnersBuilder();
    }

    public DataQualityMetricsInputDatasetFacetColumnMetricsAdditional newDataQualityMetricsInputDatasetFacetColumnMetricsAdditional(Long nullCount, Long distinctCount, Double sum, Double count, Double min, Double max, DataQualityMetricsInputDatasetFacetColumnMetricsAdditionalQuantiles quantiles) {
        return new DataQualityMetricsInputDatasetFacetColumnMetricsAdditional(nullCount, distinctCount, sum, count, min, max, quantiles);
    }

    public DataQualityMetricsInputDatasetFacetColumnMetricsAdditionalBuilder newDataQualityMetricsInputDatasetFacetColumnMetricsAdditionalBuilder() {
        return new DataQualityMetricsInputDatasetFacetColumnMetricsAdditionalBuilder();
    }

    public DataQualityMetricsInputDatasetFacetColumnMetrics newDataQualityMetricsInputDatasetFacetColumnMetrics() {
        return new DataQualityMetricsInputDatasetFacetColumnMetrics();
    }

    public DataQualityMetricsInputDatasetFacetColumnMetricsBuilder newDataQualityMetricsInputDatasetFacetColumnMetricsBuilder() {
        return new DataQualityMetricsInputDatasetFacetColumnMetricsBuilder();
    }

    public DataQualityMetricsInputDatasetFacet newDataQualityMetricsInputDatasetFacet(Long rowCount, Long bytes, DataQualityMetricsInputDatasetFacetColumnMetrics columnMetrics) {
        return new DataQualityMetricsInputDatasetFacet(this.producer, rowCount, bytes, columnMetrics);
    }

    public DataQualityMetricsInputDatasetFacetBuilder newDataQualityMetricsInputDatasetFacetBuilder() {
        return new DataQualityMetricsInputDatasetFacetBuilder();
    }

    public DocumentationJobFacet newDocumentationJobFacet(String description) {
        return new DocumentationJobFacet(this.producer, description);
    }

    public DocumentationJobFacetBuilder newDocumentationJobFacetBuilder() {
        return new DocumentationJobFacetBuilder();
    }

    public JobFacets newJobFacets(SourceCodeJobFacet sourceCode, OwnershipJobFacet ownership, SQLJobFacet sql, SourceCodeLocationJobFacet sourceCodeLocation, DocumentationJobFacet documentation) {
        return new JobFacets(sourceCode, ownership, sql, sourceCodeLocation, documentation);
    }

    public JobFacetsBuilder newJobFacetsBuilder() {
        return new JobFacetsBuilder();
    }

    public InputDatasetInputFacets newInputDatasetInputFacets(DataQualityAssertionsDatasetFacet dataQualityAssertions, DataQualityMetricsInputDatasetFacet dataQualityMetrics) {
        return new InputDatasetInputFacets(dataQualityAssertions, dataQualityMetrics);
    }

    public InputDatasetInputFacetsBuilder newInputDatasetInputFacetsBuilder() {
        return new InputDatasetInputFacetsBuilder();
    }

    public DatasetFacet newDatasetFacet() {
        return new DefaultDatasetFacet(this.producer, null);
    }

    public DatasetFacet newDeletedDatasetFacet() {
        return new DefaultDatasetFacet(this.producer, true);
    }

    public OwnershipDatasetFacet newOwnershipDatasetFacet(List<OwnershipDatasetFacetOwners> owners) {
        return new OwnershipDatasetFacet(this.producer, owners);
    }

    public OwnershipDatasetFacetBuilder newOwnershipDatasetFacetBuilder() {
        return new OwnershipDatasetFacetBuilder();
    }

    public SQLJobFacet newSQLJobFacet(String query) {
        return new SQLJobFacet(this.producer, query);
    }

    public SQLJobFacetBuilder newSQLJobFacetBuilder() {
        return new SQLJobFacetBuilder();
    }

    public DatasetFacets newDatasetFacets(DocumentationDatasetFacet documentation, DatasourceDatasetFacet dataSource, DatasetVersionDatasetFacet version, SchemaDatasetFacet schema, OwnershipDatasetFacet ownership, StorageDatasetFacet storage, ColumnLineageDatasetFacet columnLineage, SymlinksDatasetFacet symlinks, LifecycleStateChangeDatasetFacet lifecycleStateChange) {
        return new DatasetFacets(documentation, dataSource, version, schema, ownership, storage, columnLineage, symlinks, lifecycleStateChange);
    }

    public DatasetFacetsBuilder newDatasetFacetsBuilder() {
        return new DatasetFacetsBuilder();
    }

    public OwnershipJobFacet newOwnershipJobFacet(List<OwnershipJobFacetOwners> owners) {
        return new OwnershipJobFacet(this.producer, owners);
    }

    public OwnershipJobFacetBuilder newOwnershipJobFacetBuilder() {
        return new OwnershipJobFacetBuilder();
    }

    public ParentRunFacetJob newParentRunFacetJob(String namespace, String name) {
        return new ParentRunFacetJob(namespace, name);
    }

    public ParentRunFacetJobBuilder newParentRunFacetJobBuilder() {
        return new ParentRunFacetJobBuilder();
    }

    public OutputDataset newOutputDataset(String namespace, String name, DatasetFacets facets, OutputDatasetOutputFacets outputFacets) {
        return new OutputDataset(namespace, name, facets, outputFacets);
    }

    public OutputDatasetBuilder newOutputDatasetBuilder() {
        return new OutputDatasetBuilder();
    }

    public ErrorMessageRunFacet newErrorMessageRunFacet(String message, String programmingLanguage, String stackTrace) {
        return new ErrorMessageRunFacet(this.producer, message, programmingLanguage, stackTrace);
    }

    public ErrorMessageRunFacetBuilder newErrorMessageRunFacetBuilder() {
        return new ErrorMessageRunFacetBuilder();
    }

    public JobFacet newJobFacet() {
        return new DefaultJobFacet(this.producer, null);
    }

    public JobFacet newDeletedJobFacet() {
        return new DefaultJobFacet(this.producer, true);
    }

    public RunFacets newRunFacets(ErrorMessageRunFacet errorMessage, ExternalQueryRunFacet externalQuery, ExtractionErrorRunFacet extractionError, ParentRunFacet parent, NominalTimeRunFacet nominalTime, ProcessingEngineRunFacet processing_engine) {
        return new RunFacets(errorMessage, externalQuery, extractionError, parent, nominalTime, processing_engine);
    }

    public RunFacetsBuilder newRunFacetsBuilder() {
        return new RunFacetsBuilder();
    }

    public SchemaDatasetFacet newSchemaDatasetFacet(List<SchemaDatasetFacetFields> fields) {
        return new SchemaDatasetFacet(this.producer, fields);
    }

    public SchemaDatasetFacetBuilder newSchemaDatasetFacetBuilder() {
        return new SchemaDatasetFacetBuilder();
    }

    public SourceCodeJobFacet newSourceCodeJobFacet(String language, String sourceCode) {
        return new SourceCodeJobFacet(this.producer, language, sourceCode);
    }

    public SourceCodeJobFacetBuilder newSourceCodeJobFacetBuilder() {
        return new SourceCodeJobFacetBuilder();
    }

    public DocumentationDatasetFacet newDocumentationDatasetFacet(String description) {
        return new DocumentationDatasetFacet(this.producer, description);
    }

    public DocumentationDatasetFacetBuilder newDocumentationDatasetFacetBuilder() {
        return new DocumentationDatasetFacetBuilder();
    }

    public SourceCodeLocationJobFacet newSourceCodeLocationJobFacet(String type, URI url, String repoUrl, String path, String version, String tag, String branch) {
        return new SourceCodeLocationJobFacet(this.producer, type, url, repoUrl, path, version, tag, branch);
    }

    public SourceCodeLocationJobFacetBuilder newSourceCodeLocationJobFacetBuilder() {
        return new SourceCodeLocationJobFacetBuilder();
    }

    public ColumnLineageDatasetFacet newColumnLineageDatasetFacet(ColumnLineageDatasetFacetFields fields) {
        return new ColumnLineageDatasetFacet(this.producer, fields);
    }

    public ColumnLineageDatasetFacetBuilder newColumnLineageDatasetFacetBuilder() {
        return new ColumnLineageDatasetFacetBuilder();
    }

    public DataQualityAssertionsDatasetFacet newDataQualityAssertionsDatasetFacet(List<DataQualityAssertionsDatasetFacetAssertions> assertions) {
        return new DataQualityAssertionsDatasetFacet(this.producer, assertions);
    }

    public DataQualityAssertionsDatasetFacetBuilder newDataQualityAssertionsDatasetFacetBuilder() {
        return new DataQualityAssertionsDatasetFacetBuilder();
    }

    public DatasetEvent newDatasetEvent(ZonedDateTime eventTime, StaticDataset dataset) {
        return new DatasetEvent(eventTime, this.producer, dataset);
    }

    public DatasetEventBuilder newDatasetEventBuilder() {
        return new DatasetEventBuilder();
    }

    public ProcessingEngineRunFacet newProcessingEngineRunFacet(String version, String name, String openlineageAdapterVersion) {
        return new ProcessingEngineRunFacet(this.producer, version, name, openlineageAdapterVersion);
    }

    public ProcessingEngineRunFacetBuilder newProcessingEngineRunFacetBuilder() {
        return new ProcessingEngineRunFacetBuilder();
    }

    public LifecycleStateChangeDatasetFacetPreviousIdentifier newLifecycleStateChangeDatasetFacetPreviousIdentifier(String name, String namespace) {
        return new LifecycleStateChangeDatasetFacetPreviousIdentifier(name, namespace);
    }

    public LifecycleStateChangeDatasetFacetPreviousIdentifierBuilder newLifecycleStateChangeDatasetFacetPreviousIdentifierBuilder() {
        return new LifecycleStateChangeDatasetFacetPreviousIdentifierBuilder();
    }

    public Job newJob(String namespace, String name, JobFacets facets) {
        return new Job(namespace, name, facets);
    }

    public JobBuilder newJobBuilder() {
        return new JobBuilder();
    }

    public DatasetVersionDatasetFacet newDatasetVersionDatasetFacet(String datasetVersion) {
        return new DatasetVersionDatasetFacet(this.producer, datasetVersion);
    }

    public DatasetVersionDatasetFacetBuilder newDatasetVersionDatasetFacetBuilder() {
        return new DatasetVersionDatasetFacetBuilder();
    }

    public SymlinksDatasetFacetIdentifiers newSymlinksDatasetFacetIdentifiers(String namespace, String name, String type) {
        return new SymlinksDatasetFacetIdentifiers(namespace, name, type);
    }

    public SymlinksDatasetFacetIdentifiersBuilder newSymlinksDatasetFacetIdentifiersBuilder() {
        return new SymlinksDatasetFacetIdentifiersBuilder();
    }

    public DataQualityAssertionsDatasetFacetAssertions newDataQualityAssertionsDatasetFacetAssertions(String assertion, Boolean success, String column) {
        return new DataQualityAssertionsDatasetFacetAssertions(assertion, success, column);
    }

    public DataQualityAssertionsDatasetFacetAssertionsBuilder newDataQualityAssertionsDatasetFacetAssertionsBuilder() {
        return new DataQualityAssertionsDatasetFacetAssertionsBuilder();
    }

    public ColumnLineageDatasetFacetFieldsAdditionalInputFields newColumnLineageDatasetFacetFieldsAdditionalInputFields(String namespace, String name, String field) {
        return new ColumnLineageDatasetFacetFieldsAdditionalInputFields(namespace, name, field);
    }

    public ColumnLineageDatasetFacetFieldsAdditionalInputFieldsBuilder newColumnLineageDatasetFacetFieldsAdditionalInputFieldsBuilder() {
        return new ColumnLineageDatasetFacetFieldsAdditionalInputFieldsBuilder();
    }

    public ParentRunFacetRun newParentRunFacetRun(UUID runId) {
        return new ParentRunFacetRun(runId);
    }

    public ParentRunFacetRunBuilder newParentRunFacetRunBuilder() {
        return new ParentRunFacetRunBuilder();
    }

    public OutputDatasetFacet newOutputDatasetFacet() {
        return new DefaultOutputDatasetFacet(this.producer);
    }

    public StaticDataset newStaticDataset(String namespace, String name, DatasetFacets facets) {
        return new StaticDataset(namespace, name, facets);
    }

    public StaticDatasetBuilder newStaticDatasetBuilder() {
        return new StaticDatasetBuilder();
    }

    public ColumnLineageDatasetFacetFields newColumnLineageDatasetFacetFields() {
        return new ColumnLineageDatasetFacetFields();
    }

    public ColumnLineageDatasetFacetFieldsBuilder newColumnLineageDatasetFacetFieldsBuilder() {
        return new ColumnLineageDatasetFacetFieldsBuilder();
    }

    public SymlinksDatasetFacet newSymlinksDatasetFacet(List<SymlinksDatasetFacetIdentifiers> identifiers) {
        return new SymlinksDatasetFacet(this.producer, identifiers);
    }

    public SymlinksDatasetFacetBuilder newSymlinksDatasetFacetBuilder() {
        return new SymlinksDatasetFacetBuilder();
    }

    public StorageDatasetFacet newStorageDatasetFacet(String storageLayer, String fileFormat) {
        return new StorageDatasetFacet(this.producer, storageLayer, fileFormat);
    }

    public StorageDatasetFacetBuilder newStorageDatasetFacetBuilder() {
        return new StorageDatasetFacetBuilder();
    }

    public InputDataset newInputDataset(String namespace, String name, DatasetFacets facets, InputDatasetInputFacets inputFacets) {
        return new InputDataset(namespace, name, facets, inputFacets);
    }

    public InputDatasetBuilder newInputDatasetBuilder() {
        return new InputDatasetBuilder();
    }

    public DatasourceDatasetFacet newDatasourceDatasetFacet(String name, URI uri) {
        return new DatasourceDatasetFacet(this.producer, name, uri);
    }

    public DatasourceDatasetFacetBuilder newDatasourceDatasetFacetBuilder() {
        return new DatasourceDatasetFacetBuilder();
    }

    public LifecycleStateChangeDatasetFacet newLifecycleStateChangeDatasetFacet(LifecycleStateChangeDatasetFacet.LifecycleStateChange lifecycleStateChange, LifecycleStateChangeDatasetFacetPreviousIdentifier previousIdentifier) {
        return new LifecycleStateChangeDatasetFacet(this.producer, lifecycleStateChange, previousIdentifier);
    }

    public LifecycleStateChangeDatasetFacetBuilder newLifecycleStateChangeDatasetFacetBuilder() {
        return new LifecycleStateChangeDatasetFacetBuilder();
    }

    public final class LifecycleStateChangeDatasetFacetBuilder
    implements Builder<LifecycleStateChangeDatasetFacet> {
        private LifecycleStateChangeDatasetFacet.LifecycleStateChange lifecycleStateChange;
        private LifecycleStateChangeDatasetFacetPreviousIdentifier previousIdentifier;
        private final Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

        public LifecycleStateChangeDatasetFacetBuilder lifecycleStateChange(LifecycleStateChangeDatasetFacet.LifecycleStateChange lifecycleStateChange) {
            this.lifecycleStateChange = lifecycleStateChange;
            return this;
        }

        public LifecycleStateChangeDatasetFacetBuilder previousIdentifier(LifecycleStateChangeDatasetFacetPreviousIdentifier previousIdentifier) {
            this.previousIdentifier = previousIdentifier;
            return this;
        }

        public LifecycleStateChangeDatasetFacetBuilder put(String key, Object value) {
            this.additionalProperties.put(key, value);
            return this;
        }

        @Override
        public LifecycleStateChangeDatasetFacet build() {
            LifecycleStateChangeDatasetFacet __result = new LifecycleStateChangeDatasetFacet(OpenLineage.this.producer, this.lifecycleStateChange, this.previousIdentifier);
            __result.getAdditionalProperties().putAll(this.additionalProperties);
            return __result;
        }
    }

    @JsonDeserialize(as=LifecycleStateChangeDatasetFacet.class)
    @JsonPropertyOrder(value={"_producer", "_schemaURL", "_deleted", "lifecycleStateChange", "previousIdentifier"})
    public static final class LifecycleStateChangeDatasetFacet
    implements DatasetFacet {
        private final URI _producer;
        private final URI _schemaURL;
        private final Boolean _deleted;
        private final LifecycleStateChange lifecycleStateChange;
        private final LifecycleStateChangeDatasetFacetPreviousIdentifier previousIdentifier;
        @JsonAnySetter
        private final Map<String, Object> additionalProperties;

        @JsonCreator
        private LifecycleStateChangeDatasetFacet(@JsonProperty(value="_producer") URI _producer, @JsonProperty(value="lifecycleStateChange") LifecycleStateChange lifecycleStateChange, @JsonProperty(value="previousIdentifier") LifecycleStateChangeDatasetFacetPreviousIdentifier previousIdentifier) {
            this._producer = _producer;
            this._schemaURL = URI.create("https://openlineage.io/spec/facets/1-0-0/LifecycleStateChangeDatasetFacet.json#/$defs/LifecycleStateChangeDatasetFacet");
            this._deleted = null;
            this.lifecycleStateChange = lifecycleStateChange;
            this.previousIdentifier = previousIdentifier;
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }

        @Override
        public URI get_producer() {
            return this._producer;
        }

        @Override
        public URI get_schemaURL() {
            return this._schemaURL;
        }

        @Override
        public Boolean get_deleted() {
            return this._deleted;
        }

        public LifecycleStateChange getLifecycleStateChange() {
            return this.lifecycleStateChange;
        }

        public LifecycleStateChangeDatasetFacetPreviousIdentifier getPreviousIdentifier() {
            return this.previousIdentifier;
        }

        @Override
        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        void withAdditionalProperties() {
        }

        public static enum LifecycleStateChange {
            ALTER,
            CREATE,
            DROP,
            OVERWRITE,
            RENAME,
            TRUNCATE;

        }
    }

    public final class DatasourceDatasetFacetBuilder
    implements Builder<DatasourceDatasetFacet> {
        private String name;
        private URI uri;
        private final Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

        public DatasourceDatasetFacetBuilder name(String name) {
            this.name = name;
            return this;
        }

        public DatasourceDatasetFacetBuilder uri(URI uri) {
            this.uri = uri;
            return this;
        }

        public DatasourceDatasetFacetBuilder put(String key, Object value) {
            this.additionalProperties.put(key, value);
            return this;
        }

        @Override
        public DatasourceDatasetFacet build() {
            DatasourceDatasetFacet __result = new DatasourceDatasetFacet(OpenLineage.this.producer, this.name, this.uri);
            __result.getAdditionalProperties().putAll(this.additionalProperties);
            return __result;
        }
    }

    @JsonDeserialize(as=DatasourceDatasetFacet.class)
    @JsonPropertyOrder(value={"_producer", "_schemaURL", "_deleted", "name", "uri"})
    public static final class DatasourceDatasetFacet
    implements DatasetFacet {
        private final URI _producer;
        private final URI _schemaURL;
        private final Boolean _deleted;
        private final String name;
        private final URI uri;
        @JsonAnySetter
        private final Map<String, Object> additionalProperties;

        @JsonCreator
        private DatasourceDatasetFacet(@JsonProperty(value="_producer") URI _producer, @JsonProperty(value="name") String name, @JsonProperty(value="uri") URI uri) {
            this._producer = _producer;
            this._schemaURL = URI.create("https://openlineage.io/spec/facets/1-0-0/DatasourceDatasetFacet.json#/$defs/DatasourceDatasetFacet");
            this._deleted = null;
            this.name = name;
            this.uri = uri;
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }

        @Override
        public URI get_producer() {
            return this._producer;
        }

        @Override
        public URI get_schemaURL() {
            return this._schemaURL;
        }

        @Override
        public Boolean get_deleted() {
            return this._deleted;
        }

        public String getName() {
            return this.name;
        }

        public URI getUri() {
            return this.uri;
        }

        @Override
        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        void withAdditionalProperties() {
        }
    }

    public static final class InputDatasetBuilder
    implements Builder<InputDataset> {
        private String namespace;
        private String name;
        private DatasetFacets facets;
        private InputDatasetInputFacets inputFacets;

        public InputDatasetBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public InputDatasetBuilder name(String name) {
            this.name = name;
            return this;
        }

        public InputDatasetBuilder facets(DatasetFacets facets) {
            this.facets = facets;
            return this;
        }

        public InputDatasetBuilder inputFacets(InputDatasetInputFacets inputFacets) {
            this.inputFacets = inputFacets;
            return this;
        }

        @Override
        public InputDataset build() {
            InputDataset __result = new InputDataset(this.namespace, this.name, this.facets, this.inputFacets);
            return __result;
        }
    }

    @JsonDeserialize(as=InputDataset.class)
    @JsonPropertyOrder(value={"namespace", "name", "facets", "inputFacets"})
    public static final class InputDataset
    implements Dataset {
        private final String namespace;
        private final String name;
        private final DatasetFacets facets;
        private final InputDatasetInputFacets inputFacets;

        @JsonCreator
        private InputDataset(@JsonProperty(value="namespace") String namespace, @JsonProperty(value="name") String name, @JsonProperty(value="facets") DatasetFacets facets, @JsonProperty(value="inputFacets") InputDatasetInputFacets inputFacets) {
            this.namespace = namespace;
            this.name = name;
            this.facets = facets;
            this.inputFacets = inputFacets;
        }

        @Override
        public String getNamespace() {
            return this.namespace;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public DatasetFacets getFacets() {
            return this.facets;
        }

        public InputDatasetInputFacets getInputFacets() {
            return this.inputFacets;
        }
    }

    public final class StorageDatasetFacetBuilder
    implements Builder<StorageDatasetFacet> {
        private String storageLayer;
        private String fileFormat;
        private final Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

        public StorageDatasetFacetBuilder storageLayer(String storageLayer) {
            this.storageLayer = storageLayer;
            return this;
        }

        public StorageDatasetFacetBuilder fileFormat(String fileFormat) {
            this.fileFormat = fileFormat;
            return this;
        }

        public StorageDatasetFacetBuilder put(String key, Object value) {
            this.additionalProperties.put(key, value);
            return this;
        }

        @Override
        public StorageDatasetFacet build() {
            StorageDatasetFacet __result = new StorageDatasetFacet(OpenLineage.this.producer, this.storageLayer, this.fileFormat);
            __result.getAdditionalProperties().putAll(this.additionalProperties);
            return __result;
        }
    }

    @JsonDeserialize(as=StorageDatasetFacet.class)
    @JsonPropertyOrder(value={"_producer", "_schemaURL", "_deleted", "storageLayer", "fileFormat"})
    public static final class StorageDatasetFacet
    implements DatasetFacet {
        private final URI _producer;
        private final URI _schemaURL;
        private final Boolean _deleted;
        private final String storageLayer;
        private final String fileFormat;
        @JsonAnySetter
        private final Map<String, Object> additionalProperties;

        @JsonCreator
        private StorageDatasetFacet(@JsonProperty(value="_producer") URI _producer, @JsonProperty(value="storageLayer") String storageLayer, @JsonProperty(value="fileFormat") String fileFormat) {
            this._producer = _producer;
            this._schemaURL = URI.create("https://openlineage.io/spec/facets/1-0-0/StorageDatasetFacet.json#/$defs/StorageDatasetFacet");
            this._deleted = null;
            this.storageLayer = storageLayer;
            this.fileFormat = fileFormat;
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }

        @Override
        public URI get_producer() {
            return this._producer;
        }

        @Override
        public URI get_schemaURL() {
            return this._schemaURL;
        }

        @Override
        public Boolean get_deleted() {
            return this._deleted;
        }

        public String getStorageLayer() {
            return this.storageLayer;
        }

        public String getFileFormat() {
            return this.fileFormat;
        }

        @Override
        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        void withAdditionalProperties() {
        }
    }

    public final class SymlinksDatasetFacetBuilder
    implements Builder<SymlinksDatasetFacet> {
        private List<SymlinksDatasetFacetIdentifiers> identifiers;
        private final Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

        public SymlinksDatasetFacetBuilder identifiers(List<SymlinksDatasetFacetIdentifiers> identifiers) {
            this.identifiers = identifiers;
            return this;
        }

        public SymlinksDatasetFacetBuilder put(String key, Object value) {
            this.additionalProperties.put(key, value);
            return this;
        }

        @Override
        public SymlinksDatasetFacet build() {
            SymlinksDatasetFacet __result = new SymlinksDatasetFacet(OpenLineage.this.producer, this.identifiers);
            __result.getAdditionalProperties().putAll(this.additionalProperties);
            return __result;
        }
    }

    @JsonDeserialize(as=SymlinksDatasetFacet.class)
    @JsonPropertyOrder(value={"_producer", "_schemaURL", "_deleted", "identifiers"})
    public static final class SymlinksDatasetFacet
    implements DatasetFacet {
        private final URI _producer;
        private final URI _schemaURL;
        private final Boolean _deleted;
        private final List<SymlinksDatasetFacetIdentifiers> identifiers;
        @JsonAnySetter
        private final Map<String, Object> additionalProperties;

        @JsonCreator
        private SymlinksDatasetFacet(@JsonProperty(value="_producer") URI _producer, @JsonProperty(value="identifiers") List<SymlinksDatasetFacetIdentifiers> identifiers) {
            this._producer = _producer;
            this._schemaURL = URI.create("https://openlineage.io/spec/facets/1-0-0/SymlinksDatasetFacet.json#/$defs/SymlinksDatasetFacet");
            this._deleted = null;
            this.identifiers = identifiers;
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }

        @Override
        public URI get_producer() {
            return this._producer;
        }

        @Override
        public URI get_schemaURL() {
            return this._schemaURL;
        }

        @Override
        public Boolean get_deleted() {
            return this._deleted;
        }

        public List<SymlinksDatasetFacetIdentifiers> getIdentifiers() {
            return this.identifiers;
        }

        @Override
        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        void withAdditionalProperties() {
        }
    }

    public static final class ColumnLineageDatasetFacetFieldsBuilder
    implements Builder<ColumnLineageDatasetFacetFields> {
        private final Map<String, ColumnLineageDatasetFacetFieldsAdditional> additionalProperties = new LinkedHashMap<String, ColumnLineageDatasetFacetFieldsAdditional>();

        public ColumnLineageDatasetFacetFieldsBuilder put(String key, ColumnLineageDatasetFacetFieldsAdditional value) {
            this.additionalProperties.put(key, value);
            return this;
        }

        @Override
        public ColumnLineageDatasetFacetFields build() {
            ColumnLineageDatasetFacetFields __result = new ColumnLineageDatasetFacetFields();
            __result.getAdditionalProperties().putAll(this.additionalProperties);
            return __result;
        }
    }

    @JsonDeserialize(as=ColumnLineageDatasetFacetFields.class)
    @JsonPropertyOrder
    public static final class ColumnLineageDatasetFacetFields {
        @JsonAnySetter
        private final Map<String, ColumnLineageDatasetFacetFieldsAdditional> additionalProperties = new LinkedHashMap<String, ColumnLineageDatasetFacetFieldsAdditional>();

        @JsonCreator
        private ColumnLineageDatasetFacetFields() {
        }

        @JsonAnyGetter
        public Map<String, ColumnLineageDatasetFacetFieldsAdditional> getAdditionalProperties() {
            return this.additionalProperties;
        }

        void withAdditionalProperties() {
        }
    }

    public static final class StaticDatasetBuilder
    implements Builder<StaticDataset> {
        private String namespace;
        private String name;
        private DatasetFacets facets;

        public StaticDatasetBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public StaticDatasetBuilder name(String name) {
            this.name = name;
            return this;
        }

        public StaticDatasetBuilder facets(DatasetFacets facets) {
            this.facets = facets;
            return this;
        }

        @Override
        public StaticDataset build() {
            StaticDataset __result = new StaticDataset(this.namespace, this.name, this.facets);
            return __result;
        }
    }

    @JsonDeserialize(as=StaticDataset.class)
    @JsonPropertyOrder(value={"namespace", "name", "facets"})
    public static final class StaticDataset
    implements Dataset {
        private final String namespace;
        private final String name;
        private final DatasetFacets facets;

        @JsonCreator
        private StaticDataset(@JsonProperty(value="namespace") String namespace, @JsonProperty(value="name") String name, @JsonProperty(value="facets") DatasetFacets facets) {
            this.namespace = namespace;
            this.name = name;
            this.facets = facets;
        }

        @Override
        public String getNamespace() {
            return this.namespace;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public DatasetFacets getFacets() {
            return this.facets;
        }
    }

    @JsonDeserialize(as=DefaultOutputDatasetFacet.class)
    public static interface OutputDatasetFacet {
        public URI get_producer();

        public URI get_schemaURL();

        public Map<String, Object> getAdditionalProperties();
    }

    public static class DefaultOutputDatasetFacet
    implements OutputDatasetFacet {
        private final URI _producer;
        private final URI _schemaURL;
        @JsonAnySetter
        private final Map<String, Object> additionalProperties;

        @JsonCreator
        public DefaultOutputDatasetFacet(@JsonProperty(value="_producer") URI _producer) {
            this._producer = _producer;
            this._schemaURL = URI.create("https://openlineage.io/spec/2-0-2/OpenLineage.json#/$defs/OutputDatasetFacet");
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }

        @Override
        public URI get_producer() {
            return this._producer;
        }

        @Override
        public URI get_schemaURL() {
            return this._schemaURL;
        }

        @Override
        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }
    }

    public static final class ParentRunFacetRunBuilder
    implements Builder<ParentRunFacetRun> {
        private UUID runId;

        public ParentRunFacetRunBuilder runId(UUID runId) {
            this.runId = runId;
            return this;
        }

        @Override
        public ParentRunFacetRun build() {
            ParentRunFacetRun __result = new ParentRunFacetRun(this.runId);
            return __result;
        }
    }

    @JsonDeserialize(as=ParentRunFacetRun.class)
    @JsonPropertyOrder(value={"runId"})
    public static final class ParentRunFacetRun {
        private final UUID runId;

        @JsonCreator
        private ParentRunFacetRun(@JsonProperty(value="runId") UUID runId) {
            this.runId = runId;
        }

        public UUID getRunId() {
            return this.runId;
        }
    }

    public static final class ColumnLineageDatasetFacetFieldsAdditionalInputFieldsBuilder
    implements Builder<ColumnLineageDatasetFacetFieldsAdditionalInputFields> {
        private String namespace;
        private String name;
        private String field;
        private final Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

        public ColumnLineageDatasetFacetFieldsAdditionalInputFieldsBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public ColumnLineageDatasetFacetFieldsAdditionalInputFieldsBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ColumnLineageDatasetFacetFieldsAdditionalInputFieldsBuilder field(String field) {
            this.field = field;
            return this;
        }

        public ColumnLineageDatasetFacetFieldsAdditionalInputFieldsBuilder put(String key, Object value) {
            this.additionalProperties.put(key, value);
            return this;
        }

        @Override
        public ColumnLineageDatasetFacetFieldsAdditionalInputFields build() {
            ColumnLineageDatasetFacetFieldsAdditionalInputFields __result = new ColumnLineageDatasetFacetFieldsAdditionalInputFields(this.namespace, this.name, this.field);
            __result.getAdditionalProperties().putAll(this.additionalProperties);
            return __result;
        }
    }

    @JsonDeserialize(as=ColumnLineageDatasetFacetFieldsAdditionalInputFields.class)
    @JsonPropertyOrder(value={"namespace", "name", "field"})
    public static final class ColumnLineageDatasetFacetFieldsAdditionalInputFields {
        private final String namespace;
        private final String name;
        private final String field;
        @JsonAnySetter
        private final Map<String, Object> additionalProperties;

        @JsonCreator
        private ColumnLineageDatasetFacetFieldsAdditionalInputFields(@JsonProperty(value="namespace") String namespace, @JsonProperty(value="name") String name, @JsonProperty(value="field") String field) {
            this.namespace = namespace;
            this.name = name;
            this.field = field;
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }

        public String getNamespace() {
            return this.namespace;
        }

        public String getName() {
            return this.name;
        }

        public String getField() {
            return this.field;
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        void withAdditionalProperties() {
        }
    }

    public static final class DataQualityAssertionsDatasetFacetAssertionsBuilder
    implements Builder<DataQualityAssertionsDatasetFacetAssertions> {
        private String assertion;
        private Boolean success;
        private String column;

        public DataQualityAssertionsDatasetFacetAssertionsBuilder assertion(String assertion) {
            this.assertion = assertion;
            return this;
        }

        public DataQualityAssertionsDatasetFacetAssertionsBuilder success(Boolean success) {
            this.success = success;
            return this;
        }

        public DataQualityAssertionsDatasetFacetAssertionsBuilder column(String column) {
            this.column = column;
            return this;
        }

        @Override
        public DataQualityAssertionsDatasetFacetAssertions build() {
            DataQualityAssertionsDatasetFacetAssertions __result = new DataQualityAssertionsDatasetFacetAssertions(this.assertion, this.success, this.column);
            return __result;
        }
    }

    @JsonDeserialize(as=DataQualityAssertionsDatasetFacetAssertions.class)
    @JsonPropertyOrder(value={"assertion", "success", "column"})
    public static final class DataQualityAssertionsDatasetFacetAssertions {
        private final String assertion;
        private final Boolean success;
        private final String column;

        @JsonCreator
        private DataQualityAssertionsDatasetFacetAssertions(@JsonProperty(value="assertion") String assertion, @JsonProperty(value="success") Boolean success, @JsonProperty(value="column") String column) {
            this.assertion = assertion;
            this.success = success;
            this.column = column;
        }

        public String getAssertion() {
            return this.assertion;
        }

        public Boolean getSuccess() {
            return this.success;
        }

        public String getColumn() {
            return this.column;
        }
    }

    public static final class SymlinksDatasetFacetIdentifiersBuilder
    implements Builder<SymlinksDatasetFacetIdentifiers> {
        private String namespace;
        private String name;
        private String type;

        public SymlinksDatasetFacetIdentifiersBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public SymlinksDatasetFacetIdentifiersBuilder name(String name) {
            this.name = name;
            return this;
        }

        public SymlinksDatasetFacetIdentifiersBuilder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public SymlinksDatasetFacetIdentifiers build() {
            SymlinksDatasetFacetIdentifiers __result = new SymlinksDatasetFacetIdentifiers(this.namespace, this.name, this.type);
            return __result;
        }
    }

    @JsonDeserialize(as=SymlinksDatasetFacetIdentifiers.class)
    @JsonPropertyOrder(value={"namespace", "name", "type"})
    public static final class SymlinksDatasetFacetIdentifiers {
        private final String namespace;
        private final String name;
        private final String type;

        @JsonCreator
        private SymlinksDatasetFacetIdentifiers(@JsonProperty(value="namespace") String namespace, @JsonProperty(value="name") String name, @JsonProperty(value="type") String type) {
            this.namespace = namespace;
            this.name = name;
            this.type = type;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }
    }

    public final class DatasetVersionDatasetFacetBuilder
    implements Builder<DatasetVersionDatasetFacet> {
        private String datasetVersion;
        private final Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

        public DatasetVersionDatasetFacetBuilder datasetVersion(String datasetVersion) {
            this.datasetVersion = datasetVersion;
            return this;
        }

        public DatasetVersionDatasetFacetBuilder put(String key, Object value) {
            this.additionalProperties.put(key, value);
            return this;
        }

        @Override
        public DatasetVersionDatasetFacet build() {
            DatasetVersionDatasetFacet __result = new DatasetVersionDatasetFacet(OpenLineage.this.producer, this.datasetVersion);
            __result.getAdditionalProperties().putAll(this.additionalProperties);
            return __result;
        }
    }

    @JsonDeserialize(as=DatasetVersionDatasetFacet.class)
    @JsonPropertyOrder(value={"_producer", "_schemaURL", "_deleted", "datasetVersion"})
    public static final class DatasetVersionDatasetFacet
    implements DatasetFacet {
        private final URI _producer;
        private final URI _schemaURL;
        private final Boolean _deleted;
        private final String datasetVersion;
        @JsonAnySetter
        private final Map<String, Object> additionalProperties;

        @JsonCreator
        private DatasetVersionDatasetFacet(@JsonProperty(value="_producer") URI _producer, @JsonProperty(value="datasetVersion") String datasetVersion) {
            this._producer = _producer;
            this._schemaURL = URI.create("https://openlineage.io/spec/facets/1-0-0/DatasetVersionDatasetFacet.json#/$defs/DatasetVersionDatasetFacet");
            this._deleted = null;
            this.datasetVersion = datasetVersion;
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }

        @Override
        public URI get_producer() {
            return this._producer;
        }

        @Override
        public URI get_schemaURL() {
            return this._schemaURL;
        }

        @Override
        public Boolean get_deleted() {
            return this._deleted;
        }

        public String getDatasetVersion() {
            return this.datasetVersion;
        }

        @Override
        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        void withAdditionalProperties() {
        }
    }

    public static final class JobBuilder
    implements Builder<Job> {
        private String namespace;
        private String name;
        private JobFacets facets;

        public JobBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public JobBuilder name(String name) {
            this.name = name;
            return this;
        }

        public JobBuilder facets(JobFacets facets) {
            this.facets = facets;
            return this;
        }

        @Override
        public Job build() {
            Job __result = new Job(this.namespace, this.name, this.facets);
            return __result;
        }
    }

    @JsonDeserialize(as=Job.class)
    @JsonPropertyOrder(value={"namespace", "name", "facets"})
    public static final class Job {
        private final String namespace;
        private final String name;
        private final JobFacets facets;

        @JsonCreator
        private Job(@JsonProperty(value="namespace") String namespace, @JsonProperty(value="name") String name, @JsonProperty(value="facets") JobFacets facets) {
            this.namespace = namespace;
            this.name = name;
            this.facets = facets;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public String getName() {
            return this.name;
        }

        public JobFacets getFacets() {
            return this.facets;
        }
    }

    public static final class LifecycleStateChangeDatasetFacetPreviousIdentifierBuilder
    implements Builder<LifecycleStateChangeDatasetFacetPreviousIdentifier> {
        private String name;
        private String namespace;

        public LifecycleStateChangeDatasetFacetPreviousIdentifierBuilder name(String name) {
            this.name = name;
            return this;
        }

        public LifecycleStateChangeDatasetFacetPreviousIdentifierBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        @Override
        public LifecycleStateChangeDatasetFacetPreviousIdentifier build() {
            LifecycleStateChangeDatasetFacetPreviousIdentifier __result = new LifecycleStateChangeDatasetFacetPreviousIdentifier(this.name, this.namespace);
            return __result;
        }
    }

    @JsonDeserialize(as=LifecycleStateChangeDatasetFacetPreviousIdentifier.class)
    @JsonPropertyOrder(value={"name", "namespace"})
    public static final class LifecycleStateChangeDatasetFacetPreviousIdentifier {
        private final String name;
        private final String namespace;

        @JsonCreator
        private LifecycleStateChangeDatasetFacetPreviousIdentifier(@JsonProperty(value="name") String name, @JsonProperty(value="namespace") String namespace) {
            this.name = name;
            this.namespace = namespace;
        }

        public String getName() {
            return this.name;
        }

        public String getNamespace() {
            return this.namespace;
        }
    }

    public final class ProcessingEngineRunFacetBuilder
    implements Builder<ProcessingEngineRunFacet> {
        private String version;
        private String name;
        private String openlineageAdapterVersion;
        private final Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

        public ProcessingEngineRunFacetBuilder version(String version) {
            this.version = version;
            return this;
        }

        public ProcessingEngineRunFacetBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ProcessingEngineRunFacetBuilder openlineageAdapterVersion(String openlineageAdapterVersion) {
            this.openlineageAdapterVersion = openlineageAdapterVersion;
            return this;
        }

        public ProcessingEngineRunFacetBuilder put(String key, Object value) {
            this.additionalProperties.put(key, value);
            return this;
        }

        @Override
        public ProcessingEngineRunFacet build() {
            ProcessingEngineRunFacet __result = new ProcessingEngineRunFacet(OpenLineage.this.producer, this.version, this.name, this.openlineageAdapterVersion);
            __result.getAdditionalProperties().putAll(this.additionalProperties);
            return __result;
        }
    }

    @JsonDeserialize(as=ProcessingEngineRunFacet.class)
    @JsonPropertyOrder(value={"_producer", "_schemaURL", "version", "name", "openlineageAdapterVersion"})
    public static final class ProcessingEngineRunFacet
    implements RunFacet {
        private final URI _producer;
        private final URI _schemaURL;
        private final String version;
        private final String name;
        private final String openlineageAdapterVersion;
        @JsonAnySetter
        private final Map<String, Object> additionalProperties;

        @JsonCreator
        private ProcessingEngineRunFacet(@JsonProperty(value="_producer") URI _producer, @JsonProperty(value="version") String version, @JsonProperty(value="name") String name, @JsonProperty(value="openlineageAdapterVersion") String openlineageAdapterVersion) {
            this._producer = _producer;
            this._schemaURL = URI.create("https://openlineage.io/spec/facets/1-1-0/ProcessingEngineRunFacet.json#/$defs/ProcessingEngineRunFacet");
            this.version = version;
            this.name = name;
            this.openlineageAdapterVersion = openlineageAdapterVersion;
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }

        @Override
        public URI get_producer() {
            return this._producer;
        }

        @Override
        public URI get_schemaURL() {
            return this._schemaURL;
        }

        public String getVersion() {
            return this.version;
        }

        public String getName() {
            return this.name;
        }

        public String getOpenlineageAdapterVersion() {
            return this.openlineageAdapterVersion;
        }

        @Override
        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        void withAdditionalProperties() {
        }
    }

    public static interface Dataset {
        public String getNamespace();

        public String getName();

        public DatasetFacets getFacets();
    }

    public final class DatasetEventBuilder
    implements Builder<DatasetEvent> {
        private ZonedDateTime eventTime;
        private StaticDataset dataset;

        public DatasetEventBuilder eventTime(ZonedDateTime eventTime) {
            this.eventTime = eventTime;
            return this;
        }

        public DatasetEventBuilder dataset(StaticDataset dataset) {
            this.dataset = dataset;
            return this;
        }

        @Override
        public DatasetEvent build() {
            DatasetEvent __result = new DatasetEvent(this.eventTime, OpenLineage.this.producer, this.dataset);
            return __result;
        }
    }

    @JsonDeserialize(as=DatasetEvent.class)
    @JsonPropertyOrder(value={"eventTime", "producer", "schemaURL", "dataset"})
    public static final class DatasetEvent
    implements BaseEvent {
        private final ZonedDateTime eventTime;
        private final URI producer;
        private final URI schemaURL;
        private final StaticDataset dataset;

        @JsonCreator
        private DatasetEvent(@JsonProperty(value="eventTime") ZonedDateTime eventTime, @JsonProperty(value="producer") URI producer, @JsonProperty(value="dataset") StaticDataset dataset) {
            this.eventTime = eventTime;
            this.producer = producer;
            this.schemaURL = URI.create("https://openlineage.io/spec/2-0-2/OpenLineage.json#/$defs/DatasetEvent");
            this.dataset = dataset;
        }

        @Override
        public ZonedDateTime getEventTime() {
            return this.eventTime;
        }

        @Override
        public URI getProducer() {
            return this.producer;
        }

        @Override
        public URI getSchemaURL() {
            return this.schemaURL;
        }

        public StaticDataset getDataset() {
            return this.dataset;
        }
    }

    public final class DataQualityAssertionsDatasetFacetBuilder
    implements Builder<DataQualityAssertionsDatasetFacet> {
        private List<DataQualityAssertionsDatasetFacetAssertions> assertions;
        private final Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

        public DataQualityAssertionsDatasetFacetBuilder assertions(List<DataQualityAssertionsDatasetFacetAssertions> assertions) {
            this.assertions = assertions;
            return this;
        }

        public DataQualityAssertionsDatasetFacetBuilder put(String key, Object value) {
            this.additionalProperties.put(key, value);
            return this;
        }

        @Override
        public DataQualityAssertionsDatasetFacet build() {
            DataQualityAssertionsDatasetFacet __result = new DataQualityAssertionsDatasetFacet(OpenLineage.this.producer, this.assertions);
            __result.getAdditionalProperties().putAll(this.additionalProperties);
            return __result;
        }
    }

    @JsonDeserialize(as=DataQualityAssertionsDatasetFacet.class)
    @JsonPropertyOrder(value={"_producer", "_schemaURL", "assertions"})
    public static final class DataQualityAssertionsDatasetFacet
    implements InputDatasetFacet {
        private final URI _producer;
        private final URI _schemaURL;
        private final List<DataQualityAssertionsDatasetFacetAssertions> assertions;
        @JsonAnySetter
        private final Map<String, Object> additionalProperties;

        @JsonCreator
        private DataQualityAssertionsDatasetFacet(@JsonProperty(value="_producer") URI _producer, @JsonProperty(value="assertions") List<DataQualityAssertionsDatasetFacetAssertions> assertions) {
            this._producer = _producer;
            this._schemaURL = URI.create("https://openlineage.io/spec/facets/1-0-0/DataQualityAssertionsDatasetFacet.json#/$defs/DataQualityAssertionsDatasetFacet");
            this.assertions = assertions;
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }

        @Override
        public URI get_producer() {
            return this._producer;
        }

        @Override
        public URI get_schemaURL() {
            return this._schemaURL;
        }

        public List<DataQualityAssertionsDatasetFacetAssertions> getAssertions() {
            return this.assertions;
        }

        @Override
        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        void withAdditionalProperties() {
        }
    }

    public final class ColumnLineageDatasetFacetBuilder
    implements Builder<ColumnLineageDatasetFacet> {
        private ColumnLineageDatasetFacetFields fields;
        private final Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

        public ColumnLineageDatasetFacetBuilder fields(ColumnLineageDatasetFacetFields fields) {
            this.fields = fields;
            return this;
        }

        public ColumnLineageDatasetFacetBuilder put(String key, Object value) {
            this.additionalProperties.put(key, value);
            return this;
        }

        @Override
        public ColumnLineageDatasetFacet build() {
            ColumnLineageDatasetFacet __result = new ColumnLineageDatasetFacet(OpenLineage.this.producer, this.fields);
            __result.getAdditionalProperties().putAll(this.additionalProperties);
            return __result;
        }
    }

    @JsonDeserialize(as=ColumnLineageDatasetFacet.class)
    @JsonPropertyOrder(value={"_producer", "_schemaURL", "_deleted", "fields"})
    public static final class ColumnLineageDatasetFacet
    implements DatasetFacet {
        private final URI _producer;
        private final URI _schemaURL;
        private final Boolean _deleted;
        private final ColumnLineageDatasetFacetFields fields;
        @JsonAnySetter
        private final Map<String, Object> additionalProperties;

        @JsonCreator
        private ColumnLineageDatasetFacet(@JsonProperty(value="_producer") URI _producer, @JsonProperty(value="fields") ColumnLineageDatasetFacetFields fields) {
            this._producer = _producer;
            this._schemaURL = URI.create("https://openlineage.io/spec/facets/1-0-1/ColumnLineageDatasetFacet.json#/$defs/ColumnLineageDatasetFacet");
            this._deleted = null;
            this.fields = fields;
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }

        @Override
        public URI get_producer() {
            return this._producer;
        }

        @Override
        public URI get_schemaURL() {
            return this._schemaURL;
        }

        @Override
        public Boolean get_deleted() {
            return this._deleted;
        }

        public ColumnLineageDatasetFacetFields getFields() {
            return this.fields;
        }

        @Override
        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        void withAdditionalProperties() {
        }
    }

    public final class SourceCodeLocationJobFacetBuilder
    implements Builder<SourceCodeLocationJobFacet> {
        private String type;
        private URI url;
        private String repoUrl;
        private String path;
        private String version;
        private String tag;
        private String branch;
        private final Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

        public SourceCodeLocationJobFacetBuilder type(String type) {
            this.type = type;
            return this;
        }

        public SourceCodeLocationJobFacetBuilder url(URI url) {
            this.url = url;
            return this;
        }

        public SourceCodeLocationJobFacetBuilder repoUrl(String repoUrl) {
            this.repoUrl = repoUrl;
            return this;
        }

        public SourceCodeLocationJobFacetBuilder path(String path) {
            this.path = path;
            return this;
        }

        public SourceCodeLocationJobFacetBuilder version(String version) {
            this.version = version;
            return this;
        }

        public SourceCodeLocationJobFacetBuilder tag(String tag) {
            this.tag = tag;
            return this;
        }

        public SourceCodeLocationJobFacetBuilder branch(String branch) {
            this.branch = branch;
            return this;
        }

        public SourceCodeLocationJobFacetBuilder put(String key, Object value) {
            this.additionalProperties.put(key, value);
            return this;
        }

        @Override
        public SourceCodeLocationJobFacet build() {
            SourceCodeLocationJobFacet __result = new SourceCodeLocationJobFacet(OpenLineage.this.producer, this.type, this.url, this.repoUrl, this.path, this.version, this.tag, this.branch);
            __result.getAdditionalProperties().putAll(this.additionalProperties);
            return __result;
        }
    }

    @JsonDeserialize(as=SourceCodeLocationJobFacet.class)
    @JsonPropertyOrder(value={"_producer", "_schemaURL", "_deleted", "type", "url", "repoUrl", "path", "version", "tag", "branch"})
    public static final class SourceCodeLocationJobFacet
    implements JobFacet {
        private final URI _producer;
        private final URI _schemaURL;
        private final Boolean _deleted;
        private final String type;
        private final URI url;
        private final String repoUrl;
        private final String path;
        private final String version;
        private final String tag;
        private final String branch;
        @JsonAnySetter
        private final Map<String, Object> additionalProperties;

        @JsonCreator
        private SourceCodeLocationJobFacet(@JsonProperty(value="_producer") URI _producer, @JsonProperty(value="type") String type, @JsonProperty(value="url") URI url, @JsonProperty(value="repoUrl") String repoUrl, @JsonProperty(value="path") String path, @JsonProperty(value="version") String version, @JsonProperty(value="tag") String tag, @JsonProperty(value="branch") String branch) {
            this._producer = _producer;
            this._schemaURL = URI.create("https://openlineage.io/spec/facets/1-0-0/SourceCodeLocationJobFacet.json#/$defs/SourceCodeLocationJobFacet");
            this._deleted = null;
            this.type = type;
            this.url = url;
            this.repoUrl = repoUrl;
            this.path = path;
            this.version = version;
            this.tag = tag;
            this.branch = branch;
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }

        @Override
        public URI get_producer() {
            return this._producer;
        }

        @Override
        public URI get_schemaURL() {
            return this._schemaURL;
        }

        @Override
        public Boolean get_deleted() {
            return this._deleted;
        }

        public String getType() {
            return this.type;
        }

        public URI getUrl() {
            return this.url;
        }

        public String getRepoUrl() {
            return this.repoUrl;
        }

        public String getPath() {
            return this.path;
        }

        public String getVersion() {
            return this.version;
        }

        public String getTag() {
            return this.tag;
        }

        public String getBranch() {
            return this.branch;
        }

        @Override
        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        void withAdditionalProperties() {
        }
    }

    public final class DocumentationDatasetFacetBuilder
    implements Builder<DocumentationDatasetFacet> {
        private String description;
        private final Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

        public DocumentationDatasetFacetBuilder description(String description) {
            this.description = description;
            return this;
        }

        public DocumentationDatasetFacetBuilder put(String key, Object value) {
            this.additionalProperties.put(key, value);
            return this;
        }

        @Override
        public DocumentationDatasetFacet build() {
            DocumentationDatasetFacet __result = new DocumentationDatasetFacet(OpenLineage.this.producer, this.description);
            __result.getAdditionalProperties().putAll(this.additionalProperties);
            return __result;
        }
    }

    @JsonDeserialize(as=DocumentationDatasetFacet.class)
    @JsonPropertyOrder(value={"_producer", "_schemaURL", "_deleted", "description"})
    public static final class DocumentationDatasetFacet
    implements DatasetFacet {
        private final URI _producer;
        private final URI _schemaURL;
        private final Boolean _deleted;
        private final String description;
        @JsonAnySetter
        private final Map<String, Object> additionalProperties;

        @JsonCreator
        private DocumentationDatasetFacet(@JsonProperty(value="_producer") URI _producer, @JsonProperty(value="description") String description) {
            this._producer = _producer;
            this._schemaURL = URI.create("https://openlineage.io/spec/facets/1-0-0/DocumentationDatasetFacet.json#/$defs/DocumentationDatasetFacet");
            this._deleted = null;
            this.description = description;
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }

        @Override
        public URI get_producer() {
            return this._producer;
        }

        @Override
        public URI get_schemaURL() {
            return this._schemaURL;
        }

        @Override
        public Boolean get_deleted() {
            return this._deleted;
        }

        public String getDescription() {
            return this.description;
        }

        @Override
        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        void withAdditionalProperties() {
        }
    }

    public final class SourceCodeJobFacetBuilder
    implements Builder<SourceCodeJobFacet> {
        private String language;
        private String sourceCode;
        private final Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

        public SourceCodeJobFacetBuilder language(String language) {
            this.language = language;
            return this;
        }

        public SourceCodeJobFacetBuilder sourceCode(String sourceCode) {
            this.sourceCode = sourceCode;
            return this;
        }

        public SourceCodeJobFacetBuilder put(String key, Object value) {
            this.additionalProperties.put(key, value);
            return this;
        }

        @Override
        public SourceCodeJobFacet build() {
            SourceCodeJobFacet __result = new SourceCodeJobFacet(OpenLineage.this.producer, this.language, this.sourceCode);
            __result.getAdditionalProperties().putAll(this.additionalProperties);
            return __result;
        }
    }

    @JsonDeserialize(as=SourceCodeJobFacet.class)
    @JsonPropertyOrder(value={"_producer", "_schemaURL", "_deleted", "language", "sourceCode"})
    public static final class SourceCodeJobFacet
    implements JobFacet {
        private final URI _producer;
        private final URI _schemaURL;
        private final Boolean _deleted;
        private final String language;
        private final String sourceCode;
        @JsonAnySetter
        private final Map<String, Object> additionalProperties;

        @JsonCreator
        private SourceCodeJobFacet(@JsonProperty(value="_producer") URI _producer, @JsonProperty(value="language") String language, @JsonProperty(value="sourceCode") String sourceCode) {
            this._producer = _producer;
            this._schemaURL = URI.create("https://openlineage.io/spec/facets/1-0-0/SourceCodeJobFacet.json#/$defs/SourceCodeJobFacet");
            this._deleted = null;
            this.language = language;
            this.sourceCode = sourceCode;
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }

        @Override
        public URI get_producer() {
            return this._producer;
        }

        @Override
        public URI get_schemaURL() {
            return this._schemaURL;
        }

        @Override
        public Boolean get_deleted() {
            return this._deleted;
        }

        public String getLanguage() {
            return this.language;
        }

        public String getSourceCode() {
            return this.sourceCode;
        }

        @Override
        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        void withAdditionalProperties() {
        }
    }

    public final class SchemaDatasetFacetBuilder
    implements Builder<SchemaDatasetFacet> {
        private List<SchemaDatasetFacetFields> fields;
        private final Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

        public SchemaDatasetFacetBuilder fields(List<SchemaDatasetFacetFields> fields) {
            this.fields = fields;
            return this;
        }

        public SchemaDatasetFacetBuilder put(String key, Object value) {
            this.additionalProperties.put(key, value);
            return this;
        }

        @Override
        public SchemaDatasetFacet build() {
            SchemaDatasetFacet __result = new SchemaDatasetFacet(OpenLineage.this.producer, this.fields);
            __result.getAdditionalProperties().putAll(this.additionalProperties);
            return __result;
        }
    }

    @JsonDeserialize(as=SchemaDatasetFacet.class)
    @JsonPropertyOrder(value={"_producer", "_schemaURL", "_deleted", "fields"})
    public static final class SchemaDatasetFacet
    implements DatasetFacet {
        private final URI _producer;
        private final URI _schemaURL;
        private final Boolean _deleted;
        private final List<SchemaDatasetFacetFields> fields;
        @JsonAnySetter
        private final Map<String, Object> additionalProperties;

        @JsonCreator
        private SchemaDatasetFacet(@JsonProperty(value="_producer") URI _producer, @JsonProperty(value="fields") List<SchemaDatasetFacetFields> fields) {
            this._producer = _producer;
            this._schemaURL = URI.create("https://openlineage.io/spec/facets/1-0-0/SchemaDatasetFacet.json#/$defs/SchemaDatasetFacet");
            this._deleted = null;
            this.fields = fields;
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }

        @Override
        public URI get_producer() {
            return this._producer;
        }

        @Override
        public URI get_schemaURL() {
            return this._schemaURL;
        }

        @Override
        public Boolean get_deleted() {
            return this._deleted;
        }

        public List<SchemaDatasetFacetFields> getFields() {
            return this.fields;
        }

        @Override
        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        void withAdditionalProperties() {
        }
    }

    public static final class RunFacetsBuilder
    implements Builder<RunFacets> {
        private ErrorMessageRunFacet errorMessage;
        private ExternalQueryRunFacet externalQuery;
        private ExtractionErrorRunFacet extractionError;
        private ParentRunFacet parent;
        private NominalTimeRunFacet nominalTime;
        private ProcessingEngineRunFacet processing_engine;
        private final Map<String, RunFacet> additionalProperties = new LinkedHashMap<String, RunFacet>();

        public RunFacetsBuilder errorMessage(ErrorMessageRunFacet errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public RunFacetsBuilder externalQuery(ExternalQueryRunFacet externalQuery) {
            this.externalQuery = externalQuery;
            return this;
        }

        public RunFacetsBuilder extractionError(ExtractionErrorRunFacet extractionError) {
            this.extractionError = extractionError;
            return this;
        }

        public RunFacetsBuilder parent(ParentRunFacet parent) {
            this.parent = parent;
            return this;
        }

        public RunFacetsBuilder nominalTime(NominalTimeRunFacet nominalTime) {
            this.nominalTime = nominalTime;
            return this;
        }

        public RunFacetsBuilder processing_engine(ProcessingEngineRunFacet processing_engine) {
            this.processing_engine = processing_engine;
            return this;
        }

        public RunFacetsBuilder put(String key, RunFacet value) {
            this.additionalProperties.put(key, value);
            return this;
        }

        @Override
        public RunFacets build() {
            RunFacets __result = new RunFacets(this.errorMessage, this.externalQuery, this.extractionError, this.parent, this.nominalTime, this.processing_engine);
            __result.getAdditionalProperties().putAll(this.additionalProperties);
            return __result;
        }
    }

    @JsonDeserialize(as=RunFacets.class)
    @JsonPropertyOrder(value={"errorMessage", "externalQuery", "extractionError", "parent", "nominalTime", "processing_engine"})
    public static final class RunFacets {
        private final ErrorMessageRunFacet errorMessage;
        private final ExternalQueryRunFacet externalQuery;
        private final ExtractionErrorRunFacet extractionError;
        private final ParentRunFacet parent;
        private final NominalTimeRunFacet nominalTime;
        private final ProcessingEngineRunFacet processing_engine;
        @JsonAnySetter
        private final Map<String, RunFacet> additionalProperties;

        @JsonCreator
        private RunFacets(@JsonProperty(value="errorMessage") ErrorMessageRunFacet errorMessage, @JsonProperty(value="externalQuery") ExternalQueryRunFacet externalQuery, @JsonProperty(value="extractionError") ExtractionErrorRunFacet extractionError, @JsonProperty(value="parent") ParentRunFacet parent, @JsonProperty(value="nominalTime") NominalTimeRunFacet nominalTime, @JsonProperty(value="processing_engine") ProcessingEngineRunFacet processing_engine) {
            this.errorMessage = errorMessage;
            this.externalQuery = externalQuery;
            this.extractionError = extractionError;
            this.parent = parent;
            this.nominalTime = nominalTime;
            this.processing_engine = processing_engine;
            this.additionalProperties = new LinkedHashMap<String, RunFacet>();
        }

        public ErrorMessageRunFacet getErrorMessage() {
            return this.errorMessage;
        }

        public ExternalQueryRunFacet getExternalQuery() {
            return this.externalQuery;
        }

        public ExtractionErrorRunFacet getExtractionError() {
            return this.extractionError;
        }

        public ParentRunFacet getParent() {
            return this.parent;
        }

        public NominalTimeRunFacet getNominalTime() {
            return this.nominalTime;
        }

        public ProcessingEngineRunFacet getProcessing_engine() {
            return this.processing_engine;
        }

        @JsonAnyGetter
        public Map<String, RunFacet> getAdditionalProperties() {
            return this.additionalProperties;
        }

        void withAdditionalProperties() {
        }
    }

    @JsonDeserialize(as=DefaultJobFacet.class)
    public static interface JobFacet {
        public URI get_producer();

        public URI get_schemaURL();

        public Boolean get_deleted();

        @JsonIgnore
        default public Boolean isDeleted() {
            return this.get_deleted();
        }

        public Map<String, Object> getAdditionalProperties();
    }

    public static class DefaultJobFacet
    implements JobFacet {
        private final URI _producer;
        private final URI _schemaURL;
        private final Boolean _deleted;
        @JsonAnySetter
        private final Map<String, Object> additionalProperties;

        @JsonCreator
        public DefaultJobFacet(@JsonProperty(value="_producer") URI _producer, @JsonProperty(value="_deleted") Boolean _deleted) {
            this._producer = _producer;
            this._schemaURL = URI.create("https://openlineage.io/spec/2-0-2/OpenLineage.json#/$defs/JobFacet");
            this._deleted = _deleted;
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }

        @Override
        public URI get_producer() {
            return this._producer;
        }

        @Override
        public URI get_schemaURL() {
            return this._schemaURL;
        }

        @Override
        public Boolean get_deleted() {
            return this._deleted;
        }

        @Override
        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }
    }

    public final class ErrorMessageRunFacetBuilder
    implements Builder<ErrorMessageRunFacet> {
        private String message;
        private String programmingLanguage;
        private String stackTrace;
        private final Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

        public ErrorMessageRunFacetBuilder message(String message) {
            this.message = message;
            return this;
        }

        public ErrorMessageRunFacetBuilder programmingLanguage(String programmingLanguage) {
            this.programmingLanguage = programmingLanguage;
            return this;
        }

        public ErrorMessageRunFacetBuilder stackTrace(String stackTrace) {
            this.stackTrace = stackTrace;
            return this;
        }

        public ErrorMessageRunFacetBuilder put(String key, Object value) {
            this.additionalProperties.put(key, value);
            return this;
        }

        @Override
        public ErrorMessageRunFacet build() {
            ErrorMessageRunFacet __result = new ErrorMessageRunFacet(OpenLineage.this.producer, this.message, this.programmingLanguage, this.stackTrace);
            __result.getAdditionalProperties().putAll(this.additionalProperties);
            return __result;
        }
    }

    @JsonDeserialize(as=ErrorMessageRunFacet.class)
    @JsonPropertyOrder(value={"_producer", "_schemaURL", "message", "programmingLanguage", "stackTrace"})
    public static final class ErrorMessageRunFacet
    implements RunFacet {
        private final URI _producer;
        private final URI _schemaURL;
        private final String message;
        private final String programmingLanguage;
        private final String stackTrace;
        @JsonAnySetter
        private final Map<String, Object> additionalProperties;

        @JsonCreator
        private ErrorMessageRunFacet(@JsonProperty(value="_producer") URI _producer, @JsonProperty(value="message") String message, @JsonProperty(value="programmingLanguage") String programmingLanguage, @JsonProperty(value="stackTrace") String stackTrace) {
            this._producer = _producer;
            this._schemaURL = URI.create("https://openlineage.io/spec/facets/1-0-0/ErrorMessageRunFacet.json#/$defs/ErrorMessageRunFacet");
            this.message = message;
            this.programmingLanguage = programmingLanguage;
            this.stackTrace = stackTrace;
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }

        @Override
        public URI get_producer() {
            return this._producer;
        }

        @Override
        public URI get_schemaURL() {
            return this._schemaURL;
        }

        public String getMessage() {
            return this.message;
        }

        public String getProgrammingLanguage() {
            return this.programmingLanguage;
        }

        public String getStackTrace() {
            return this.stackTrace;
        }

        @Override
        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        void withAdditionalProperties() {
        }
    }

    public static final class OutputDatasetBuilder
    implements Builder<OutputDataset> {
        private String namespace;
        private String name;
        private DatasetFacets facets;
        private OutputDatasetOutputFacets outputFacets;

        public OutputDatasetBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public OutputDatasetBuilder name(String name) {
            this.name = name;
            return this;
        }

        public OutputDatasetBuilder facets(DatasetFacets facets) {
            this.facets = facets;
            return this;
        }

        public OutputDatasetBuilder outputFacets(OutputDatasetOutputFacets outputFacets) {
            this.outputFacets = outputFacets;
            return this;
        }

        @Override
        public OutputDataset build() {
            OutputDataset __result = new OutputDataset(this.namespace, this.name, this.facets, this.outputFacets);
            return __result;
        }
    }

    @JsonDeserialize(as=OutputDataset.class)
    @JsonPropertyOrder(value={"namespace", "name", "facets", "outputFacets"})
    public static final class OutputDataset
    implements Dataset {
        private final String namespace;
        private final String name;
        private final DatasetFacets facets;
        private final OutputDatasetOutputFacets outputFacets;

        @JsonCreator
        private OutputDataset(@JsonProperty(value="namespace") String namespace, @JsonProperty(value="name") String name, @JsonProperty(value="facets") DatasetFacets facets, @JsonProperty(value="outputFacets") OutputDatasetOutputFacets outputFacets) {
            this.namespace = namespace;
            this.name = name;
            this.facets = facets;
            this.outputFacets = outputFacets;
        }

        @Override
        public String getNamespace() {
            return this.namespace;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public DatasetFacets getFacets() {
            return this.facets;
        }

        public OutputDatasetOutputFacets getOutputFacets() {
            return this.outputFacets;
        }
    }

    public static final class ParentRunFacetJobBuilder
    implements Builder<ParentRunFacetJob> {
        private String namespace;
        private String name;

        public ParentRunFacetJobBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public ParentRunFacetJobBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public ParentRunFacetJob build() {
            ParentRunFacetJob __result = new ParentRunFacetJob(this.namespace, this.name);
            return __result;
        }
    }

    @JsonDeserialize(as=ParentRunFacetJob.class)
    @JsonPropertyOrder(value={"namespace", "name"})
    public static final class ParentRunFacetJob {
        private final String namespace;
        private final String name;

        @JsonCreator
        private ParentRunFacetJob(@JsonProperty(value="namespace") String namespace, @JsonProperty(value="name") String name) {
            this.namespace = namespace;
            this.name = name;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public String getName() {
            return this.name;
        }
    }

    public final class OwnershipJobFacetBuilder
    implements Builder<OwnershipJobFacet> {
        private List<OwnershipJobFacetOwners> owners;
        private final Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

        public OwnershipJobFacetBuilder owners(List<OwnershipJobFacetOwners> owners) {
            this.owners = owners;
            return this;
        }

        public OwnershipJobFacetBuilder put(String key, Object value) {
            this.additionalProperties.put(key, value);
            return this;
        }

        @Override
        public OwnershipJobFacet build() {
            OwnershipJobFacet __result = new OwnershipJobFacet(OpenLineage.this.producer, this.owners);
            __result.getAdditionalProperties().putAll(this.additionalProperties);
            return __result;
        }
    }

    @JsonDeserialize(as=OwnershipJobFacet.class)
    @JsonPropertyOrder(value={"_producer", "_schemaURL", "_deleted", "owners"})
    public static final class OwnershipJobFacet
    implements JobFacet {
        private final URI _producer;
        private final URI _schemaURL;
        private final Boolean _deleted;
        private final List<OwnershipJobFacetOwners> owners;
        @JsonAnySetter
        private final Map<String, Object> additionalProperties;

        @JsonCreator
        private OwnershipJobFacet(@JsonProperty(value="_producer") URI _producer, @JsonProperty(value="owners") List<OwnershipJobFacetOwners> owners) {
            this._producer = _producer;
            this._schemaURL = URI.create("https://openlineage.io/spec/facets/1-0-0/OwnershipJobFacet.json#/$defs/OwnershipJobFacet");
            this._deleted = null;
            this.owners = owners;
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }

        @Override
        public URI get_producer() {
            return this._producer;
        }

        @Override
        public URI get_schemaURL() {
            return this._schemaURL;
        }

        @Override
        public Boolean get_deleted() {
            return this._deleted;
        }

        public List<OwnershipJobFacetOwners> getOwners() {
            return this.owners;
        }

        @Override
        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        void withAdditionalProperties() {
        }
    }

    public static final class DatasetFacetsBuilder
    implements Builder<DatasetFacets> {
        private DocumentationDatasetFacet documentation;
        private DatasourceDatasetFacet dataSource;
        private DatasetVersionDatasetFacet version;
        private SchemaDatasetFacet schema;
        private OwnershipDatasetFacet ownership;
        private StorageDatasetFacet storage;
        private ColumnLineageDatasetFacet columnLineage;
        private SymlinksDatasetFacet symlinks;
        private LifecycleStateChangeDatasetFacet lifecycleStateChange;
        private final Map<String, DatasetFacet> additionalProperties = new LinkedHashMap<String, DatasetFacet>();

        public DatasetFacetsBuilder documentation(DocumentationDatasetFacet documentation) {
            this.documentation = documentation;
            return this;
        }

        public DatasetFacetsBuilder dataSource(DatasourceDatasetFacet dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public DatasetFacetsBuilder version(DatasetVersionDatasetFacet version) {
            this.version = version;
            return this;
        }

        public DatasetFacetsBuilder schema(SchemaDatasetFacet schema) {
            this.schema = schema;
            return this;
        }

        public DatasetFacetsBuilder ownership(OwnershipDatasetFacet ownership) {
            this.ownership = ownership;
            return this;
        }

        public DatasetFacetsBuilder storage(StorageDatasetFacet storage) {
            this.storage = storage;
            return this;
        }

        public DatasetFacetsBuilder columnLineage(ColumnLineageDatasetFacet columnLineage) {
            this.columnLineage = columnLineage;
            return this;
        }

        public DatasetFacetsBuilder symlinks(SymlinksDatasetFacet symlinks) {
            this.symlinks = symlinks;
            return this;
        }

        public DatasetFacetsBuilder lifecycleStateChange(LifecycleStateChangeDatasetFacet lifecycleStateChange) {
            this.lifecycleStateChange = lifecycleStateChange;
            return this;
        }

        public DatasetFacetsBuilder put(String key, DatasetFacet value) {
            this.additionalProperties.put(key, value);
            return this;
        }

        @Override
        public DatasetFacets build() {
            DatasetFacets __result = new DatasetFacets(this.documentation, this.dataSource, this.version, this.schema, this.ownership, this.storage, this.columnLineage, this.symlinks, this.lifecycleStateChange);
            __result.getAdditionalProperties().putAll(this.additionalProperties);
            return __result;
        }
    }

    @JsonDeserialize(as=DatasetFacets.class)
    @JsonPropertyOrder(value={"documentation", "dataSource", "version", "schema", "ownership", "storage", "columnLineage", "symlinks", "lifecycleStateChange"})
    public static final class DatasetFacets {
        private final DocumentationDatasetFacet documentation;
        private final DatasourceDatasetFacet dataSource;
        private final DatasetVersionDatasetFacet version;
        private final SchemaDatasetFacet schema;
        private final OwnershipDatasetFacet ownership;
        private final StorageDatasetFacet storage;
        private final ColumnLineageDatasetFacet columnLineage;
        private final SymlinksDatasetFacet symlinks;
        private final LifecycleStateChangeDatasetFacet lifecycleStateChange;
        @JsonAnySetter
        private final Map<String, DatasetFacet> additionalProperties;

        @JsonCreator
        private DatasetFacets(@JsonProperty(value="documentation") DocumentationDatasetFacet documentation, @JsonProperty(value="dataSource") DatasourceDatasetFacet dataSource, @JsonProperty(value="version") DatasetVersionDatasetFacet version, @JsonProperty(value="schema") SchemaDatasetFacet schema, @JsonProperty(value="ownership") OwnershipDatasetFacet ownership, @JsonProperty(value="storage") StorageDatasetFacet storage, @JsonProperty(value="columnLineage") ColumnLineageDatasetFacet columnLineage, @JsonProperty(value="symlinks") SymlinksDatasetFacet symlinks, @JsonProperty(value="lifecycleStateChange") LifecycleStateChangeDatasetFacet lifecycleStateChange) {
            this.documentation = documentation;
            this.dataSource = dataSource;
            this.version = version;
            this.schema = schema;
            this.ownership = ownership;
            this.storage = storage;
            this.columnLineage = columnLineage;
            this.symlinks = symlinks;
            this.lifecycleStateChange = lifecycleStateChange;
            this.additionalProperties = new LinkedHashMap<String, DatasetFacet>();
        }

        public DocumentationDatasetFacet getDocumentation() {
            return this.documentation;
        }

        public DatasourceDatasetFacet getDataSource() {
            return this.dataSource;
        }

        public DatasetVersionDatasetFacet getVersion() {
            return this.version;
        }

        public SchemaDatasetFacet getSchema() {
            return this.schema;
        }

        public OwnershipDatasetFacet getOwnership() {
            return this.ownership;
        }

        public StorageDatasetFacet getStorage() {
            return this.storage;
        }

        public ColumnLineageDatasetFacet getColumnLineage() {
            return this.columnLineage;
        }

        public SymlinksDatasetFacet getSymlinks() {
            return this.symlinks;
        }

        public LifecycleStateChangeDatasetFacet getLifecycleStateChange() {
            return this.lifecycleStateChange;
        }

        @JsonAnyGetter
        public Map<String, DatasetFacet> getAdditionalProperties() {
            return this.additionalProperties;
        }

        void withAdditionalProperties() {
        }
    }

    public final class SQLJobFacetBuilder
    implements Builder<SQLJobFacet> {
        private String query;
        private final Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

        public SQLJobFacetBuilder query(String query) {
            this.query = query;
            return this;
        }

        public SQLJobFacetBuilder put(String key, Object value) {
            this.additionalProperties.put(key, value);
            return this;
        }

        @Override
        public SQLJobFacet build() {
            SQLJobFacet __result = new SQLJobFacet(OpenLineage.this.producer, this.query);
            __result.getAdditionalProperties().putAll(this.additionalProperties);
            return __result;
        }
    }

    @JsonDeserialize(as=SQLJobFacet.class)
    @JsonPropertyOrder(value={"_producer", "_schemaURL", "_deleted", "query"})
    public static final class SQLJobFacet
    implements JobFacet {
        private final URI _producer;
        private final URI _schemaURL;
        private final Boolean _deleted;
        private final String query;
        @JsonAnySetter
        private final Map<String, Object> additionalProperties;

        @JsonCreator
        private SQLJobFacet(@JsonProperty(value="_producer") URI _producer, @JsonProperty(value="query") String query) {
            this._producer = _producer;
            this._schemaURL = URI.create("https://openlineage.io/spec/facets/1-0-0/SQLJobFacet.json#/$defs/SQLJobFacet");
            this._deleted = null;
            this.query = query;
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }

        @Override
        public URI get_producer() {
            return this._producer;
        }

        @Override
        public URI get_schemaURL() {
            return this._schemaURL;
        }

        @Override
        public Boolean get_deleted() {
            return this._deleted;
        }

        public String getQuery() {
            return this.query;
        }

        @Override
        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        void withAdditionalProperties() {
        }
    }

    public final class OwnershipDatasetFacetBuilder
    implements Builder<OwnershipDatasetFacet> {
        private List<OwnershipDatasetFacetOwners> owners;
        private final Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

        public OwnershipDatasetFacetBuilder owners(List<OwnershipDatasetFacetOwners> owners) {
            this.owners = owners;
            return this;
        }

        public OwnershipDatasetFacetBuilder put(String key, Object value) {
            this.additionalProperties.put(key, value);
            return this;
        }

        @Override
        public OwnershipDatasetFacet build() {
            OwnershipDatasetFacet __result = new OwnershipDatasetFacet(OpenLineage.this.producer, this.owners);
            __result.getAdditionalProperties().putAll(this.additionalProperties);
            return __result;
        }
    }

    @JsonDeserialize(as=OwnershipDatasetFacet.class)
    @JsonPropertyOrder(value={"_producer", "_schemaURL", "_deleted", "owners"})
    public static final class OwnershipDatasetFacet
    implements DatasetFacet {
        private final URI _producer;
        private final URI _schemaURL;
        private final Boolean _deleted;
        private final List<OwnershipDatasetFacetOwners> owners;
        @JsonAnySetter
        private final Map<String, Object> additionalProperties;

        @JsonCreator
        private OwnershipDatasetFacet(@JsonProperty(value="_producer") URI _producer, @JsonProperty(value="owners") List<OwnershipDatasetFacetOwners> owners) {
            this._producer = _producer;
            this._schemaURL = URI.create("https://openlineage.io/spec/facets/1-0-0/OwnershipDatasetFacet.json#/$defs/OwnershipDatasetFacet");
            this._deleted = null;
            this.owners = owners;
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }

        @Override
        public URI get_producer() {
            return this._producer;
        }

        @Override
        public URI get_schemaURL() {
            return this._schemaURL;
        }

        @Override
        public Boolean get_deleted() {
            return this._deleted;
        }

        public List<OwnershipDatasetFacetOwners> getOwners() {
            return this.owners;
        }

        @Override
        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        void withAdditionalProperties() {
        }
    }

    @JsonDeserialize(as=DefaultDatasetFacet.class)
    public static interface DatasetFacet {
        public URI get_producer();

        public URI get_schemaURL();

        public Boolean get_deleted();

        @JsonIgnore
        default public Boolean isDeleted() {
            return this.get_deleted();
        }

        public Map<String, Object> getAdditionalProperties();
    }

    public static class DefaultDatasetFacet
    implements DatasetFacet {
        private final URI _producer;
        private final URI _schemaURL;
        private final Boolean _deleted;
        @JsonAnySetter
        private final Map<String, Object> additionalProperties;

        @JsonCreator
        public DefaultDatasetFacet(@JsonProperty(value="_producer") URI _producer, @JsonProperty(value="_deleted") Boolean _deleted) {
            this._producer = _producer;
            this._schemaURL = URI.create("https://openlineage.io/spec/2-0-2/OpenLineage.json#/$defs/DatasetFacet");
            this._deleted = _deleted;
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }

        @Override
        public URI get_producer() {
            return this._producer;
        }

        @Override
        public URI get_schemaURL() {
            return this._schemaURL;
        }

        @Override
        public Boolean get_deleted() {
            return this._deleted;
        }

        @Override
        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }
    }

    public static final class InputDatasetInputFacetsBuilder
    implements Builder<InputDatasetInputFacets> {
        private DataQualityAssertionsDatasetFacet dataQualityAssertions;
        private DataQualityMetricsInputDatasetFacet dataQualityMetrics;
        private final Map<String, InputDatasetFacet> additionalProperties = new LinkedHashMap<String, InputDatasetFacet>();

        public InputDatasetInputFacetsBuilder dataQualityAssertions(DataQualityAssertionsDatasetFacet dataQualityAssertions) {
            this.dataQualityAssertions = dataQualityAssertions;
            return this;
        }

        public InputDatasetInputFacetsBuilder dataQualityMetrics(DataQualityMetricsInputDatasetFacet dataQualityMetrics) {
            this.dataQualityMetrics = dataQualityMetrics;
            return this;
        }

        public InputDatasetInputFacetsBuilder put(String key, InputDatasetFacet value) {
            this.additionalProperties.put(key, value);
            return this;
        }

        @Override
        public InputDatasetInputFacets build() {
            InputDatasetInputFacets __result = new InputDatasetInputFacets(this.dataQualityAssertions, this.dataQualityMetrics);
            __result.getAdditionalProperties().putAll(this.additionalProperties);
            return __result;
        }
    }

    @JsonDeserialize(as=InputDatasetInputFacets.class)
    @JsonPropertyOrder(value={"dataQualityAssertions", "dataQualityMetrics"})
    public static final class InputDatasetInputFacets {
        private final DataQualityAssertionsDatasetFacet dataQualityAssertions;
        private final DataQualityMetricsInputDatasetFacet dataQualityMetrics;
        @JsonAnySetter
        private final Map<String, InputDatasetFacet> additionalProperties;

        @JsonCreator
        private InputDatasetInputFacets(@JsonProperty(value="dataQualityAssertions") DataQualityAssertionsDatasetFacet dataQualityAssertions, @JsonProperty(value="dataQualityMetrics") DataQualityMetricsInputDatasetFacet dataQualityMetrics) {
            this.dataQualityAssertions = dataQualityAssertions;
            this.dataQualityMetrics = dataQualityMetrics;
            this.additionalProperties = new LinkedHashMap<String, InputDatasetFacet>();
        }

        public DataQualityAssertionsDatasetFacet getDataQualityAssertions() {
            return this.dataQualityAssertions;
        }

        public DataQualityMetricsInputDatasetFacet getDataQualityMetrics() {
            return this.dataQualityMetrics;
        }

        @JsonAnyGetter
        public Map<String, InputDatasetFacet> getAdditionalProperties() {
            return this.additionalProperties;
        }

        void withAdditionalProperties() {
        }
    }

    public static final class JobFacetsBuilder
    implements Builder<JobFacets> {
        private SourceCodeJobFacet sourceCode;
        private OwnershipJobFacet ownership;
        private SQLJobFacet sql;
        private SourceCodeLocationJobFacet sourceCodeLocation;
        private DocumentationJobFacet documentation;
        private final Map<String, JobFacet> additionalProperties = new LinkedHashMap<String, JobFacet>();

        public JobFacetsBuilder sourceCode(SourceCodeJobFacet sourceCode) {
            this.sourceCode = sourceCode;
            return this;
        }

        public JobFacetsBuilder ownership(OwnershipJobFacet ownership) {
            this.ownership = ownership;
            return this;
        }

        public JobFacetsBuilder sql(SQLJobFacet sql) {
            this.sql = sql;
            return this;
        }

        public JobFacetsBuilder sourceCodeLocation(SourceCodeLocationJobFacet sourceCodeLocation) {
            this.sourceCodeLocation = sourceCodeLocation;
            return this;
        }

        public JobFacetsBuilder documentation(DocumentationJobFacet documentation) {
            this.documentation = documentation;
            return this;
        }

        public JobFacetsBuilder put(String key, JobFacet value) {
            this.additionalProperties.put(key, value);
            return this;
        }

        @Override
        public JobFacets build() {
            JobFacets __result = new JobFacets(this.sourceCode, this.ownership, this.sql, this.sourceCodeLocation, this.documentation);
            __result.getAdditionalProperties().putAll(this.additionalProperties);
            return __result;
        }
    }

    @JsonDeserialize(as=JobFacets.class)
    @JsonPropertyOrder(value={"sourceCode", "ownership", "sql", "sourceCodeLocation", "documentation"})
    public static final class JobFacets {
        private final SourceCodeJobFacet sourceCode;
        private final OwnershipJobFacet ownership;
        private final SQLJobFacet sql;
        private final SourceCodeLocationJobFacet sourceCodeLocation;
        private final DocumentationJobFacet documentation;
        @JsonAnySetter
        private final Map<String, JobFacet> additionalProperties;

        @JsonCreator
        private JobFacets(@JsonProperty(value="sourceCode") SourceCodeJobFacet sourceCode, @JsonProperty(value="ownership") OwnershipJobFacet ownership, @JsonProperty(value="sql") SQLJobFacet sql, @JsonProperty(value="sourceCodeLocation") SourceCodeLocationJobFacet sourceCodeLocation, @JsonProperty(value="documentation") DocumentationJobFacet documentation) {
            this.sourceCode = sourceCode;
            this.ownership = ownership;
            this.sql = sql;
            this.sourceCodeLocation = sourceCodeLocation;
            this.documentation = documentation;
            this.additionalProperties = new LinkedHashMap<String, JobFacet>();
        }

        public SourceCodeJobFacet getSourceCode() {
            return this.sourceCode;
        }

        public OwnershipJobFacet getOwnership() {
            return this.ownership;
        }

        public SQLJobFacet getSql() {
            return this.sql;
        }

        public SourceCodeLocationJobFacet getSourceCodeLocation() {
            return this.sourceCodeLocation;
        }

        public DocumentationJobFacet getDocumentation() {
            return this.documentation;
        }

        @JsonAnyGetter
        public Map<String, JobFacet> getAdditionalProperties() {
            return this.additionalProperties;
        }

        void withAdditionalProperties() {
        }
    }

    public final class DocumentationJobFacetBuilder
    implements Builder<DocumentationJobFacet> {
        private String description;
        private final Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

        public DocumentationJobFacetBuilder description(String description) {
            this.description = description;
            return this;
        }

        public DocumentationJobFacetBuilder put(String key, Object value) {
            this.additionalProperties.put(key, value);
            return this;
        }

        @Override
        public DocumentationJobFacet build() {
            DocumentationJobFacet __result = new DocumentationJobFacet(OpenLineage.this.producer, this.description);
            __result.getAdditionalProperties().putAll(this.additionalProperties);
            return __result;
        }
    }

    @JsonDeserialize(as=DocumentationJobFacet.class)
    @JsonPropertyOrder(value={"_producer", "_schemaURL", "_deleted", "description"})
    public static final class DocumentationJobFacet
    implements JobFacet {
        private final URI _producer;
        private final URI _schemaURL;
        private final Boolean _deleted;
        private final String description;
        @JsonAnySetter
        private final Map<String, Object> additionalProperties;

        @JsonCreator
        private DocumentationJobFacet(@JsonProperty(value="_producer") URI _producer, @JsonProperty(value="description") String description) {
            this._producer = _producer;
            this._schemaURL = URI.create("https://openlineage.io/spec/facets/1-0-0/DocumentationJobFacet.json#/$defs/DocumentationJobFacet");
            this._deleted = null;
            this.description = description;
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }

        @Override
        public URI get_producer() {
            return this._producer;
        }

        @Override
        public URI get_schemaURL() {
            return this._schemaURL;
        }

        @Override
        public Boolean get_deleted() {
            return this._deleted;
        }

        public String getDescription() {
            return this.description;
        }

        @Override
        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        void withAdditionalProperties() {
        }
    }

    public final class DataQualityMetricsInputDatasetFacetBuilder
    implements Builder<DataQualityMetricsInputDatasetFacet> {
        private Long rowCount;
        private Long bytes;
        private DataQualityMetricsInputDatasetFacetColumnMetrics columnMetrics;
        private final Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

        public DataQualityMetricsInputDatasetFacetBuilder rowCount(Long rowCount) {
            this.rowCount = rowCount;
            return this;
        }

        public DataQualityMetricsInputDatasetFacetBuilder bytes(Long bytes) {
            this.bytes = bytes;
            return this;
        }

        public DataQualityMetricsInputDatasetFacetBuilder columnMetrics(DataQualityMetricsInputDatasetFacetColumnMetrics columnMetrics) {
            this.columnMetrics = columnMetrics;
            return this;
        }

        public DataQualityMetricsInputDatasetFacetBuilder put(String key, Object value) {
            this.additionalProperties.put(key, value);
            return this;
        }

        @Override
        public DataQualityMetricsInputDatasetFacet build() {
            DataQualityMetricsInputDatasetFacet __result = new DataQualityMetricsInputDatasetFacet(OpenLineage.this.producer, this.rowCount, this.bytes, this.columnMetrics);
            __result.getAdditionalProperties().putAll(this.additionalProperties);
            return __result;
        }
    }

    @JsonDeserialize(as=DataQualityMetricsInputDatasetFacet.class)
    @JsonPropertyOrder(value={"_producer", "_schemaURL", "rowCount", "bytes", "columnMetrics"})
    public static final class DataQualityMetricsInputDatasetFacet
    implements InputDatasetFacet {
        private final URI _producer;
        private final URI _schemaURL;
        private final Long rowCount;
        private final Long bytes;
        private final DataQualityMetricsInputDatasetFacetColumnMetrics columnMetrics;
        @JsonAnySetter
        private final Map<String, Object> additionalProperties;

        @JsonCreator
        private DataQualityMetricsInputDatasetFacet(@JsonProperty(value="_producer") URI _producer, @JsonProperty(value="rowCount") Long rowCount, @JsonProperty(value="bytes") Long bytes, @JsonProperty(value="columnMetrics") DataQualityMetricsInputDatasetFacetColumnMetrics columnMetrics) {
            this._producer = _producer;
            this._schemaURL = URI.create("https://openlineage.io/spec/facets/1-0-0/DataQualityMetricsInputDatasetFacet.json#/$defs/DataQualityMetricsInputDatasetFacet");
            this.rowCount = rowCount;
            this.bytes = bytes;
            this.columnMetrics = columnMetrics;
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }

        @Override
        public URI get_producer() {
            return this._producer;
        }

        @Override
        public URI get_schemaURL() {
            return this._schemaURL;
        }

        public Long getRowCount() {
            return this.rowCount;
        }

        public Long getBytes() {
            return this.bytes;
        }

        public DataQualityMetricsInputDatasetFacetColumnMetrics getColumnMetrics() {
            return this.columnMetrics;
        }

        @Override
        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        void withAdditionalProperties() {
        }
    }

    public static final class DataQualityMetricsInputDatasetFacetColumnMetricsBuilder
    implements Builder<DataQualityMetricsInputDatasetFacetColumnMetrics> {
        private final Map<String, DataQualityMetricsInputDatasetFacetColumnMetricsAdditional> additionalProperties = new LinkedHashMap<String, DataQualityMetricsInputDatasetFacetColumnMetricsAdditional>();

        public DataQualityMetricsInputDatasetFacetColumnMetricsBuilder put(String key, DataQualityMetricsInputDatasetFacetColumnMetricsAdditional value) {
            this.additionalProperties.put(key, value);
            return this;
        }

        @Override
        public DataQualityMetricsInputDatasetFacetColumnMetrics build() {
            DataQualityMetricsInputDatasetFacetColumnMetrics __result = new DataQualityMetricsInputDatasetFacetColumnMetrics();
            __result.getAdditionalProperties().putAll(this.additionalProperties);
            return __result;
        }
    }

    @JsonDeserialize(as=DataQualityMetricsInputDatasetFacetColumnMetrics.class)
    @JsonPropertyOrder
    public static final class DataQualityMetricsInputDatasetFacetColumnMetrics {
        @JsonAnySetter
        private final Map<String, DataQualityMetricsInputDatasetFacetColumnMetricsAdditional> additionalProperties = new LinkedHashMap<String, DataQualityMetricsInputDatasetFacetColumnMetricsAdditional>();

        @JsonCreator
        private DataQualityMetricsInputDatasetFacetColumnMetrics() {
        }

        @JsonAnyGetter
        public Map<String, DataQualityMetricsInputDatasetFacetColumnMetricsAdditional> getAdditionalProperties() {
            return this.additionalProperties;
        }

        void withAdditionalProperties() {
        }
    }

    public static final class DataQualityMetricsInputDatasetFacetColumnMetricsAdditionalBuilder
    implements Builder<DataQualityMetricsInputDatasetFacetColumnMetricsAdditional> {
        private Long nullCount;
        private Long distinctCount;
        private Double sum;
        private Double count;
        private Double min;
        private Double max;
        private DataQualityMetricsInputDatasetFacetColumnMetricsAdditionalQuantiles quantiles;

        public DataQualityMetricsInputDatasetFacetColumnMetricsAdditionalBuilder nullCount(Long nullCount) {
            this.nullCount = nullCount;
            return this;
        }

        public DataQualityMetricsInputDatasetFacetColumnMetricsAdditionalBuilder distinctCount(Long distinctCount) {
            this.distinctCount = distinctCount;
            return this;
        }

        public DataQualityMetricsInputDatasetFacetColumnMetricsAdditionalBuilder sum(Double sum) {
            this.sum = sum;
            return this;
        }

        public DataQualityMetricsInputDatasetFacetColumnMetricsAdditionalBuilder count(Double count) {
            this.count = count;
            return this;
        }

        public DataQualityMetricsInputDatasetFacetColumnMetricsAdditionalBuilder min(Double min) {
            this.min = min;
            return this;
        }

        public DataQualityMetricsInputDatasetFacetColumnMetricsAdditionalBuilder max(Double max) {
            this.max = max;
            return this;
        }

        public DataQualityMetricsInputDatasetFacetColumnMetricsAdditionalBuilder quantiles(DataQualityMetricsInputDatasetFacetColumnMetricsAdditionalQuantiles quantiles) {
            this.quantiles = quantiles;
            return this;
        }

        @Override
        public DataQualityMetricsInputDatasetFacetColumnMetricsAdditional build() {
            DataQualityMetricsInputDatasetFacetColumnMetricsAdditional __result = new DataQualityMetricsInputDatasetFacetColumnMetricsAdditional(this.nullCount, this.distinctCount, this.sum, this.count, this.min, this.max, this.quantiles);
            return __result;
        }
    }

    @JsonDeserialize(as=DataQualityMetricsInputDatasetFacetColumnMetricsAdditional.class)
    @JsonPropertyOrder(value={"nullCount", "distinctCount", "sum", "count", "min", "max", "quantiles"})
    public static final class DataQualityMetricsInputDatasetFacetColumnMetricsAdditional {
        private final Long nullCount;
        private final Long distinctCount;
        private final Double sum;
        private final Double count;
        private final Double min;
        private final Double max;
        private final DataQualityMetricsInputDatasetFacetColumnMetricsAdditionalQuantiles quantiles;

        @JsonCreator
        private DataQualityMetricsInputDatasetFacetColumnMetricsAdditional(@JsonProperty(value="nullCount") Long nullCount, @JsonProperty(value="distinctCount") Long distinctCount, @JsonProperty(value="sum") Double sum, @JsonProperty(value="count") Double count, @JsonProperty(value="min") Double min, @JsonProperty(value="max") Double max, @JsonProperty(value="quantiles") DataQualityMetricsInputDatasetFacetColumnMetricsAdditionalQuantiles quantiles) {
            this.nullCount = nullCount;
            this.distinctCount = distinctCount;
            this.sum = sum;
            this.count = count;
            this.min = min;
            this.max = max;
            this.quantiles = quantiles;
        }

        public Long getNullCount() {
            return this.nullCount;
        }

        public Long getDistinctCount() {
            return this.distinctCount;
        }

        public Double getSum() {
            return this.sum;
        }

        public Double getCount() {
            return this.count;
        }

        public Double getMin() {
            return this.min;
        }

        public Double getMax() {
            return this.max;
        }

        public DataQualityMetricsInputDatasetFacetColumnMetricsAdditionalQuantiles getQuantiles() {
            return this.quantiles;
        }
    }

    public static final class OwnershipDatasetFacetOwnersBuilder
    implements Builder<OwnershipDatasetFacetOwners> {
        private String name;
        private String type;

        public OwnershipDatasetFacetOwnersBuilder name(String name) {
            this.name = name;
            return this;
        }

        public OwnershipDatasetFacetOwnersBuilder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public OwnershipDatasetFacetOwners build() {
            OwnershipDatasetFacetOwners __result = new OwnershipDatasetFacetOwners(this.name, this.type);
            return __result;
        }
    }

    @JsonDeserialize(as=OwnershipDatasetFacetOwners.class)
    @JsonPropertyOrder(value={"name", "type"})
    public static final class OwnershipDatasetFacetOwners {
        private final String name;
        private final String type;

        @JsonCreator
        private OwnershipDatasetFacetOwners(@JsonProperty(value="name") String name, @JsonProperty(value="type") String type) {
            this.name = name;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }
    }

    public final class ExtractionErrorRunFacetBuilder
    implements Builder<ExtractionErrorRunFacet> {
        private Long totalTasks;
        private Long failedTasks;
        private List<ExtractionErrorRunFacetErrors> errors;
        private final Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

        public ExtractionErrorRunFacetBuilder totalTasks(Long totalTasks) {
            this.totalTasks = totalTasks;
            return this;
        }

        public ExtractionErrorRunFacetBuilder failedTasks(Long failedTasks) {
            this.failedTasks = failedTasks;
            return this;
        }

        public ExtractionErrorRunFacetBuilder errors(List<ExtractionErrorRunFacetErrors> errors) {
            this.errors = errors;
            return this;
        }

        public ExtractionErrorRunFacetBuilder put(String key, Object value) {
            this.additionalProperties.put(key, value);
            return this;
        }

        @Override
        public ExtractionErrorRunFacet build() {
            ExtractionErrorRunFacet __result = new ExtractionErrorRunFacet(OpenLineage.this.producer, this.totalTasks, this.failedTasks, this.errors);
            __result.getAdditionalProperties().putAll(this.additionalProperties);
            return __result;
        }
    }

    @JsonDeserialize(as=ExtractionErrorRunFacet.class)
    @JsonPropertyOrder(value={"_producer", "_schemaURL", "totalTasks", "failedTasks", "errors"})
    public static final class ExtractionErrorRunFacet
    implements RunFacet {
        private final URI _producer;
        private final URI _schemaURL;
        private final Long totalTasks;
        private final Long failedTasks;
        private final List<ExtractionErrorRunFacetErrors> errors;
        @JsonAnySetter
        private final Map<String, Object> additionalProperties;

        @JsonCreator
        private ExtractionErrorRunFacet(@JsonProperty(value="_producer") URI _producer, @JsonProperty(value="totalTasks") Long totalTasks, @JsonProperty(value="failedTasks") Long failedTasks, @JsonProperty(value="errors") List<ExtractionErrorRunFacetErrors> errors) {
            this._producer = _producer;
            this._schemaURL = URI.create("https://openlineage.io/spec/facets/1-1-0/ExtractionErrorRunFacet.json#/$defs/ExtractionErrorRunFacet");
            this.totalTasks = totalTasks;
            this.failedTasks = failedTasks;
            this.errors = errors;
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }

        @Override
        public URI get_producer() {
            return this._producer;
        }

        @Override
        public URI get_schemaURL() {
            return this._schemaURL;
        }

        public Long getTotalTasks() {
            return this.totalTasks;
        }

        public Long getFailedTasks() {
            return this.failedTasks;
        }

        public List<ExtractionErrorRunFacetErrors> getErrors() {
            return this.errors;
        }

        @Override
        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        void withAdditionalProperties() {
        }
    }

    public static final class ColumnLineageDatasetFacetFieldsAdditionalBuilder
    implements Builder<ColumnLineageDatasetFacetFieldsAdditional> {
        private List<ColumnLineageDatasetFacetFieldsAdditionalInputFields> inputFields;
        private String transformationDescription;
        private String transformationType;
        private final Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

        public ColumnLineageDatasetFacetFieldsAdditionalBuilder inputFields(List<ColumnLineageDatasetFacetFieldsAdditionalInputFields> inputFields) {
            this.inputFields = inputFields;
            return this;
        }

        public ColumnLineageDatasetFacetFieldsAdditionalBuilder transformationDescription(String transformationDescription) {
            this.transformationDescription = transformationDescription;
            return this;
        }

        public ColumnLineageDatasetFacetFieldsAdditionalBuilder transformationType(String transformationType) {
            this.transformationType = transformationType;
            return this;
        }

        public ColumnLineageDatasetFacetFieldsAdditionalBuilder put(String key, Object value) {
            this.additionalProperties.put(key, value);
            return this;
        }

        @Override
        public ColumnLineageDatasetFacetFieldsAdditional build() {
            ColumnLineageDatasetFacetFieldsAdditional __result = new ColumnLineageDatasetFacetFieldsAdditional(this.inputFields, this.transformationDescription, this.transformationType);
            __result.getAdditionalProperties().putAll(this.additionalProperties);
            return __result;
        }
    }

    @JsonDeserialize(as=ColumnLineageDatasetFacetFieldsAdditional.class)
    @JsonPropertyOrder(value={"inputFields", "transformationDescription", "transformationType"})
    public static final class ColumnLineageDatasetFacetFieldsAdditional {
        private final List<ColumnLineageDatasetFacetFieldsAdditionalInputFields> inputFields;
        private final String transformationDescription;
        private final String transformationType;
        @JsonAnySetter
        private final Map<String, Object> additionalProperties;

        @JsonCreator
        private ColumnLineageDatasetFacetFieldsAdditional(@JsonProperty(value="inputFields") List<ColumnLineageDatasetFacetFieldsAdditionalInputFields> inputFields, @JsonProperty(value="transformationDescription") String transformationDescription, @JsonProperty(value="transformationType") String transformationType) {
            this.inputFields = inputFields;
            this.transformationDescription = transformationDescription;
            this.transformationType = transformationType;
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }

        public List<ColumnLineageDatasetFacetFieldsAdditionalInputFields> getInputFields() {
            return this.inputFields;
        }

        public String getTransformationDescription() {
            return this.transformationDescription;
        }

        public String getTransformationType() {
            return this.transformationType;
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        void withAdditionalProperties() {
        }
    }

    public final class JobEventBuilder
    implements Builder<JobEvent> {
        private ZonedDateTime eventTime;
        private Job job;
        private List<InputDataset> inputs;
        private List<OutputDataset> outputs;

        public JobEventBuilder eventTime(ZonedDateTime eventTime) {
            this.eventTime = eventTime;
            return this;
        }

        public JobEventBuilder job(Job job) {
            this.job = job;
            return this;
        }

        public JobEventBuilder inputs(List<InputDataset> inputs) {
            this.inputs = inputs;
            return this;
        }

        public JobEventBuilder outputs(List<OutputDataset> outputs) {
            this.outputs = outputs;
            return this;
        }

        @Override
        public JobEvent build() {
            JobEvent __result = new JobEvent(this.eventTime, OpenLineage.this.producer, this.job, this.inputs, this.outputs);
            return __result;
        }
    }

    @JsonDeserialize(as=JobEvent.class)
    @JsonPropertyOrder(value={"eventTime", "producer", "schemaURL", "job", "inputs", "outputs"})
    public static final class JobEvent
    implements BaseEvent {
        private final ZonedDateTime eventTime;
        private final URI producer;
        private final URI schemaURL;
        private final Job job;
        private final List<InputDataset> inputs;
        private final List<OutputDataset> outputs;

        @JsonCreator
        private JobEvent(@JsonProperty(value="eventTime") ZonedDateTime eventTime, @JsonProperty(value="producer") URI producer, @JsonProperty(value="job") Job job, @JsonProperty(value="inputs") List<InputDataset> inputs, @JsonProperty(value="outputs") List<OutputDataset> outputs) {
            this.eventTime = eventTime;
            this.producer = producer;
            this.schemaURL = URI.create("https://openlineage.io/spec/2-0-2/OpenLineage.json#/$defs/JobEvent");
            this.job = job;
            this.inputs = inputs;
            this.outputs = outputs;
        }

        @Override
        public ZonedDateTime getEventTime() {
            return this.eventTime;
        }

        @Override
        public URI getProducer() {
            return this.producer;
        }

        @Override
        public URI getSchemaURL() {
            return this.schemaURL;
        }

        public Job getJob() {
            return this.job;
        }

        public List<InputDataset> getInputs() {
            return this.inputs;
        }

        public List<OutputDataset> getOutputs() {
            return this.outputs;
        }
    }

    @JsonDeserialize(as=DefaultInputDatasetFacet.class)
    public static interface InputDatasetFacet {
        public URI get_producer();

        public URI get_schemaURL();

        public Map<String, Object> getAdditionalProperties();
    }

    public static class DefaultInputDatasetFacet
    implements InputDatasetFacet {
        private final URI _producer;
        private final URI _schemaURL;
        @JsonAnySetter
        private final Map<String, Object> additionalProperties;

        @JsonCreator
        public DefaultInputDatasetFacet(@JsonProperty(value="_producer") URI _producer) {
            this._producer = _producer;
            this._schemaURL = URI.create("https://openlineage.io/spec/2-0-2/OpenLineage.json#/$defs/InputDatasetFacet");
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }

        @Override
        public URI get_producer() {
            return this._producer;
        }

        @Override
        public URI get_schemaURL() {
            return this._schemaURL;
        }

        @Override
        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }
    }

    public static final class OwnershipJobFacetOwnersBuilder
    implements Builder<OwnershipJobFacetOwners> {
        private String name;
        private String type;

        public OwnershipJobFacetOwnersBuilder name(String name) {
            this.name = name;
            return this;
        }

        public OwnershipJobFacetOwnersBuilder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public OwnershipJobFacetOwners build() {
            OwnershipJobFacetOwners __result = new OwnershipJobFacetOwners(this.name, this.type);
            return __result;
        }
    }

    @JsonDeserialize(as=OwnershipJobFacetOwners.class)
    @JsonPropertyOrder(value={"name", "type"})
    public static final class OwnershipJobFacetOwners {
        private final String name;
        private final String type;

        @JsonCreator
        private OwnershipJobFacetOwners(@JsonProperty(value="name") String name, @JsonProperty(value="type") String type) {
            this.name = name;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }
    }

    public static interface BaseFacet {
        public URI get_producer();

        public URI get_schemaURL();

        public Map<String, Object> getAdditionalProperties();
    }

    @JsonDeserialize(as=DefaultRunFacet.class)
    public static interface RunFacet {
        public URI get_producer();

        public URI get_schemaURL();

        public Map<String, Object> getAdditionalProperties();
    }

    public static class DefaultRunFacet
    implements RunFacet {
        private final URI _producer;
        private final URI _schemaURL;
        @JsonAnySetter
        private final Map<String, Object> additionalProperties;

        @JsonCreator
        public DefaultRunFacet(@JsonProperty(value="_producer") URI _producer) {
            this._producer = _producer;
            this._schemaURL = URI.create("https://openlineage.io/spec/2-0-2/OpenLineage.json#/$defs/RunFacet");
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }

        @Override
        public URI get_producer() {
            return this._producer;
        }

        @Override
        public URI get_schemaURL() {
            return this._schemaURL;
        }

        @Override
        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }
    }

    public final class NominalTimeRunFacetBuilder
    implements Builder<NominalTimeRunFacet> {
        private ZonedDateTime nominalStartTime;
        private ZonedDateTime nominalEndTime;
        private final Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

        public NominalTimeRunFacetBuilder nominalStartTime(ZonedDateTime nominalStartTime) {
            this.nominalStartTime = nominalStartTime;
            return this;
        }

        public NominalTimeRunFacetBuilder nominalEndTime(ZonedDateTime nominalEndTime) {
            this.nominalEndTime = nominalEndTime;
            return this;
        }

        public NominalTimeRunFacetBuilder put(String key, Object value) {
            this.additionalProperties.put(key, value);
            return this;
        }

        @Override
        public NominalTimeRunFacet build() {
            NominalTimeRunFacet __result = new NominalTimeRunFacet(OpenLineage.this.producer, this.nominalStartTime, this.nominalEndTime);
            __result.getAdditionalProperties().putAll(this.additionalProperties);
            return __result;
        }
    }

    @JsonDeserialize(as=NominalTimeRunFacet.class)
    @JsonPropertyOrder(value={"_producer", "_schemaURL", "nominalStartTime", "nominalEndTime"})
    public static final class NominalTimeRunFacet
    implements RunFacet {
        private final URI _producer;
        private final URI _schemaURL;
        private final ZonedDateTime nominalStartTime;
        private final ZonedDateTime nominalEndTime;
        @JsonAnySetter
        private final Map<String, Object> additionalProperties;

        @JsonCreator
        private NominalTimeRunFacet(@JsonProperty(value="_producer") URI _producer, @JsonProperty(value="nominalStartTime") ZonedDateTime nominalStartTime, @JsonProperty(value="nominalEndTime") ZonedDateTime nominalEndTime) {
            this._producer = _producer;
            this._schemaURL = URI.create("https://openlineage.io/spec/facets/1-0-0/NominalTimeRunFacet.json#/$defs/NominalTimeRunFacet");
            this.nominalStartTime = nominalStartTime;
            this.nominalEndTime = nominalEndTime;
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }

        @Override
        public URI get_producer() {
            return this._producer;
        }

        @Override
        public URI get_schemaURL() {
            return this._schemaURL;
        }

        public ZonedDateTime getNominalStartTime() {
            return this.nominalStartTime;
        }

        public ZonedDateTime getNominalEndTime() {
            return this.nominalEndTime;
        }

        @Override
        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        void withAdditionalProperties() {
        }
    }

    public static final class OutputDatasetOutputFacetsBuilder
    implements Builder<OutputDatasetOutputFacets> {
        private OutputStatisticsOutputDatasetFacet outputStatistics;
        private final Map<String, OutputDatasetFacet> additionalProperties = new LinkedHashMap<String, OutputDatasetFacet>();

        public OutputDatasetOutputFacetsBuilder outputStatistics(OutputStatisticsOutputDatasetFacet outputStatistics) {
            this.outputStatistics = outputStatistics;
            return this;
        }

        public OutputDatasetOutputFacetsBuilder put(String key, OutputDatasetFacet value) {
            this.additionalProperties.put(key, value);
            return this;
        }

        @Override
        public OutputDatasetOutputFacets build() {
            OutputDatasetOutputFacets __result = new OutputDatasetOutputFacets(this.outputStatistics);
            __result.getAdditionalProperties().putAll(this.additionalProperties);
            return __result;
        }
    }

    @JsonDeserialize(as=OutputDatasetOutputFacets.class)
    @JsonPropertyOrder(value={"outputStatistics"})
    public static final class OutputDatasetOutputFacets {
        private final OutputStatisticsOutputDatasetFacet outputStatistics;
        @JsonAnySetter
        private final Map<String, OutputDatasetFacet> additionalProperties;

        @JsonCreator
        private OutputDatasetOutputFacets(@JsonProperty(value="outputStatistics") OutputStatisticsOutputDatasetFacet outputStatistics) {
            this.outputStatistics = outputStatistics;
            this.additionalProperties = new LinkedHashMap<String, OutputDatasetFacet>();
        }

        public OutputStatisticsOutputDatasetFacet getOutputStatistics() {
            return this.outputStatistics;
        }

        @JsonAnyGetter
        public Map<String, OutputDatasetFacet> getAdditionalProperties() {
            return this.additionalProperties;
        }

        void withAdditionalProperties() {
        }
    }

    public final class ExternalQueryRunFacetBuilder
    implements Builder<ExternalQueryRunFacet> {
        private String externalQueryId;
        private String source;
        private final Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

        public ExternalQueryRunFacetBuilder externalQueryId(String externalQueryId) {
            this.externalQueryId = externalQueryId;
            return this;
        }

        public ExternalQueryRunFacetBuilder source(String source) {
            this.source = source;
            return this;
        }

        public ExternalQueryRunFacetBuilder put(String key, Object value) {
            this.additionalProperties.put(key, value);
            return this;
        }

        @Override
        public ExternalQueryRunFacet build() {
            ExternalQueryRunFacet __result = new ExternalQueryRunFacet(OpenLineage.this.producer, this.externalQueryId, this.source);
            __result.getAdditionalProperties().putAll(this.additionalProperties);
            return __result;
        }
    }

    @JsonDeserialize(as=ExternalQueryRunFacet.class)
    @JsonPropertyOrder(value={"_producer", "_schemaURL", "externalQueryId", "source"})
    public static final class ExternalQueryRunFacet
    implements RunFacet {
        private final URI _producer;
        private final URI _schemaURL;
        private final String externalQueryId;
        private final String source;
        @JsonAnySetter
        private final Map<String, Object> additionalProperties;

        @JsonCreator
        private ExternalQueryRunFacet(@JsonProperty(value="_producer") URI _producer, @JsonProperty(value="externalQueryId") String externalQueryId, @JsonProperty(value="source") String source) {
            this._producer = _producer;
            this._schemaURL = URI.create("https://openlineage.io/spec/facets/1-0-0/ExternalQueryRunFacet.json#/$defs/ExternalQueryRunFacet");
            this.externalQueryId = externalQueryId;
            this.source = source;
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }

        @Override
        public URI get_producer() {
            return this._producer;
        }

        @Override
        public URI get_schemaURL() {
            return this._schemaURL;
        }

        public String getExternalQueryId() {
            return this.externalQueryId;
        }

        public String getSource() {
            return this.source;
        }

        @Override
        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        void withAdditionalProperties() {
        }
    }

    public static final class DataQualityMetricsInputDatasetFacetColumnMetricsAdditionalQuantilesBuilder
    implements Builder<DataQualityMetricsInputDatasetFacetColumnMetricsAdditionalQuantiles> {
        private final Map<String, Double> additionalProperties = new LinkedHashMap<String, Double>();

        public DataQualityMetricsInputDatasetFacetColumnMetricsAdditionalQuantilesBuilder put(String key, Double value) {
            this.additionalProperties.put(key, value);
            return this;
        }

        @Override
        public DataQualityMetricsInputDatasetFacetColumnMetricsAdditionalQuantiles build() {
            DataQualityMetricsInputDatasetFacetColumnMetricsAdditionalQuantiles __result = new DataQualityMetricsInputDatasetFacetColumnMetricsAdditionalQuantiles();
            __result.getAdditionalProperties().putAll(this.additionalProperties);
            return __result;
        }
    }

    @JsonDeserialize(as=DataQualityMetricsInputDatasetFacetColumnMetricsAdditionalQuantiles.class)
    @JsonPropertyOrder
    public static final class DataQualityMetricsInputDatasetFacetColumnMetricsAdditionalQuantiles {
        @JsonAnySetter
        private final Map<String, Double> additionalProperties = new LinkedHashMap<String, Double>();

        @JsonCreator
        private DataQualityMetricsInputDatasetFacetColumnMetricsAdditionalQuantiles() {
        }

        @JsonAnyGetter
        public Map<String, Double> getAdditionalProperties() {
            return this.additionalProperties;
        }

        void withAdditionalProperties() {
        }
    }

    public static final class RunBuilder
    implements Builder<Run> {
        private UUID runId;
        private RunFacets facets;

        public RunBuilder runId(UUID runId) {
            this.runId = runId;
            return this;
        }

        public RunBuilder facets(RunFacets facets) {
            this.facets = facets;
            return this;
        }

        @Override
        public Run build() {
            Run __result = new Run(this.runId, this.facets);
            return __result;
        }
    }

    @JsonDeserialize(as=Run.class)
    @JsonPropertyOrder(value={"runId", "facets"})
    public static final class Run {
        private final UUID runId;
        private final RunFacets facets;

        @JsonCreator
        private Run(@JsonProperty(value="runId") UUID runId, @JsonProperty(value="facets") RunFacets facets) {
            this.runId = runId;
            this.facets = facets;
        }

        public UUID getRunId() {
            return this.runId;
        }

        public RunFacets getFacets() {
            return this.facets;
        }
    }

    public static final class ExtractionErrorRunFacetErrorsBuilder
    implements Builder<ExtractionErrorRunFacetErrors> {
        private String errorMessage;
        private String stackTrace;
        private String task;
        private Long taskNumber;

        public ExtractionErrorRunFacetErrorsBuilder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public ExtractionErrorRunFacetErrorsBuilder stackTrace(String stackTrace) {
            this.stackTrace = stackTrace;
            return this;
        }

        public ExtractionErrorRunFacetErrorsBuilder task(String task) {
            this.task = task;
            return this;
        }

        public ExtractionErrorRunFacetErrorsBuilder taskNumber(Long taskNumber) {
            this.taskNumber = taskNumber;
            return this;
        }

        @Override
        public ExtractionErrorRunFacetErrors build() {
            ExtractionErrorRunFacetErrors __result = new ExtractionErrorRunFacetErrors(this.errorMessage, this.stackTrace, this.task, this.taskNumber);
            return __result;
        }
    }

    @JsonDeserialize(as=ExtractionErrorRunFacetErrors.class)
    @JsonPropertyOrder(value={"errorMessage", "stackTrace", "task", "taskNumber"})
    public static final class ExtractionErrorRunFacetErrors {
        private final String errorMessage;
        private final String stackTrace;
        private final String task;
        private final Long taskNumber;

        @JsonCreator
        private ExtractionErrorRunFacetErrors(@JsonProperty(value="errorMessage") String errorMessage, @JsonProperty(value="stackTrace") String stackTrace, @JsonProperty(value="task") String task, @JsonProperty(value="taskNumber") Long taskNumber) {
            this.errorMessage = errorMessage;
            this.stackTrace = stackTrace;
            this.task = task;
            this.taskNumber = taskNumber;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public String getStackTrace() {
            return this.stackTrace;
        }

        public String getTask() {
            return this.task;
        }

        public Long getTaskNumber() {
            return this.taskNumber;
        }
    }

    public final class OutputStatisticsOutputDatasetFacetBuilder
    implements Builder<OutputStatisticsOutputDatasetFacet> {
        private Long rowCount;
        private Long size;
        private final Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

        public OutputStatisticsOutputDatasetFacetBuilder rowCount(Long rowCount) {
            this.rowCount = rowCount;
            return this;
        }

        public OutputStatisticsOutputDatasetFacetBuilder size(Long size) {
            this.size = size;
            return this;
        }

        public OutputStatisticsOutputDatasetFacetBuilder put(String key, Object value) {
            this.additionalProperties.put(key, value);
            return this;
        }

        @Override
        public OutputStatisticsOutputDatasetFacet build() {
            OutputStatisticsOutputDatasetFacet __result = new OutputStatisticsOutputDatasetFacet(OpenLineage.this.producer, this.rowCount, this.size);
            __result.getAdditionalProperties().putAll(this.additionalProperties);
            return __result;
        }
    }

    @JsonDeserialize(as=OutputStatisticsOutputDatasetFacet.class)
    @JsonPropertyOrder(value={"_producer", "_schemaURL", "rowCount", "size"})
    public static final class OutputStatisticsOutputDatasetFacet
    implements OutputDatasetFacet {
        private final URI _producer;
        private final URI _schemaURL;
        private final Long rowCount;
        private final Long size;
        @JsonAnySetter
        private final Map<String, Object> additionalProperties;

        @JsonCreator
        private OutputStatisticsOutputDatasetFacet(@JsonProperty(value="_producer") URI _producer, @JsonProperty(value="rowCount") Long rowCount, @JsonProperty(value="size") Long size) {
            this._producer = _producer;
            this._schemaURL = URI.create("https://openlineage.io/spec/facets/1-0-0/OutputStatisticsOutputDatasetFacet.json#/$defs/OutputStatisticsOutputDatasetFacet");
            this.rowCount = rowCount;
            this.size = size;
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }

        @Override
        public URI get_producer() {
            return this._producer;
        }

        @Override
        public URI get_schemaURL() {
            return this._schemaURL;
        }

        public Long getRowCount() {
            return this.rowCount;
        }

        public Long getSize() {
            return this.size;
        }

        @Override
        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        void withAdditionalProperties() {
        }
    }

    public final class ParentRunFacetBuilder
    implements Builder<ParentRunFacet> {
        private ParentRunFacetRun run;
        private ParentRunFacetJob job;
        private final Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

        public ParentRunFacetBuilder run(ParentRunFacetRun run) {
            this.run = run;
            return this;
        }

        public ParentRunFacetBuilder job(ParentRunFacetJob job) {
            this.job = job;
            return this;
        }

        public ParentRunFacetBuilder put(String key, Object value) {
            this.additionalProperties.put(key, value);
            return this;
        }

        @Override
        public ParentRunFacet build() {
            ParentRunFacet __result = new ParentRunFacet(OpenLineage.this.producer, this.run, this.job);
            __result.getAdditionalProperties().putAll(this.additionalProperties);
            return __result;
        }
    }

    @JsonDeserialize(as=ParentRunFacet.class)
    @JsonPropertyOrder(value={"_producer", "_schemaURL", "run", "job"})
    public static final class ParentRunFacet
    implements RunFacet {
        private final URI _producer;
        private final URI _schemaURL;
        private final ParentRunFacetRun run;
        private final ParentRunFacetJob job;
        @JsonAnySetter
        private final Map<String, Object> additionalProperties;

        @JsonCreator
        private ParentRunFacet(@JsonProperty(value="_producer") URI _producer, @JsonProperty(value="run") ParentRunFacetRun run, @JsonProperty(value="job") ParentRunFacetJob job) {
            this._producer = _producer;
            this._schemaURL = URI.create("https://openlineage.io/spec/facets/1-0-0/ParentRunFacet.json#/$defs/ParentRunFacet");
            this.run = run;
            this.job = job;
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }

        @Override
        public URI get_producer() {
            return this._producer;
        }

        @Override
        public URI get_schemaURL() {
            return this._schemaURL;
        }

        public ParentRunFacetRun getRun() {
            return this.run;
        }

        public ParentRunFacetJob getJob() {
            return this.job;
        }

        @Override
        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        void withAdditionalProperties() {
        }
    }

    public static final class SchemaDatasetFacetFieldsBuilder
    implements Builder<SchemaDatasetFacetFields> {
        private String name;
        private String type;
        private String description;

        public SchemaDatasetFacetFieldsBuilder name(String name) {
            this.name = name;
            return this;
        }

        public SchemaDatasetFacetFieldsBuilder type(String type) {
            this.type = type;
            return this;
        }

        public SchemaDatasetFacetFieldsBuilder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public SchemaDatasetFacetFields build() {
            SchemaDatasetFacetFields __result = new SchemaDatasetFacetFields(this.name, this.type, this.description);
            return __result;
        }
    }

    @JsonDeserialize(as=SchemaDatasetFacetFields.class)
    @JsonPropertyOrder(value={"name", "type", "description"})
    public static final class SchemaDatasetFacetFields {
        private final String name;
        private final String type;
        private final String description;

        @JsonCreator
        private SchemaDatasetFacetFields(@JsonProperty(value="name") String name, @JsonProperty(value="type") String type, @JsonProperty(value="description") String description) {
            this.name = name;
            this.type = type;
            this.description = description;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public String getDescription() {
            return this.description;
        }
    }

    public static interface BaseEvent {
        public ZonedDateTime getEventTime();

        public URI getProducer();

        public URI getSchemaURL();
    }

    public final class RunEventBuilder
    implements Builder<RunEvent> {
        private ZonedDateTime eventTime;
        private RunEvent.EventType eventType;
        private Run run;
        private Job job;
        private List<InputDataset> inputs;
        private List<OutputDataset> outputs;

        public RunEventBuilder eventTime(ZonedDateTime eventTime) {
            this.eventTime = eventTime;
            return this;
        }

        public RunEventBuilder eventType(RunEvent.EventType eventType) {
            this.eventType = eventType;
            return this;
        }

        public RunEventBuilder run(Run run) {
            this.run = run;
            return this;
        }

        public RunEventBuilder job(Job job) {
            this.job = job;
            return this;
        }

        public RunEventBuilder inputs(List<InputDataset> inputs) {
            this.inputs = inputs;
            return this;
        }

        public RunEventBuilder outputs(List<OutputDataset> outputs) {
            this.outputs = outputs;
            return this;
        }

        @Override
        public RunEvent build() {
            RunEvent __result = new RunEvent(this.eventTime, OpenLineage.this.producer, this.eventType, this.run, this.job, this.inputs, this.outputs);
            return __result;
        }
    }

    @JsonDeserialize(as=RunEvent.class)
    @JsonPropertyOrder(value={"eventTime", "producer", "schemaURL", "eventType", "run", "job", "inputs", "outputs"})
    public static final class RunEvent
    implements BaseEvent {
        private final ZonedDateTime eventTime;
        private final URI producer;
        private final URI schemaURL;
        private final EventType eventType;
        private final Run run;
        private final Job job;
        private final List<InputDataset> inputs;
        private final List<OutputDataset> outputs;

        @JsonCreator
        private RunEvent(@JsonProperty(value="eventTime") ZonedDateTime eventTime, @JsonProperty(value="producer") URI producer, @JsonProperty(value="eventType") EventType eventType, @JsonProperty(value="run") Run run, @JsonProperty(value="job") Job job, @JsonProperty(value="inputs") List<InputDataset> inputs, @JsonProperty(value="outputs") List<OutputDataset> outputs) {
            this.eventTime = eventTime;
            this.producer = producer;
            this.schemaURL = URI.create("https://openlineage.io/spec/2-0-2/OpenLineage.json#/$defs/RunEvent");
            this.eventType = eventType;
            this.run = run;
            this.job = job;
            this.inputs = inputs;
            this.outputs = outputs;
        }

        @Override
        public ZonedDateTime getEventTime() {
            return this.eventTime;
        }

        @Override
        public URI getProducer() {
            return this.producer;
        }

        @Override
        public URI getSchemaURL() {
            return this.schemaURL;
        }

        public EventType getEventType() {
            return this.eventType;
        }

        public Run getRun() {
            return this.run;
        }

        public Job getJob() {
            return this.job;
        }

        public List<InputDataset> getInputs() {
            return this.inputs;
        }

        public List<OutputDataset> getOutputs() {
            return this.outputs;
        }

        public static enum EventType {
            START,
            RUNNING,
            COMPLETE,
            ABORT,
            FAIL,
            OTHER;

        }
    }

    public static interface Builder<T> {
        public T build();
    }
}

