/*
 * Decompiled with CFR 0.152.
 */
package io.nflow.rest.v1.msg;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.nflow.engine.model.ModelObject;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.HashMap;
import java.util.Map;
import org.joda.time.DateTime;

@Schema(description="Request for submitting a new workflow instance. Note that if externalId is given, type and externalId pair must be unique hence enabling retry-safety.")
@SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"}, justification="jackson reads dto fields")
public class CreateWorkflowInstanceRequest
extends ModelObject {
    @Schema(description="Workflow definition type", required=true, nullable=false, minLength=1, maxLength=30)
    public String type;
    @Schema(description="Main business key or identifier for the new workflow instance", maxLength=64)
    public String businessKey;
    @Schema(description="Start state name (if other than default set in workflow definition)", minLength=1, maxLength=64)
    public String startState;
    @Schema(description="Unique external identifier within the workflow type. Generated by nFlow if not given.", nullable=true, maxLength=64)
    public String externalId;
    @Schema(description="Start time for workflow execution. If null, defaults to now, unless activate is set to false, in which case activationTime is ignored.", nullable=true)
    public DateTime activationTime;
    @Schema(description="Set to false to force activationTime to null. Default is true.", defaultValue="true")
    public Boolean activate;
    @Schema(description="Create the workflow as a child of the given parent workflow.")
    public Long parentWorkflowId;
    @Schema(description="State variables to be set for the new workflow instance.")
    public Map<String, Object> stateVariables = new HashMap<String, Object>();
}

