/*
 * Decompiled with CFR 0.152.
 */
package io.nflow.rest.v1;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.nflow.engine.internal.dao.WorkflowDefinitionDao;
import io.nflow.engine.internal.dao.WorkflowInstanceDao;
import io.nflow.engine.internal.workflow.StoredWorkflowDefinition;
import io.nflow.engine.service.NflowNotFoundException;
import io.nflow.engine.service.WorkflowDefinitionService;
import io.nflow.engine.service.WorkflowInstanceService;
import io.nflow.engine.workflow.definition.WorkflowDefinition;
import io.nflow.engine.workflow.instance.QueryWorkflowInstances;
import io.nflow.engine.workflow.instance.WorkflowInstance;
import io.nflow.engine.workflow.instance.WorkflowInstanceAction;
import io.nflow.engine.workflow.instance.WorkflowInstanceFactory;
import io.nflow.rest.v1.ApiWorkflowInstanceInclude;
import io.nflow.rest.v1.converter.ListWorkflowDefinitionConverter;
import io.nflow.rest.v1.converter.ListWorkflowInstanceConverter;
import io.nflow.rest.v1.msg.ErrorResponse;
import io.nflow.rest.v1.msg.ListWorkflowDefinitionResponse;
import io.nflow.rest.v1.msg.ListWorkflowInstanceResponse;
import io.nflow.rest.v1.msg.UpdateWorkflowInstanceRequest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.joda.time.DateTime;
import org.springframework.util.StringUtils;

public abstract class ResourceBase {
    protected static final String INCLUDES_PARAM_DESC = "Data to include for workflow instance.\n* currentStateVariables: current stateVariables for worfklow\n* actions: state transitions\n* actionStateVariables: state variable changes for actions\n* childWorkflows: map of created child workflow instance IDs by action ID\n";
    protected static final String DEPRECATED_INCLUDE_PARAM_DESC = "Removed in the next major release, use `includes` instead. Data to include in workflow instance. Multiple values can be provided as comma separated string.\n* currentStateVariables: current stateVariables for worfklow\n* actions: state transitions\n* actionStateVariables: state variable changes for actions\n* childWorkflows: map of created child workflow instance IDs by action ID\n";
    protected static final String QUERY_ARCHIVED_DEFAULT_STR = "false";
    protected static final boolean QUERY_ARCHIVED_DEFAULT = Boolean.parseBoolean("false");

    public List<ListWorkflowDefinitionResponse> listWorkflowDefinitions(Collection<String> types, WorkflowDefinitionService workflowDefinitions, ListWorkflowDefinitionConverter converter, WorkflowDefinitionDao workflowDefinitionDao) {
        List definitions = workflowDefinitions.getWorkflowDefinitions();
        HashSet<String> reqTypes = new HashSet<String>(types);
        HashSet<String> foundTypes = new HashSet<String>();
        ArrayList<ListWorkflowDefinitionResponse> response = new ArrayList<ListWorkflowDefinitionResponse>();
        for (WorkflowDefinition definition : definitions) {
            if (!reqTypes.isEmpty() && !reqTypes.contains(definition.getType())) continue;
            foundTypes.add(definition.getType());
            response.add(converter.convert(definition));
        }
        if (reqTypes.isEmpty() || foundTypes.size() < reqTypes.size()) {
            reqTypes.removeAll(foundTypes);
            List storedDefinitions = workflowDefinitionDao.queryStoredWorkflowDefinitions(reqTypes);
            for (StoredWorkflowDefinition storedDefinition : storedDefinitions) {
                if (foundTypes.contains(storedDefinition.type)) continue;
                response.add(converter.convert(storedDefinition));
            }
        }
        Collections.sort(response);
        return response;
    }

    public boolean updateWorkflowInstance(long id, UpdateWorkflowInstanceRequest req, WorkflowInstanceFactory workflowInstanceFactory, WorkflowInstanceService workflowInstances, WorkflowInstanceDao workflowInstanceDao) {
        WorkflowInstance.Builder builder = workflowInstanceFactory.newWorkflowInstanceBuilder().setId(id).setNextActivation(req.nextActivationTime);
        Object msg = (String)org.apache.commons.lang3.StringUtils.defaultIfBlank((CharSequence)req.actionDescription, (CharSequence)"");
        if (StringUtils.hasText((String)req.state)) {
            builder.setState(req.state);
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)req.actionDescription)) {
                msg = "API changed state to " + req.state + ". ";
            }
        }
        if (req.nextActivationTime != null && org.apache.commons.lang3.StringUtils.isBlank((CharSequence)req.actionDescription)) {
            msg = (String)msg + "API changed nextActivationTime to " + req.nextActivationTime + ". ";
        }
        if (!req.stateVariables.isEmpty()) {
            for (Map.Entry<String, Object> entry : req.stateVariables.entrySet()) {
                Object value = entry.getValue();
                if (value instanceof String) {
                    builder.putStateVariable(entry.getKey(), (String)value);
                    continue;
                }
                builder.putStateVariable(entry.getKey(), value);
            }
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)req.actionDescription)) {
                msg = (String)msg + "API updated state variables. ";
            }
        }
        if (StringUtils.hasText((String)req.businessKey)) {
            builder.setBusinessKey(req.businessKey);
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)req.actionDescription)) {
                msg = "API changed business key to " + req.businessKey + ". ";
            }
        }
        if (((String)msg).isEmpty()) {
            return true;
        }
        WorkflowInstance instance = builder.setStateText((String)msg).build();
        instance.getChangedStateVariables().forEach((arg_0, arg_1) -> ((WorkflowInstanceDao)workflowInstanceDao).checkStateVariableValueLength(arg_0, arg_1));
        WorkflowInstanceAction action = new WorkflowInstanceAction.Builder(instance).setType(WorkflowInstanceAction.WorkflowActionType.externalChange).setStateText(org.apache.commons.lang3.StringUtils.trimToNull((String)msg)).setExecutionEnd(DateTime.now()).build();
        return workflowInstances.updateWorkflowInstance(instance, action);
    }

    public Stream<ListWorkflowInstanceResponse> listWorkflowInstances(Set<Long> ids, Set<String> types, Long parentWorkflowId, Long parentActionId, Set<String> states, Set<WorkflowInstance.WorkflowInstanceStatus> statuses, String businessKey, String externalId, String stateVariableKey, String stateVariableValue, Set<ApiWorkflowInstanceInclude> includes, String include, Long maxResults, Long maxActions, boolean queryArchive, WorkflowInstanceService workflowInstances, ListWorkflowInstanceConverter listWorkflowConverter) {
        Set<ApiWorkflowInstanceInclude> propertyIncludes = this.resolveIncludes(includes, include);
        QueryWorkflowInstances q = new QueryWorkflowInstances.Builder().addIds(ids.toArray(new Long[ids.size()])).addTypes(types.toArray(new String[types.size()])).setParentWorkflowId(parentWorkflowId).setParentActionId(parentActionId).addStates(states.toArray(new String[states.size()])).addStatuses(statuses.toArray(new WorkflowInstance.WorkflowInstanceStatus[statuses.size()])).setBusinessKey(businessKey).setExternalId(externalId).setIncludeCurrentStateVariables(propertyIncludes.contains((Object)ApiWorkflowInstanceInclude.currentStateVariables)).setIncludeActions(propertyIncludes.contains((Object)ApiWorkflowInstanceInclude.actions)).setIncludeActionStateVariables(propertyIncludes.contains((Object)ApiWorkflowInstanceInclude.actionStateVariables)).setMaxResults(maxResults).setMaxActions(maxActions).setQueryArchive(queryArchive).setIncludeChildWorkflows(propertyIncludes.contains((Object)ApiWorkflowInstanceInclude.childWorkflows)).setStateVariable(stateVariableKey, stateVariableValue).build();
        Stream instances = workflowInstances.listWorkflowInstancesAsStream(q);
        return instances.map(instance -> listWorkflowConverter.convert((WorkflowInstance)instance, propertyIncludes, queryArchive));
    }

    private Set<ApiWorkflowInstanceInclude> resolveIncludes(Set<ApiWorkflowInstanceInclude> includes, String include) {
        EnumSet<ApiWorkflowInstanceInclude> allIncludes = EnumSet.noneOf(ApiWorkflowInstanceInclude.class);
        if (includes != null) {
            allIncludes.addAll(includes);
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)include)) {
            Arrays.stream(include.split(",")).map(ApiWorkflowInstanceInclude::fromValue).filter(Objects::nonNull).forEach(allIncludes::add);
        }
        return allIncludes;
    }

    public ListWorkflowInstanceResponse fetchWorkflowInstance(long id, Set<ApiWorkflowInstanceInclude> apiIncludes, String include, Long maxActions, boolean queryArchive, WorkflowInstanceService workflowInstances, ListWorkflowInstanceConverter listWorkflowConverter) {
        Set<ApiWorkflowInstanceInclude> propertyIncludes = this.resolveIncludes(apiIncludes, include);
        Set includes = propertyIncludes.stream().map(ApiWorkflowInstanceInclude::getInclude).collect(Collectors.toSet());
        WorkflowInstance instance = workflowInstances.getWorkflowInstance(id, includes, maxActions, queryArchive);
        return listWorkflowConverter.convert(instance, propertyIncludes, queryArchive);
    }

    @SuppressFBWarnings(value={"ITC_INHERITANCE_TYPE_CHECKING"}, justification="This is the way")
    protected int resolveExceptionHttpStatus(Throwable t) {
        if (t instanceof IllegalArgumentException) {
            return 400;
        }
        if (t instanceof NflowNotFoundException) {
            return 404;
        }
        return 500;
    }

    protected <T> T handleExceptions(Supplier<T> response, BiFunction<Integer, ErrorResponse, T> error) {
        try {
            return response.get();
        }
        catch (Throwable t) {
            int code = this.resolveExceptionHttpStatus(t);
            return error.apply(code, new ErrorResponse(t.getMessage()));
        }
    }
}

