/*
 * Decompiled with CFR 0.152.
 */
package io.mongock.driver.mongodb.v3.repository;

import com.mongodb.client.ClientSession;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.ReplaceOptions;
import com.mongodb.client.result.UpdateResult;
import io.mongock.api.exception.MongockException;
import io.mongock.driver.api.entry.ChangeEntry;
import io.mongock.driver.api.entry.ChangeState;
import io.mongock.driver.api.entry.ChangeType;
import io.mongock.driver.core.entry.ChangeEntryRepositoryWithEntity;
import io.mongock.driver.mongodb.v3.repository.Mongo3RepositoryBase;
import io.mongock.driver.mongodb.v3.repository.ReadWriteConfiguration;
import io.mongock.utils.DateUtils;
import io.mongock.utils.field.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Mongo3ChangeEntryRepository
extends Mongo3RepositoryBase<ChangeEntry>
implements ChangeEntryRepositoryWithEntity<Document> {
    private static final Logger logger = LoggerFactory.getLogger(Mongo3ChangeEntryRepository.class);
    protected static String KEY_EXECUTION_ID;
    protected static String KEY_CHANGE_ID;
    protected static String KEY_STATE;
    protected static String KEY_TYPE;
    protected static String KEY_AUTHOR;
    protected static String KEY_TIMESTAMP;
    protected static String KEY_CHANGELOG_CLASS;
    protected static String KEY_CHANGESET_METHOD;
    protected static String KEY_EXECUTION_MILLIS;
    protected static String KEY_EXECUTION_HOSTNAME;
    protected static String KEY_METADATA;
    protected static String KEY_SYSTEM_CHANGE;
    private ClientSession clientSession;

    public Mongo3ChangeEntryRepository(MongoCollection<Document> collection) {
        this(collection, ReadWriteConfiguration.getDefault());
    }

    public Mongo3ChangeEntryRepository(MongoCollection<Document> collection, ReadWriteConfiguration readWriteConfiguration) {
        super(collection, new String[]{KEY_EXECUTION_ID, KEY_AUTHOR, KEY_CHANGE_ID}, readWriteConfiguration);
    }

    public List<ChangeEntry> getEntriesLog() {
        return ((ArrayList)this.collection.find().into(new ArrayList())).stream().map(entry -> new ChangeEntry(entry.getString((Object)KEY_EXECUTION_ID), entry.getString((Object)KEY_CHANGE_ID), entry.getString((Object)KEY_AUTHOR), DateUtils.toDate((Object)entry.get((Object)KEY_TIMESTAMP)), entry.containsKey((Object)KEY_STATE) ? ChangeState.valueOf((String)entry.getString((Object)KEY_STATE)) : null, entry.containsKey((Object)KEY_TYPE) ? ChangeType.valueOf((String)entry.getString((Object)KEY_TYPE)) : null, entry.getString((Object)KEY_CHANGELOG_CLASS), entry.getString((Object)KEY_CHANGESET_METHOD), entry.containsKey((Object)KEY_EXECUTION_MILLIS) && entry.get((Object)KEY_EXECUTION_MILLIS) != null ? ((Number)entry.get((Object)KEY_EXECUTION_MILLIS)).longValue() : -1L, entry.getString((Object)KEY_EXECUTION_HOSTNAME), entry.get((Object)KEY_METADATA), entry.getBoolean((Object)KEY_SYSTEM_CHANGE))).collect(Collectors.toList());
    }

    public void setClientSession(ClientSession clientSession) {
        this.clientSession = clientSession;
    }

    public void clearClientSession() {
        this.setClientSession(null);
    }

    private Optional<ClientSession> getClientSession() {
        return Optional.ofNullable(this.clientSession);
    }

    public void saveOrUpdate(ChangeEntry changeEntry) throws MongockException {
        Bson filter = Filters.and((Bson[])new Bson[]{Filters.eq((String)KEY_EXECUTION_ID, (Object)changeEntry.getExecutionId()), Filters.eq((String)KEY_CHANGE_ID, (Object)changeEntry.getChangeId()), Filters.eq((String)KEY_AUTHOR, (Object)changeEntry.getAuthor())});
        Document entryDocument = this.toEntity(changeEntry);
        UpdateResult result = this.getClientSession().map(clientSession -> this.collection.replaceOne(clientSession, filter, (Object)entryDocument, new ReplaceOptions().upsert(true))).orElseGet(() -> this.collection.replaceOne(filter, (Object)entryDocument, new ReplaceOptions().upsert(true)));
        logger.debug("SaveOrUpdate[{}] with result\n[upsertId:{}, matches: {}, modifies: {}, acknowledged: {}]", new Object[]{changeEntry, result.getUpsertedId(), result.getMatchedCount(), result.getModifiedCount(), result.wasAcknowledged()});
    }

    public void ensureField(java.lang.reflect.Field field) {
    }

    public Document toEntity(ChangeEntry domain) {
        return new Document().append(KEY_EXECUTION_ID, (Object)domain.getExecutionId()).append(KEY_CHANGE_ID, (Object)domain.getChangeId()).append(KEY_AUTHOR, (Object)domain.getAuthor()).append(KEY_TIMESTAMP, (Object)domain.getTimestamp()).append(KEY_STATE, (Object)domain.getState().toString()).append(KEY_TYPE, (Object)domain.getType().toString()).append(KEY_CHANGELOG_CLASS, (Object)domain.getChangeLogClass()).append(KEY_CHANGESET_METHOD, (Object)domain.getChangeSetMethod()).append(KEY_METADATA, domain.getMetadata()).append(KEY_EXECUTION_MILLIS, (Object)domain.getExecutionMillis()).append("executionHostname", (Object)domain.getExecutionHostname()).append("errorTrace", domain.getErrorTrace().orElse(null)).append(KEY_SYSTEM_CHANGE, (Object)domain.isSystemChange());
    }

    static {
        try {
            java.lang.reflect.Field field = ChangeEntry.class.getDeclaredField("executionId");
            field.setAccessible(true);
            KEY_EXECUTION_ID = field.getAnnotation(Field.class).value();
            field = ChangeEntry.class.getDeclaredField("changeId");
            field.setAccessible(true);
            KEY_CHANGE_ID = field.getAnnotation(Field.class).value();
            field = ChangeEntry.class.getDeclaredField("state");
            field.setAccessible(true);
            KEY_STATE = field.getAnnotation(Field.class).value();
            field = ChangeEntry.class.getDeclaredField("type");
            field.setAccessible(true);
            KEY_TYPE = field.getAnnotation(Field.class).value();
            field = ChangeEntry.class.getDeclaredField("author");
            field.setAccessible(true);
            KEY_AUTHOR = field.getAnnotation(Field.class).value();
            field = ChangeEntry.class.getDeclaredField("timestamp");
            field.setAccessible(true);
            KEY_TIMESTAMP = field.getAnnotation(Field.class).value();
            field = ChangeEntry.class.getDeclaredField("changeLogClass");
            field.setAccessible(true);
            KEY_CHANGELOG_CLASS = field.getAnnotation(Field.class).value();
            field = ChangeEntry.class.getDeclaredField("changeSetMethod");
            field.setAccessible(true);
            KEY_CHANGESET_METHOD = field.getAnnotation(Field.class).value();
            field = ChangeEntry.class.getDeclaredField("metadata");
            field.setAccessible(true);
            KEY_METADATA = field.getAnnotation(Field.class).value();
            field = ChangeEntry.class.getDeclaredField("executionMillis");
            field.setAccessible(true);
            KEY_EXECUTION_MILLIS = field.getAnnotation(Field.class).value();
            field = ChangeEntry.class.getDeclaredField("executionHostname");
            field.setAccessible(true);
            KEY_EXECUTION_HOSTNAME = field.getAnnotation(Field.class).value();
            field = ChangeEntry.class.getDeclaredField("systemChange");
            field.setAccessible(true);
            KEY_SYSTEM_CHANGE = field.getAnnotation(Field.class).value();
        }
        catch (NoSuchFieldException e) {
            throw new MongockException((Throwable)e);
        }
    }
}

