/*
 * Decompiled with CFR 0.152.
 */
package io.moderne.serialization;

import java.io.OutputStream;
import net.jpountz.lz4.LZ4FrameOutputStream;
import org.apache.commons.compress.compressors.xz.XZCompressorOutputStream;
import org.apache.commons.compress.compressors.zstandard.ZstdCompressorOutputStream;

public enum CompressionAlgorithm {
    XZ,
    ZSTD,
    LZ4;

    public static final CompressionAlgorithm[] DEFAULT;

    public static OutputStream compressor(CompressionAlgorithm[] compressionAlgorithmArray, OutputStream outputStream) {
        if (compressionAlgorithmArray.length == 0) {
            compressionAlgorithmArray = DEFAULT;
        }
        for (int i2 = 0; i2 < compressionAlgorithmArray.length; ++i2) {
            CompressionAlgorithm compressionAlgorithm = compressionAlgorithmArray[i2];
            try {
                switch (compressionAlgorithm) {
                    case XZ: {
                        return new XZCompressorOutputStream(outputStream, 3);
                    }
                    case ZSTD: {
                        return new ZstdCompressorOutputStream(outputStream, 3);
                    }
                }
                return new LZ4FrameOutputStream(outputStream);
            }
            catch (Throwable throwable) {
                if (i2 != compressionAlgorithmArray.length - 1) continue;
                throw throwable;
            }
        }
        throw new RuntimeException("Should never get here.");
    }

    static {
        DEFAULT = new CompressionAlgorithm[]{ZSTD, XZ};
    }
}

