/*
 * Decompiled with CFR 0.152.
 */
package com.github.luben.zstd;

import com.github.luben.zstd.SharedDictBase;
import com.github.luben.zstd.Zstd;
import com.github.luben.zstd.util.Native;
import java.nio.ByteBuffer;

public class ZstdDictCompress
extends SharedDictBase {
    private long nativePtr = 0L;
    private int level = Zstd.defaultCompressionLevel();

    private native void init(byte[] var1, int var2, int var3, int var4);

    private native void initDirect(ByteBuffer var1, int var2, int var3, int var4);

    private native void free();

    public ZstdDictCompress(byte[] byArray, int n2) {
        this(byArray, 0, byArray.length, n2);
    }

    public ZstdDictCompress(byte[] byArray, int n2, int n3, int n4) {
        this.level = n4;
        if (byArray.length - n2 < 0) {
            throw new IllegalArgumentException("Dictionary buffer is to short");
        }
        this.init(byArray, n2, n3, n4);
        if (0L == this.nativePtr) {
            throw new IllegalStateException("ZSTD_createCDict failed");
        }
        this.storeFence();
    }

    public ZstdDictCompress(ByteBuffer byteBuffer, int n2) {
        this.level = n2;
        int n3 = byteBuffer.limit() - byteBuffer.position();
        if (!byteBuffer.isDirect()) {
            throw new IllegalArgumentException("dict must be a direct buffer");
        }
        if (n3 < 0) {
            throw new IllegalArgumentException("dict cannot be empty.");
        }
        this.initDirect(byteBuffer, byteBuffer.position(), n3, n2);
        if (this.nativePtr == 0L) {
            throw new IllegalStateException("ZSTD_createCDict failed");
        }
        this.storeFence();
    }

    int level() {
        return this.level;
    }

    @Override
    void doClose() {
        if (this.nativePtr != 0L) {
            this.free();
            this.nativePtr = 0L;
        }
    }

    static {
        Native.load();
    }
}

