/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.response;

import io.milvus.grpc.DescribeIndexResponse;
import io.milvus.grpc.IndexDescription;
import io.milvus.param.IndexType;
import io.milvus.param.MetricType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import lombok.NonNull;

public class DescIndexResponseWrapper {
    private final DescribeIndexResponse response;

    public DescIndexResponseWrapper(@NonNull DescribeIndexResponse response) {
        if (response == null) {
            throw new NullPointerException("response is marked non-null but is null");
        }
        this.response = response;
    }

    public List<IndexDesc> getIndexDescriptions() {
        ArrayList<IndexDesc> results = new ArrayList<IndexDesc>();
        List<IndexDescription> descriptions = this.response.getIndexDescriptionsList();
        descriptions.forEach(desc -> {
            IndexDesc res = new IndexDesc(desc.getFieldName(), desc.getIndexName(), desc.getIndexID());
            desc.getParamsList().forEach(kv -> res.addParam(kv.getKey(), kv.getValue()));
            results.add(res);
        });
        return results;
    }

    public IndexDesc getIndexDescByFieldName(@NonNull String fieldName) {
        if (fieldName == null) {
            throw new NullPointerException("fieldName is marked non-null but is null");
        }
        for (int i = 0; i < this.response.getIndexDescriptionsCount(); ++i) {
            IndexDescription desc = this.response.getIndexDescriptions(i);
            if (fieldName.compareTo(desc.getFieldName()) != 0) continue;
            IndexDesc res = new IndexDesc(desc.getFieldName(), desc.getIndexName(), desc.getIndexID());
            desc.getParamsList().forEach(kv -> res.addParam(kv.getKey(), kv.getValue()));
            return res;
        }
        return null;
    }

    public String toString() {
        return "Index description{" + this.getIndexDescriptions().toString() + '}';
    }

    public static final class IndexDesc {
        private final String fieldName;
        private final String indexName;
        private final long id;
        private final Map<String, String> params = new HashMap<String, String>();

        public IndexDesc(@NonNull String fieldName, @NonNull String indexName, long id) {
            if (fieldName == null) {
                throw new NullPointerException("fieldName is marked non-null but is null");
            }
            if (indexName == null) {
                throw new NullPointerException("indexName is marked non-null but is null");
            }
            this.fieldName = fieldName;
            this.indexName = indexName;
            this.id = id;
        }

        public void addParam(@NonNull String key, @NonNull String value) {
            if (key == null) {
                throw new NullPointerException("key is marked non-null but is null");
            }
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
            this.params.put(key, value);
        }

        public IndexType getIndexType() {
            if (this.params.containsKey("index_type")) {
                return IndexType.valueOf(this.params.get("index_type").toUpperCase(Locale.ROOT));
            }
            return IndexType.INVALID;
        }

        public MetricType getMetricType() {
            if (this.params.containsKey("metric_type")) {
                return MetricType.valueOf(this.params.get("metric_type"));
            }
            return MetricType.INVALID;
        }

        public String getExtraParam() {
            if (this.params.containsKey("params")) {
                return this.params.get("params");
            }
            return "";
        }

        public String toString() {
            return "IndexDesc(fieldName: " + this.getFieldName() + " indexName: " + this.getIndexName() + " id: " + this.getId() + " indexType: " + this.getIndexType().name() + " metricType: " + this.getMetricType().name() + " extraParam: " + this.getExtraParam() + ")";
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public String getIndexName() {
            return this.indexName;
        }

        public long getId() {
            return this.id;
        }

        public Map<String, String> getParams() {
            return this.params;
        }
    }
}

