/*
 * Decompiled with CFR 0.152.
 */
package io.milton.mail.pop;

import io.milton.mail.Mailbox;
import io.milton.mail.MailboxAddress;
import io.milton.mail.pop.BaseState;
import io.milton.mail.pop.PopSession;
import io.milton.mail.pop.TransactionState;
import java.io.UnsupportedEncodingException;
import org.apache.mina.core.session.IoSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthState
extends BaseState {
    private static final Logger log = LoggerFactory.getLogger(AuthState.class);
    String user;
    String pass;
    Mailbox mbox;

    public AuthState(PopSession popSession) {
        super(popSession);
    }

    @Override
    public void enter(IoSession session, PopSession popSession) {
        log.debug("now in authstate");
    }

    @Override
    public void exit(IoSession session, PopSession popSession) {
    }

    @Override
    public void capa(IoSession session, PopSession popSession, String[] args) {
        log.info("capa:");
        popSession.reply(session, "+OK Capability list follows");
        popSession.reply(session, "USER");
        popSession.reply(session, ".");
    }

    public void user(IoSession session, PopSession popSession, String[] args) {
        this.user = args[1];
        log.debug("user: " + this.user);
        try {
            MailboxAddress add = MailboxAddress.parse((String)this.user);
            this.mbox = popSession.resourceFactory.getMailbox(add);
            if (this.mbox != null) {
                popSession.reply(session, "+OK");
            } else {
                log.debug("mailbox not found: " + add);
                popSession.reply(session, "-ERR");
            }
        }
        catch (IllegalArgumentException ex) {
            popSession.reply(session, "-ERR Could not parse user name. Use form: user@domain.com");
        }
    }

    public void pass(IoSession session, PopSession popSession, String[] args) {
        this.pass = args.length > 1 ? args[1] : "";
        log.debug("pass: " + this.pass);
        if (this.mbox == null) {
            log.debug("no current mailbox");
            popSession.reply(session, "-ERR");
        } else if (this.mbox.authenticate(this.pass)) {
            popSession.reply(session, "+OK Mailbox locked and ready SESSIONID=<slot111-3708-1233538479-1>");
            popSession.auth = this;
            popSession.transitionTo(session, new TransactionState(popSession));
        } else {
            log.debug("authentication failed");
            popSession.reply(session, "-ERR");
            popSession.auth = null;
        }
    }

    public void apop(IoSession session, PopSession popSession, String[] args) {
        this.user = args[1];
        log.debug("apop: " + this.user);
        try {
            MailboxAddress add = MailboxAddress.parse((String)this.user);
            this.mbox = popSession.resourceFactory.getMailbox(add);
            if (this.mbox != null) {
                String md5Pass = args[2];
                if (this.mbox.authenticateMD5(md5Pass.getBytes("UTF-8"))) {
                    popSession.reply(session, "+OK");
                    popSession.auth = this;
                    popSession.transitionTo(session, new TransactionState(popSession));
                } else {
                    popSession.reply(session, "-ERR authentication failed");
                }
            } else {
                popSession.reply(session, "-ERR mailbox not found");
            }
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        catch (IllegalArgumentException ex) {
            popSession.reply(session, "-ERR Could not parse user name. Use form: user@domain.com");
        }
    }

    public void auth(IoSession session, PopSession popSession, String[] args) {
        popSession.reply(session, "-ERR not supported");
    }
}

