/*
 * Decompiled with CFR 0.152.
 */
package io.milton.mail.memory;

import io.milton.mail.Mailbox;
import io.milton.mail.MessageFolder;
import io.milton.mail.StandardMessageFactory;
import io.milton.mail.StandardMessageFactoryImpl;
import io.milton.mail.memory.MemoryMessageFolder;
import io.milton.mail.memory.MemoryMessageResource;
import java.util.HashMap;
import java.util.Map;
import javax.mail.internet.MimeMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryMailBox
implements Mailbox {
    private static final Logger log = LoggerFactory.getLogger(MemoryMailBox.class);
    private static final StandardMessageFactory factory = new StandardMessageFactoryImpl();
    final String password;
    final Map<String, MessageFolder> folders = new HashMap<String, MessageFolder>();

    public MemoryMailBox() {
        MemoryMessageFolder folder = this.addFolder("inbox");
        this.password = "password";
    }

    public boolean authenticate(String password) {
        return password.equals(this.password);
    }

    public boolean authenticateMD5(byte[] passwordHash) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public MessageFolder getInbox() {
        return this.folders.get("inbox");
    }

    public MessageFolder getMailFolder(String name) {
        return this.folders.get(name);
    }

    public boolean isEmailDisabled() {
        return false;
    }

    public void storeMail(MimeMessage mm) {
        MemoryMessageFolder folder = (MemoryMessageFolder)this.getInbox();
        MemoryMessageResource res = new MemoryMessageResource(folder, mm, factory);
        folder.messages.add(res);
    }

    public MemoryMessageFolder addFolder(String name) {
        MemoryMessageFolder folder = new MemoryMessageFolder();
        this.folders.put(name, folder);
        return folder;
    }
}

