/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.bson.custom;

import io.micronaut.context.annotation.Factory;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Order;
import io.micronaut.serde.bson.custom.CodecBsonDecoder;
import jakarta.inject.Singleton;
import java.util.Optional;
import org.bson.BsonBinary;
import org.bson.BsonDbPointer;
import org.bson.BsonDocument;
import org.bson.BsonRegularExpression;
import org.bson.BsonTimestamp;
import org.bson.codecs.BsonBinaryCodec;
import org.bson.codecs.BsonDBPointerCodec;
import org.bson.codecs.BsonDocumentCodec;
import org.bson.codecs.BsonRegularExpressionCodec;
import org.bson.codecs.BsonTimestampCodec;
import org.bson.codecs.Codec;
import org.bson.codecs.Decimal128Codec;
import org.bson.codecs.ObjectIdCodec;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.types.Decimal128;
import org.bson.types.ObjectId;

@Factory
@Internal
final class CustomBsonSerdes {
    CustomBsonSerdes() {
    }

    @Singleton
    @NonNull
    @Order(value=10000)
    CodecBsonDecoder<BsonDocument> bsonDecoder(Optional<CodecRegistry> codecRegistry) {
        return codecRegistry.map(registry -> new CodecBsonDecoder(new BsonDocumentCodec(registry))).orElseGet(() -> new CodecBsonDecoder(new BsonDocumentCodec()));
    }

    @Singleton
    @NonNull
    CodecBsonDecoder<ObjectId> objectId() {
        return new CodecBsonDecoder<ObjectId>((Codec<ObjectId>)new ObjectIdCodec());
    }

    @Singleton
    @NonNull
    CodecBsonDecoder<Decimal128> decimal128() {
        return new CodecBsonDecoder<Decimal128>((Codec<Decimal128>)new Decimal128Codec());
    }

    @Singleton
    @NonNull
    CodecBsonDecoder<BsonRegularExpression> bsonRegularExpression() {
        return new CodecBsonDecoder<BsonRegularExpression>((Codec<BsonRegularExpression>)new BsonRegularExpressionCodec());
    }

    @Singleton
    @NonNull
    CodecBsonDecoder<BsonBinary> bsonBinary() {
        return new CodecBsonDecoder<BsonBinary>((Codec<BsonBinary>)new BsonBinaryCodec());
    }

    @Singleton
    @NonNull
    CodecBsonDecoder<BsonDbPointer> bsonDbPointer() {
        return new CodecBsonDecoder<BsonDbPointer>((Codec<BsonDbPointer>)new BsonDBPointerCodec());
    }

    @Singleton
    @NonNull
    CodecBsonDecoder<BsonTimestamp> bsonTimestamp() {
        return new CodecBsonDecoder<BsonTimestamp>((Codec<BsonTimestamp>)new BsonTimestampCodec());
    }
}

