/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.runtime.context.env;

import io.micronaut.aop.MethodInterceptor;
import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.context.BeanContext;
import io.micronaut.context.BeanRegistration;
import io.micronaut.context.annotation.Property;
import io.micronaut.context.env.Environment;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.bind.annotation.Bindable;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.ReturnType;
import io.micronaut.core.value.PropertyNotFoundException;
import io.micronaut.runtime.context.env.ConfigurationAdvice;
import java.util.Optional;
import javax.inject.Singleton;

@Singleton
@Internal
public class ConfigurationIntroductionAdvice
implements MethodInterceptor<Object, Object> {
    private static final String MEMBER_BEAN = "bean";
    private static final String MEMBER_NAME = "name";
    private final Environment environment;
    private final BeanContext beanContext;

    ConfigurationIntroductionAdvice(Environment environment, BeanContext beanContext) {
        this.environment = environment;
        this.beanContext = beanContext;
    }

    public Object intercept(MethodInvocationContext<Object, Object> context) {
        BeanRegistration registration;
        boolean iterable;
        ReturnType rt = context.getReturnType();
        Class returnType = rt.getType();
        if (context.isTrue(ConfigurationAdvice.class, MEMBER_BEAN)) {
            if (context.isNullable()) {
                Object v = this.beanContext.findBean(returnType).orElse(null);
                if (v != null) {
                    return this.environment.convertRequired(v, returnType);
                }
                return v;
            }
            return this.environment.convertRequired(this.beanContext.getBean(returnType), returnType);
        }
        String property = context.stringValue(Property.class, MEMBER_NAME).orElse(null);
        if (property == null) {
            throw new IllegalStateException("No property name available to resolve");
        }
        boolean bl = iterable = property.indexOf(42) > -1;
        if (iterable && (registration = (BeanRegistration)this.beanContext.findBeanRegistration(context.getTarget()).orElse(null)) != null) {
            String name = registration.getIdentifier().getName();
            property = property.replace("*", name);
        }
        String defaultValue = context.stringValue(Bindable.class, "defaultValue").orElse(null);
        Argument argument = rt.asArgument();
        Optional value = this.environment.getProperty(property, argument);
        if (defaultValue != null) {
            return value.orElseGet(() -> this.environment.convertRequired((Object)defaultValue, argument));
        }
        if (rt.isOptional()) {
            return value.orElse(Optional.empty());
        }
        if (context.isNullable()) {
            return value.orElse(null);
        }
        String finalProperty = property;
        return value.orElseThrow(() -> new PropertyNotFoundException(finalProperty, argument.getType()));
    }
}

