/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.reactive.rxjava2;

import io.micronaut.core.annotation.Internal;
import io.micronaut.reactive.rxjava2.RxInstrumentedComponent;
import io.micronaut.reactive.rxjava2.RxInstrumenterFactory;
import io.micronaut.scheduling.instrument.Instrumentation;
import io.micronaut.scheduling.instrument.InvocationInstrumenter;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;

@Internal
final class RxInstrumentedObserver<T>
implements Observer<T>,
RxInstrumentedComponent {
    private final Observer<T> source;
    private final InvocationInstrumenter instrumenter;

    RxInstrumentedObserver(Observer<T> source, RxInstrumenterFactory instrumenterFactory) {
        this.source = source;
        this.instrumenter = instrumenterFactory.create();
    }

    public void onSubscribe(Disposable d) {
        try (Instrumentation ignored = this.instrumenter.newInstrumentation();){
            this.source.onSubscribe(d);
        }
    }

    public void onNext(T t) {
        try (Instrumentation ignored = this.instrumenter.newInstrumentation();){
            this.source.onNext(t);
        }
    }

    public void onError(Throwable t) {
        try (Instrumentation ignored = this.instrumenter.newInstrumentation();){
            this.source.onError(t);
        }
    }

    public void onComplete() {
        try (Instrumentation ignored = this.instrumenter.newInstrumentation();){
            this.source.onComplete();
        }
    }
}

