/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jackson.serialize;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import io.micronaut.core.value.OptionalMultiValues;
import io.micronaut.core.value.OptionalValues;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import javax.inject.Singleton;

@Singleton
public class OptionalValuesSerializer
extends JsonSerializer<OptionalValues<?>> {
    public boolean isEmpty(SerializerProvider provider, OptionalValues<?> value) {
        return value.isEmpty();
    }

    public void serialize(OptionalValues<?> value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        gen.writeStartObject();
        for (CharSequence key : value) {
            Optional opt = value.get(key);
            if (!opt.isPresent()) continue;
            String fieldName = key.toString();
            gen.writeFieldName(fieldName);
            Object v = opt.get();
            if (value instanceof OptionalMultiValues) {
                List list = (List)v;
                if (list.size() == 1) {
                    gen.writeObject(list.get(0));
                    continue;
                }
                gen.writeObject((Object)list);
                continue;
            }
            gen.writeObject(v);
        }
        gen.writeEndObject();
    }
}

