/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.web.router;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.order.OrderUtil;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.SupplierUtil;
import io.micronaut.http.HttpAttributes;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MediaType;
import io.micronaut.http.annotation.FilterMatcher;
import io.micronaut.http.filter.FilterPatternStyle;
import io.micronaut.http.filter.HttpFilter;
import io.micronaut.http.filter.HttpFilterResolver;
import io.micronaut.http.filter.HttpServerFilterResolver;
import io.micronaut.http.uri.UriMatchTemplate;
import io.micronaut.web.router.ErrorRoute;
import io.micronaut.web.router.FilterRoute;
import io.micronaut.web.router.MethodBasedRoute;
import io.micronaut.web.router.RouteBuilder;
import io.micronaut.web.router.RouteMatch;
import io.micronaut.web.router.Router;
import io.micronaut.web.router.StatusRoute;
import io.micronaut.web.router.UriRoute;
import io.micronaut.web.router.UriRouteMatch;
import io.micronaut.web.router.exceptions.RoutingException;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;

@Singleton
public class DefaultRouter
implements Router,
HttpServerFilterResolver<RouteMatch<?>> {
    private final Map<String, List<UriRoute>> routesByMethod = new HashMap<String, List<UriRoute>>();
    private final List<StatusRoute> statusRoutes = new ArrayList<StatusRoute>();
    private final List<ErrorRoute> errorRoutes = new ArrayList<ErrorRoute>();
    private final Set<Integer> exposedPorts;
    private final List<FilterRoute> alwaysMatchesFilterRoutes = new ArrayList<FilterRoute>();
    private final List<FilterRoute> preconditionFilterRoutes = new ArrayList<FilterRoute>();
    private final Supplier<List<HttpFilter>> alwaysMatchesHttpFilters = SupplierUtil.memoized(() -> {
        if (this.alwaysMatchesFilterRoutes.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<HttpFilter> httpFilters = new ArrayList<HttpFilter>(this.alwaysMatchesFilterRoutes.size());
        for (FilterRoute filterRoute : this.alwaysMatchesFilterRoutes) {
            httpFilters.add(filterRoute.getFilter());
        }
        httpFilters.sort(OrderUtil.COMPARATOR);
        return httpFilters;
    });

    public DefaultRouter(RouteBuilder ... builders) {
        this(Arrays.asList(builders));
    }

    @Inject
    public DefaultRouter(Collection<RouteBuilder> builders) {
        HashSet<Integer> exposedPorts = new HashSet<Integer>(5);
        ArrayList<FilterRoute> filterRoutes = new ArrayList<FilterRoute>();
        for (RouteBuilder builder : builders) {
            MethodBasedRoute existing;
            List<UriRoute> constructedRoutes = builder.getUriRoutes();
            for (UriRoute route : constructedRoutes) {
                String key = route.getHttpMethodName();
                this.routesByMethod.computeIfAbsent(key, x -> new ArrayList()).add(route);
            }
            for (StatusRoute statusRoute : builder.getStatusRoutes()) {
                if (this.statusRoutes.contains(statusRoute)) {
                    existing = this.statusRoutes.stream().filter(r -> r.equals(statusRoute)).findFirst().orElse(null);
                    throw new RoutingException("Attempted to register multiple local routes for http status [" + statusRoute.status() + "]. New route: " + statusRoute + ". Existing: " + existing);
                }
                this.statusRoutes.add(statusRoute);
            }
            for (ErrorRoute errorRoute : builder.getErrorRoutes()) {
                if (this.errorRoutes.contains(errorRoute)) {
                    existing = this.errorRoutes.stream().filter(r -> r.equals(errorRoute)).findFirst().orElse(null);
                    throw new RoutingException("Attempted to register multiple local routes for error [" + errorRoute.exceptionType().getSimpleName() + "]. New route: " + errorRoute + ". Existing: " + existing);
                }
                this.errorRoutes.add(errorRoute);
            }
            filterRoutes.addAll(builder.getFilterRoutes());
            exposedPorts.addAll(builder.getExposedPorts());
        }
        this.exposedPorts = CollectionUtils.isNotEmpty(exposedPorts) ? exposedPorts : Collections.emptySet();
        this.routesByMethod.values().forEach(this::finalizeRoutes);
        for (FilterRoute filterRoute : filterRoutes) {
            if (this.isMatchesAll(filterRoute)) {
                this.alwaysMatchesFilterRoutes.add(filterRoute);
                continue;
            }
            this.preconditionFilterRoutes.add(filterRoute);
        }
    }

    private boolean isMatchesAll(FilterRoute filterRoute) {
        if (filterRoute.getAnnotationMetadata().hasStereotype(FilterMatcher.NAME)) {
            return false;
        }
        if (filterRoute.hasMethods()) {
            return false;
        }
        if (filterRoute.hasPatterns()) {
            for (String pattern : filterRoute.getPatterns()) {
                if ("/**".equals(pattern)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public Set<Integer> getExposedPorts() {
        return this.exposedPorts;
    }

    @Override
    public void applyDefaultPorts(List<Integer> ports) {
        Predicate<HttpRequest> portMatches = httpRequest -> ports.contains(httpRequest.getServerAddress().getPort());
        for (List<UriRoute> routes : this.routesByMethod.values()) {
            for (int i = 0; i < routes.size(); ++i) {
                UriRoute route = routes.get(i);
                if (route.getPort() != null) continue;
                routes.set(i, (UriRoute)route.where(portMatches));
            }
        }
    }

    @Override
    @NonNull
    public <T, R> Stream<UriRouteMatch<T, R>> find(@NonNull HttpRequest<?> request, @NonNull CharSequence uri) {
        return this.find(request.getMethodName(), uri, null).stream();
    }

    @Override
    @NonNull
    public <T, R> Stream<UriRouteMatch<T, R>> find(@NonNull HttpRequest<?> request) {
        boolean permitsBody = HttpMethod.permitsRequestBody((HttpMethod)request.getMethod());
        return this.find(request, request.getPath()).filter(match -> match.test(request) && (!permitsBody || match.doesConsume(request.getContentType().orElse(null))));
    }

    @Override
    @NonNull
    public <T, R> Stream<UriRouteMatch<T, R>> find(@NonNull HttpMethod httpMethod, @NonNull CharSequence uri, @Nullable HttpRequest<?> context) {
        return this.find(httpMethod.name(), uri, null).stream();
    }

    @Override
    @NonNull
    public Stream<UriRoute> uriRoutes() {
        return this.routesByMethod.values().stream().flatMap(Collection::stream);
    }

    @Override
    @NonNull
    public <T, R> List<UriRouteMatch<T, R>> findAllClosest(@NonNull HttpRequest<?> request) {
        HttpMethod httpMethod = request.getMethod();
        MediaType contentType = request.getContentType().orElse(null);
        boolean permitsBody = HttpMethod.permitsRequestBody((HttpMethod)httpMethod);
        Collection acceptedProducedTypes = request.accept();
        List<UriRouteMatch<T, R>> uriRoutes = this.find(request.getMethodName(), (CharSequence)request.getPath(), (UriRouteMatch routeMatch) -> routeMatch.test(request) && (!permitsBody || routeMatch.doesConsume(contentType)) && routeMatch.doesProduce(acceptedProducedTypes));
        int routeCount = uriRoutes.size();
        if (routeCount <= 1) {
            return uriRoutes;
        }
        if (CollectionUtils.isNotEmpty((Collection)acceptedProducedTypes)) {
            MediaType mediaType = (MediaType)acceptedProducedTypes.iterator().next();
            ArrayList<UriRouteMatch<T, R>> mostSpecific = new ArrayList<UriRouteMatch<T, R>>(uriRoutes.size());
            for (UriRouteMatch<T, R> routeMatch2 : uriRoutes) {
                if (!routeMatch2.explicitlyProduces(mediaType)) continue;
                mostSpecific.add(routeMatch2);
            }
            if (!mostSpecific.isEmpty() || !acceptedProducedTypes.contains(MediaType.ALL_TYPE)) {
                uriRoutes = mostSpecific;
            }
        }
        if ((routeCount = uriRoutes.size()) > 1 && permitsBody) {
            ArrayList<UriRouteMatch<T, R>> explicitlyConsumedRoutes = new ArrayList<UriRouteMatch<T, R>>(routeCount);
            ArrayList<UriRouteMatch<T, R>> consumesRoutes = new ArrayList<UriRouteMatch<T, R>>(routeCount);
            for (UriRouteMatch<T, R> match : uriRoutes) {
                if (match.explicitlyConsumes(contentType != null ? contentType : MediaType.ALL_TYPE)) {
                    explicitlyConsumedRoutes.add(match);
                }
                if (!explicitlyConsumedRoutes.isEmpty() || !match.doesConsume(contentType)) continue;
                consumesRoutes.add(match);
            }
            List<UriRouteMatch<T, R>> list = uriRoutes = explicitlyConsumedRoutes.isEmpty() ? consumesRoutes : explicitlyConsumedRoutes;
        }
        if ((routeCount = uriRoutes.size()) > 1) {
            long variableCount = 0L;
            long rawLength = 0L;
            ArrayList<UriRouteMatch<T, R>> closestMatches = new ArrayList<UriRouteMatch<T, R>>(routeCount);
            for (int i = 0; i < routeCount; ++i) {
                UriRouteMatch<T, R> match = uriRoutes.get(i);
                UriMatchTemplate template = match.getRoute().getUriMatchTemplate();
                long variable = template.getPathVariableSegmentCount();
                long raw = template.getRawSegmentLength();
                if (i == 0) {
                    variableCount = variable;
                    rawLength = raw;
                }
                if (variable > variableCount || raw < rawLength) break;
                closestMatches.add(match);
            }
            uriRoutes = closestMatches;
        }
        return uriRoutes;
    }

    @Override
    @NonNull
    public <T, R> Optional<UriRouteMatch<T, R>> route(@NonNull HttpMethod httpMethod, @NonNull CharSequence uri) {
        List routes = this.routesByMethod.getOrDefault(httpMethod.name(), Collections.emptyList());
        for (UriRoute uriRoute : routes) {
            Optional<UriRouteMatch<T, R>> match = uriRoute.match(uri.toString());
            if (!match.isPresent()) continue;
            return match;
        }
        return Optional.empty();
    }

    @Override
    public <R> Optional<RouteMatch<R>> route(@NonNull HttpStatus status) {
        for (StatusRoute statusRoute : this.statusRoutes) {
            Optional<RouteMatch<R>> match;
            if (statusRoute.originatingType() != null || !(match = statusRoute.match(status)).isPresent()) continue;
            return match;
        }
        return Optional.empty();
    }

    @Override
    public <R> Optional<RouteMatch<R>> route(@NonNull Class originatingClass, @NonNull HttpStatus status) {
        for (StatusRoute statusRoute : this.statusRoutes) {
            Optional<RouteMatch<R>> match = statusRoute.match(originatingClass, status);
            if (!match.isPresent()) continue;
            return match;
        }
        return Optional.empty();
    }

    @Override
    public <R> Optional<RouteMatch<R>> route(@NonNull Class originatingClass, @NonNull Throwable error) {
        LinkedHashMap matchedRoutes = new LinkedHashMap();
        for (ErrorRoute errorRoute : this.errorRoutes) {
            Optional<RouteMatch<RouteMatch>> match = errorRoute.match(originatingClass, error);
            match.ifPresent(m -> matchedRoutes.put(errorRoute, (RouteMatch)m));
        }
        return this.findRouteMatch(matchedRoutes, error);
    }

    @Override
    public <R> Optional<RouteMatch<R>> findErrorRoute(@NonNull Class<?> originatingClass, @NonNull Throwable error, HttpRequest<?> request) {
        return this.findErrorRouteInternal(originatingClass, error, request);
    }

    private <R> Optional<RouteMatch<R>> findErrorRouteInternal(@Nullable Class<?> originatingClass, @NonNull Throwable error, HttpRequest<?> request) {
        Collection accept = request.accept();
        boolean hasAcceptHeader = CollectionUtils.isNotEmpty((Collection)accept);
        if (hasAcceptHeader) {
            LinkedHashMap matchedRoutes = new LinkedHashMap();
            for (ErrorRoute errorRoute : this.errorRoutes) {
                RouteMatch match = errorRoute.match(originatingClass, error).orElse(null);
                if (match == null || !match.doesProduce(accept)) continue;
                matchedRoutes.put(errorRoute, match);
            }
            return this.findRouteMatch(matchedRoutes, error);
        }
        LinkedHashMap producesAllMatchedRoutes = new LinkedHashMap();
        LinkedHashMap producesSpecificMatchedRoutes = new LinkedHashMap();
        for (ErrorRoute errorRoute : this.errorRoutes) {
            RouteMatch match = errorRoute.match(originatingClass, error).orElse(null);
            if (match == null) continue;
            List<MediaType> produces = match.getProduces();
            if (CollectionUtils.isEmpty(produces) || produces.contains(MediaType.ALL_TYPE)) {
                producesAllMatchedRoutes.put(errorRoute, match);
                continue;
            }
            producesSpecificMatchedRoutes.put(errorRoute, match);
        }
        if (producesAllMatchedRoutes.isEmpty()) {
            return this.findRouteMatch(producesSpecificMatchedRoutes, error);
        }
        return this.findRouteMatch(producesAllMatchedRoutes, error);
    }

    @Override
    public <R> Optional<RouteMatch<R>> findErrorRoute(@NonNull Throwable error, HttpRequest<?> request) {
        return this.findErrorRouteInternal(null, error, request);
    }

    @Override
    public <R> Optional<RouteMatch<R>> findStatusRoute(@NonNull Class<?> originatingClass, @NonNull HttpStatus status, HttpRequest<?> request) {
        return this.findStatusInternal(originatingClass, status, request);
    }

    @Override
    public <R> Optional<RouteMatch<R>> findStatusRoute(@NonNull HttpStatus status, HttpRequest<?> request) {
        return this.findStatusInternal(null, status, request);
    }

    private <R> Optional<RouteMatch<R>> findStatusInternal(@Nullable Class<?> originatingClass, @NonNull HttpStatus status, HttpRequest<?> request) {
        Collection accept = request.accept();
        boolean hasAcceptHeader = CollectionUtils.isNotEmpty((Collection)accept);
        if (hasAcceptHeader) {
            for (StatusRoute statusRoute : this.statusRoutes) {
                RouteMatch match = statusRoute.match(originatingClass, status).orElse(null);
                if (match == null || !match.doesProduce(accept)) continue;
                return Optional.of(match);
            }
        } else {
            RouteMatch firstMatch = null;
            for (StatusRoute errorRoute : this.statusRoutes) {
                RouteMatch match = errorRoute.match(originatingClass, status).orElse(null);
                if (match == null) continue;
                List<MediaType> produces = match.getProduces();
                if (CollectionUtils.isEmpty(produces) || produces.contains(MediaType.ALL_TYPE)) {
                    return Optional.of(match);
                }
                if (firstMatch != null) continue;
                firstMatch = match;
            }
            return Optional.ofNullable(firstMatch);
        }
        return Optional.empty();
    }

    @Override
    public <R> Optional<RouteMatch<R>> route(@NonNull Throwable error) {
        LinkedHashMap matchedRoutes = new LinkedHashMap();
        for (ErrorRoute errorRoute : this.errorRoutes) {
            if (errorRoute.originatingType() != null) continue;
            Optional<RouteMatch<RouteMatch>> match = errorRoute.match(error);
            match.ifPresent(m -> matchedRoutes.put(errorRoute, (RouteMatch)m));
        }
        return this.findRouteMatch(matchedRoutes, error);
    }

    @Override
    @NonNull
    public List<HttpFilter> findFilters(@NonNull HttpRequest<?> request) {
        if (this.preconditionFilterRoutes.isEmpty()) {
            return this.alwaysMatchesHttpFilters.get();
        }
        ArrayList httpFilters = new ArrayList(this.alwaysMatchesFilterRoutes.size() + this.preconditionFilterRoutes.size());
        httpFilters.addAll(this.alwaysMatchesHttpFilters.get());
        RouteMatch routeMatch = request.getAttribute((CharSequence)HttpAttributes.ROUTE_MATCH).filter(o -> o instanceof RouteMatch).orElse(null);
        HttpMethod method = request.getMethod();
        URI uri = request.getUri();
        for (FilterRoute filterRoute : this.preconditionFilterRoutes) {
            if (routeMatch != null && !this.matchesFilterMatcher(filterRoute, routeMatch)) continue;
            filterRoute.match(method, uri).ifPresent(httpFilters::add);
        }
        httpFilters.sort(OrderUtil.COMPARATOR);
        return Collections.unmodifiableList(httpFilters);
    }

    @Override
    @NonNull
    public <T, R> Stream<UriRouteMatch<T, R>> findAny(@NonNull CharSequence uri, @Nullable HttpRequest<?> context) {
        ArrayList<UriRouteMatch> matchedRoutes = new ArrayList<UriRouteMatch>(5);
        String uriStr = uri.toString();
        for (List<UriRoute> routes : this.routesByMethod.values()) {
            for (UriRoute route : routes) {
                UriRouteMatch match = route.match(uriStr).orElse(null);
                if (match == null || !match.test(context)) continue;
                matchedRoutes.add(match);
            }
        }
        return matchedRoutes.stream();
    }

    private <T, R> List<UriRouteMatch<T, R>> find(String httpMethodName, CharSequence uri, @Nullable Predicate<UriRouteMatch> predicate) {
        List routes = this.routesByMethod.getOrDefault(httpMethodName, Collections.emptyList());
        if (CollectionUtils.isNotEmpty(routes)) {
            String uriStr = uri.toString();
            LinkedList<UriRouteMatch<T, R>> routeMatches = new LinkedList<UriRouteMatch<T, R>>();
            for (UriRoute route : routes) {
                Optional<UriRouteMatch> match = route.match(uriStr);
                if (predicate != null) {
                    match = match.filter(predicate);
                }
                match.ifPresent(routeMatches::add);
            }
            return routeMatches;
        }
        return Collections.emptyList();
    }

    private UriRoute[] finalizeRoutes(List<UriRoute> routes) {
        Collections.sort(routes);
        return routes.toArray(new UriRoute[0]);
    }

    private <T> Optional<RouteMatch<T>> findRouteMatch(Map<ErrorRoute, RouteMatch<T>> matchedRoutes, Throwable error) {
        if (matchedRoutes.size() == 1) {
            return matchedRoutes.values().stream().findFirst();
        }
        if (matchedRoutes.size() > 1) {
            int minCount = Integer.MAX_VALUE;
            Supplier<List> hierarchySupplier = () -> ClassUtils.resolveHierarchy(error.getClass());
            Optional<RouteMatch<T>> match = Optional.empty();
            Class<?> errorClass = error.getClass();
            for (Map.Entry<ErrorRoute, RouteMatch<T>> entry : matchedRoutes.entrySet()) {
                Class<? extends Throwable> exceptionType = entry.getKey().exceptionType();
                if (exceptionType.equals(errorClass)) {
                    match = Optional.of(entry.getValue());
                    break;
                }
                List hierarchy = hierarchySupplier.get();
                int index = hierarchy.indexOf(exceptionType);
                if (index <= -1 || index >= minCount) continue;
                minCount = index;
                match = Optional.of(entry.getValue());
            }
            return match;
        }
        return Optional.empty();
    }

    public List<HttpFilterResolver.FilterEntry<HttpFilter>> resolveFilterEntries(RouteMatch<?> routeMatch) {
        if (this.preconditionFilterRoutes.isEmpty()) {
            return this.alwaysMatchesFilterRoutes;
        }
        ArrayList<FilterRoute> filterEntries = new ArrayList<FilterRoute>(this.alwaysMatchesFilterRoutes.size() + this.preconditionFilterRoutes.size());
        filterEntries.addAll(this.alwaysMatchesFilterRoutes);
        for (FilterRoute filterRoute : this.preconditionFilterRoutes) {
            if (this.matchesFilterMatcher(filterRoute, routeMatch)) continue;
            filterEntries.add(filterRoute);
        }
        filterEntries.sort(OrderUtil.COMPARATOR);
        return Collections.unmodifiableList(filterEntries);
    }

    public List<HttpFilter> resolveFilters(HttpRequest<?> request, List<HttpFilterResolver.FilterEntry<HttpFilter>> filterEntries) {
        ArrayList<Object> httpFilters = new ArrayList<Object>(filterEntries.size());
        for (HttpFilterResolver.FilterEntry<HttpFilter> entry : filterEntries) {
            if (entry.hasMethods() && !entry.getFilterMethods().contains(request.getMethod())) continue;
            if (entry.hasPatterns()) {
                String path = request.getPath();
                String[] patterns = entry.getPatterns();
                FilterPatternStyle patternStyle = entry.getAnnotationMetadata().enumValue("patternStyle", FilterPatternStyle.class).orElse(FilterPatternStyle.ANT);
                boolean matches = true;
                for (String pattern : patterns) {
                    if (!matches) break;
                    matches = "/**".equals(pattern) || patternStyle.getPathMatcher().matches(pattern, path);
                }
                if (!matches) continue;
            }
            httpFilters.add(entry.getFilter());
        }
        httpFilters.sort(OrderUtil.COMPARATOR);
        return Collections.unmodifiableList(httpFilters);
    }

    private boolean matchesFilterMatcher(FilterRoute filterRoute, RouteMatch<?> context) {
        String filterAnnotation;
        boolean matches;
        AnnotationMetadata annotationMetadata = filterRoute.getAnnotationMetadata();
        boolean bl = matches = !annotationMetadata.hasStereotype(FilterMatcher.NAME);
        if (!matches && (filterAnnotation = (String)annotationMetadata.getAnnotationNameByStereotype(FilterMatcher.NAME).orElse(null)) != null) {
            matches = context.getAnnotationMetadata().hasStereotype(filterAnnotation);
        }
        return matches;
    }
}

