/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.util;

import java.util.Optional;
import java.util.function.Supplier;

public class SupplierUtil {
    public static <T> Supplier<T> memoized(final Supplier<T> valueSupplier) {
        return new Supplier<T>(){
            private volatile boolean initialized;
            private T value;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public T get() {
                if (!this.initialized) {
                    1 var1_1 = this;
                    synchronized (var1_1) {
                        if (!this.initialized) {
                            Object t = valueSupplier.get();
                            this.value = t;
                            this.initialized = true;
                            return t;
                        }
                    }
                }
                return this.value;
            }
        };
    }

    public static <T> Supplier<T> memoizedNonEmpty(final Supplier<T> valueSupplier) {
        return new Supplier<T>(){
            private volatile boolean initialized;
            private T value;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public T get() {
                if (!this.initialized) {
                    2 var1_1 = this;
                    synchronized (var1_1) {
                        if (!this.initialized) {
                            Optional optional;
                            Object t = valueSupplier.get();
                            if (t == null) {
                                return null;
                            }
                            if (t instanceof Optional && (optional = (Optional)t).isEmpty()) {
                                return t;
                            }
                            this.value = t;
                            this.initialized = true;
                            return t;
                        }
                    }
                }
                return this.value;
            }
        };
    }
}

