/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.kafka.serde;

import io.micronaut.configuration.kafka.serde.JsonObjectSerde;
import io.micronaut.configuration.kafka.serde.SerdeRegistry;
import io.micronaut.context.BeanContext;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.reflect.ClassUtils;
import jakarta.inject.Singleton;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;

@Internal
@Singleton
public class JsonSerdeRegistry
implements SerdeRegistry {
    private final BeanContext beanContext;
    private final Map<Class, JsonObjectSerde> serdes = new ConcurrentHashMap<Class, JsonObjectSerde>();

    protected JsonSerdeRegistry(BeanContext beanContext) {
        this.beanContext = beanContext;
    }

    @Override
    public <T> Serde<T> getSerde(Class<T> type) {
        if (ClassUtils.isJavaBasicType(type)) {
            return Serdes.serdeFrom(String.class);
        }
        JsonObjectSerde jsonSerde = this.serdes.get(type);
        if (jsonSerde == null) {
            jsonSerde = (JsonObjectSerde)this.beanContext.createBean(JsonObjectSerde.class, new Object[]{type});
            this.serdes.put(type, jsonSerde);
        }
        return jsonSerde;
    }
}

