/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.kafka.serde;

import io.micronaut.configuration.kafka.serde.SerdeRegistry;
import io.micronaut.context.annotation.Primary;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.order.OrderUtil;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.core.serialize.exceptions.SerializationException;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;

@Singleton
@Primary
@Internal
public class CompositeSerdeRegistry
implements SerdeRegistry {
    private final List<SerdeRegistry> registries;
    private final Map<Class, Serde> serdeMap = new ConcurrentHashMap<Class, Serde>();

    public CompositeSerdeRegistry(SerdeRegistry ... registries) {
        this.registries = new ArrayList(registries != null ? Arrays.asList(registries) : Collections.emptyList());
        OrderUtil.sort(this.registries);
    }

    @Override
    @NonNull
    public <T> Serde<T> getSerde(Class<T> type) {
        Serde serde = this.serdeMap.get(type);
        if (serde != null) {
            return serde;
        }
        type = ReflectionUtils.getWrapperType(type);
        try {
            return Serdes.serdeFrom((Class)type);
        }
        catch (IllegalArgumentException e) {
            for (SerdeRegistry registry : this.registries) {
                serde = registry.getSerde(type);
                if (serde == null) continue;
                this.serdeMap.put(type, serde);
                return serde;
            }
            throw new SerializationException("No available serde for type: " + type);
        }
    }
}

