/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.kafka.metrics.builder;

import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.TimeGauge;
import io.micronaut.configuration.kafka.metrics.builder.KafkaMetricMeterType;
import io.micronaut.configuration.kafka.metrics.builder.KafkaMetricMeterTypeRegistry;
import io.micronaut.configuration.kafka.metrics.builder.MeterType;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.util.StringUtils;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.KafkaMetric;

@Internal
public class KafkaMetricMeterTypeBuilder {
    private MeterRegistry meterRegistry;
    private String name;
    private Function<MetricName, List<Tag>> tagFunction;
    private KafkaMetric kafkaMetric;
    private String prefix;
    private final KafkaMetricMeterTypeRegistry kafkaMetricMeterTypeRegistry = new KafkaMetricMeterTypeRegistry();

    public static KafkaMetricMeterTypeBuilder newBuilder() {
        return new KafkaMetricMeterTypeBuilder();
    }

    public KafkaMetricMeterTypeBuilder metric(KafkaMetric kafkaMetric) {
        this.kafkaMetric = kafkaMetric;
        return this;
    }

    public KafkaMetricMeterTypeBuilder prefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public KafkaMetricMeterTypeBuilder name(String name) {
        this.name = name;
        return this;
    }

    public KafkaMetricMeterTypeBuilder tagFunction(Function<MetricName, List<Tag>> tagFunction) {
        this.tagFunction = tagFunction;
        return this;
    }

    public KafkaMetricMeterTypeBuilder registry(MeterRegistry meterRegistry) {
        this.meterRegistry = meterRegistry;
        return this;
    }

    public Optional<Meter> build() {
        KafkaMetricMeterType kafkaMetricMeterType;
        if (!this.isValid()) {
            return Optional.empty();
        }
        if (StringUtils.isEmpty((CharSequence)this.name)) {
            this.name = this.kafkaMetric.metricName().name();
        }
        if ((kafkaMetricMeterType = this.kafkaMetricMeterTypeRegistry.lookup(this.name)).getMeterType() == MeterType.GAUGE) {
            return Optional.of(Gauge.builder((String)this.getMetricName(), () -> (Number)this.kafkaMetric.metricValue()).tags((Iterable)this.tagFunction.apply(this.kafkaMetric.metricName())).description(kafkaMetricMeterType.getDescription()).baseUnit(kafkaMetricMeterType.getBaseUnit()).register(this.meterRegistry));
        }
        if (kafkaMetricMeterType.getMeterType() == MeterType.FUNCTION_COUNTER && this.kafkaMetric.metricValue() instanceof Double) {
            return Optional.of(FunctionCounter.builder((String)this.getMetricName(), (Object)this.kafkaMetric, value -> (Double)value.metricValue()).tags((Iterable)this.tagFunction.apply(this.kafkaMetric.metricName())).description(kafkaMetricMeterType.getDescription()).baseUnit(kafkaMetricMeterType.getBaseUnit()).register(this.meterRegistry));
        }
        if (kafkaMetricMeterType.getMeterType() == MeterType.TIME_GAUGE && this.kafkaMetric.metricValue() instanceof Double) {
            return Optional.of(TimeGauge.builder((String)this.getMetricName(), (Object)this.kafkaMetric, (TimeUnit)kafkaMetricMeterType.getTimeUnit(), value -> (Double)value.metricValue()).tags((Iterable)this.tagFunction.apply(this.kafkaMetric.metricName())).description(kafkaMetricMeterType.getDescription()).register(this.meterRegistry));
        }
        return Optional.empty();
    }

    private boolean isValid() {
        return this.tagFunction != null && this.meterRegistry != null && this.kafkaMetric != null && this.kafkaMetric.metricValue() instanceof Number && StringUtils.isNotEmpty((CharSequence)this.prefix);
    }

    private String getMetricName() {
        return this.prefix + "." + this.name;
    }
}

