/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.kafka.metrics;

import io.micrometer.core.instrument.MeterRegistry;
import io.micronaut.configuration.kafka.config.AbstractKafkaConfiguration;
import io.micronaut.context.event.BeanCreatedEvent;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public abstract class AbstractKafkaMetrics<T extends AbstractKafkaConfiguration> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractKafkaMetrics.class);

    protected T addKafkaMetrics(BeanCreatedEvent<T> event, String kafkaMetricsReporterClassName) {
        return this.addKafkaMetrics(event, kafkaMetricsReporterClassName, null);
    }

    protected T addKafkaMetrics(BeanCreatedEvent<T> event, String kafkaMetricsReporterClassName, @Nullable MeterRegistry meterRegistry) {
        Properties props = ((AbstractKafkaConfiguration)event.getBean()).getConfig();
        if (!props.containsKey("metric.reporters")) {
            props.put("metric.reporters", kafkaMetricsReporterClassName);
            LOG.debug("Adding kafka property:value of {}:{}", (Object)"metric.reporters", (Object)kafkaMetricsReporterClassName);
        }
        if (meterRegistry != null) {
            props.put("meter.registry", meterRegistry);
        }
        return (T)((AbstractKafkaConfiguration)event.getBean());
    }
}

