/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.kafka.graal;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Inject;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.spi.LoginModule;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.security.auth.AuthenticateCallbackHandler;
import org.apache.kafka.common.security.auth.SaslExtensions;
import org.apache.kafka.common.security.auth.SaslExtensionsCallback;
import org.apache.kafka.common.security.authenticator.LoginManager;
import org.apache.kafka.common.security.authenticator.SaslClientCallbackHandler;
import org.apache.kafka.common.security.scram.ScramExtensionsCallback;
import org.apache.kafka.common.security.scram.internals.ScramMechanism;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TargetClass(value=SaslClientCallbackHandler.class)
public final class SaslClientCallbackHandlerSubstitute
implements AuthenticateCallbackHandler {
    @Alias
    private String mechanism;
    @Inject
    private Logger logger = LoggerFactory.getLogger(LoginManager.class);
    @Inject
    private Subject subject;

    @Substitute
    public SaslClientCallbackHandlerSubstitute() {
    }

    @Substitute
    public void configure(Map<String, ?> configs, String saslMechanism, List<AppConfigurationEntry> jaasConfigEntries) {
        this.mechanism = saslMechanism;
        this.subject = null;
        int entrySize = jaasConfigEntries.size();
        if (entrySize == 0) {
            this.logger.warn("Missing JAAS config entry, missing or malformed sasl.jaas.config property.");
            return;
        }
        if (entrySize > 1) {
            this.logger.warn("Multiple JAAS config entries, Kafka client's sasl.jaas.config can have only one JAAS config entry.");
            return;
        }
        AppConfigurationEntry jaasConfigEntry = jaasConfigEntries.get(0);
        String jaasLoginModuleName = jaasConfigEntry.getLoginModuleName();
        this.subject = new Subject();
        try {
            Class.forName(jaasLoginModuleName).asSubclass(LoginModule.class).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]).initialize(this.subject, (CallbackHandler)((Object)this), new HashMap(), jaasConfigEntry.getOptions());
        }
        catch (ReflectiveOperationException e) {
            throw new KafkaException("Can't instantiate JAAS login module" + jaasLoginModuleName, (Throwable)e);
        }
    }

    @Substitute
    public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
        for (Callback callback : callbacks) {
            Map extensions;
            if (callback instanceof NameCallback) {
                NameCallback nc = (NameCallback)callback;
                if (this.subject != null && !this.subject.getPublicCredentials(String.class).isEmpty()) {
                    nc.setName(this.subject.getPublicCredentials(String.class).iterator().next());
                    continue;
                }
                nc.setName(nc.getDefaultName());
                continue;
            }
            if (callback instanceof PasswordCallback) {
                if (this.subject != null && !this.subject.getPrivateCredentials(String.class).isEmpty()) {
                    char[] password = this.subject.getPrivateCredentials(String.class).iterator().next().toCharArray();
                    ((PasswordCallback)callback).setPassword(password);
                    continue;
                }
                String errorMessage = "Could not login: the client is being asked for a password, but the Kafka client code does not currently support obtaining a password from the user.";
                throw new UnsupportedCallbackException(callback, errorMessage);
            }
            if (callback instanceof RealmCallback) {
                RealmCallback rc = (RealmCallback)callback;
                rc.setText(rc.getDefaultText());
                continue;
            }
            if (callback instanceof AuthorizeCallback) {
                AuthorizeCallback ac = (AuthorizeCallback)callback;
                String authId = ac.getAuthenticationID();
                String authzId = ac.getAuthorizationID();
                ac.setAuthorized(authId.equals(authzId));
                if (!ac.isAuthorized()) continue;
                ac.setAuthorizedID(authzId);
                continue;
            }
            if (callback instanceof ScramExtensionsCallback) {
                if (!ScramMechanism.isScram((String)this.mechanism) || this.subject == null || this.subject.getPublicCredentials(Map.class).isEmpty()) continue;
                extensions = this.subject.getPublicCredentials(Map.class).iterator().next();
                ((ScramExtensionsCallback)callback).extensions(extensions);
                continue;
            }
            if (callback instanceof SaslExtensionsCallback) {
                if ("GSSAPI".equals(this.mechanism) || this.subject == null || this.subject.getPublicCredentials(SaslExtensions.class).isEmpty()) continue;
                extensions = this.subject.getPublicCredentials(SaslExtensions.class).iterator().next();
                ((SaslExtensionsCallback)callback).extensions((SaslExtensions)extensions);
                continue;
            }
            throw new UnsupportedCallbackException(callback, "Unrecognized SASL ClientCallback");
        }
    }

    @Substitute
    public void close() {
    }
}

