/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.aws.sdk.v2.client.urlConnection;

import io.micronaut.aws.sdk.v2.client.urlConnection.UrlConnectionClientConfiguration;
import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Requires;
import jakarta.inject.Singleton;
import software.amazon.awssdk.http.SdkHttpClient;

@Factory
@BootstrapContextCompatible
public class UrlConnectionClientFactory {
    public static final String HTTP_SERVICE_IMPL = "software.amazon.awssdk.http.service.impl";
    public static final String URL_CONNECTION_SDK_HTTP_SERVICE = "software.amazon.awssdk.http.urlconnection.UrlConnectionSdkHttpService";

    @Bean(preDestroy="close")
    @Singleton
    @Requires(missingBeans={SdkHttpClient.class})
    public SdkHttpClient urlConnectionClient(UrlConnectionClientConfiguration configuration) {
        return this.doCreateClient(configuration);
    }

    @Bean(preDestroy="close")
    @Singleton
    @Requires(property="software.amazon.awssdk.http.service.impl", value="software.amazon.awssdk.http.urlconnection.UrlConnectionSdkHttpService")
    public SdkHttpClient systemPropertyClient(UrlConnectionClientConfiguration configuration) {
        return this.doCreateClient(configuration);
    }

    private SdkHttpClient doCreateClient(UrlConnectionClientConfiguration configuration) {
        return configuration.getBuilder().build();
    }
}

