/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.discovery.cloud.aws;

import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.context.annotation.Primary;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.util.Toggleable;

@ConfigurationProperties(value="micronaut.application.ec2.metadata")
@Requirements(value={@Requires(notEnv={"function"}), @Requires(env={"ec2"})})
@Primary
public class AmazonMetadataConfiguration
implements Toggleable {
    public static final String PREFIX = "micronaut.application.ec2.metadata";
    public static final boolean DEFAULT_ENABLED = true;
    public static final String DEFAULT_URL = "http://169.254.169.254";
    private String url = "http://169.254.169.254";
    private String metadataUrl;
    private String instanceDocumentUrl;
    private boolean enabled = true;

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getMetadataUrl() {
        if (this.metadataUrl == null) {
            return this.url + "/latest/meta-data/";
        }
        return this.metadataUrl;
    }

    public void setMetadataUrl(String metadataUrl) {
        this.metadataUrl = metadataUrl;
    }

    public String getInstanceDocumentUrl() {
        if (this.instanceDocumentUrl == null) {
            return this.url + "/latest/dynamic/instance-identity/document";
        }
        return this.instanceDocumentUrl;
    }

    public void setInstanceDocumentUrl(String instanceDocumentUrl) {
        this.instanceDocumentUrl = instanceDocumentUrl;
    }
}

