/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.tracing.test.simple;

import io.micrometer.tracing.Span;
import io.micrometer.tracing.TraceContext;
import io.micrometer.tracing.test.simple.SimpleSpan;
import io.micrometer.tracing.test.simple.SimpleTracer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class SimpleSpanBuilder
implements Span.Builder {
    private List<String> events = new ArrayList<String>();
    private Map<String, String> tags = new HashMap<String, String>();
    private Throwable throwable;
    private String remoteServiceName;
    private Span.Kind spanKind;
    private String name;
    private String ip;
    private int port;
    private SimpleTracer simpleTracer;
    private long startTimestamp;
    private TimeUnit startTimestampUnit;

    public SimpleSpanBuilder(SimpleTracer simpleTracer) {
        this.simpleTracer = simpleTracer;
    }

    public Span.Builder setParent(TraceContext context) {
        return this;
    }

    public Span.Builder setNoParent() {
        return this;
    }

    public Span.Builder name(String name) {
        this.name = name;
        return this;
    }

    public Span.Builder event(String value) {
        this.events.add(value);
        return this;
    }

    public Span.Builder tag(String key, String value) {
        this.tags.put(key, value);
        return this;
    }

    public Span.Builder error(Throwable throwable) {
        this.throwable = throwable;
        return this;
    }

    public Span.Builder kind(Span.Kind spanKind) {
        this.spanKind = spanKind;
        return this;
    }

    public Span.Builder remoteServiceName(String remoteServiceName) {
        this.remoteServiceName = remoteServiceName;
        return this;
    }

    public Span.Builder remoteIpAndPort(String ip, int port) {
        this.ip = ip;
        this.port = port;
        return this;
    }

    public Span.Builder startTimestamp(long startTimestamp, TimeUnit unit) {
        this.startTimestamp = startTimestamp;
        this.startTimestampUnit = unit;
        return this;
    }

    public Span start() {
        SimpleSpan span = new SimpleSpan();
        this.getTags().forEach(span::tag);
        this.getEvents().forEach(span::event);
        span.remoteServiceName(this.getRemoteServiceName());
        span.error(this.getThrowable());
        span.setSpanKind(this.getSpanKind());
        span.name(this.getName());
        span.remoteIpAndPort(this.getIp(), this.getPort());
        span.start();
        if (this.startTimestampUnit != null) {
            span.setStartMillis(this.startTimestampUnit.toMillis(this.startTimestamp));
        }
        this.simpleTracer.getSpans().add(span);
        return span;
    }

    public List<String> getEvents() {
        return this.events;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public String getRemoteServiceName() {
        return this.remoteServiceName;
    }

    public Span.Kind getSpanKind() {
        return this.spanKind;
    }

    public String getName() {
        return this.name;
    }

    public String getIp() {
        return this.ip;
    }

    public int getPort() {
        return this.port;
    }

    public SimpleTracer getSimpleTracer() {
        return this.simpleTracer;
    }
}

