/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument;

import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.junit5.WireMockRuntimeInfo;
import com.github.tomakehurst.wiremock.junit5.WireMockTest;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import io.micrometer.core.annotation.Incubating;
import io.micrometer.core.instrument.InstrumentationVerificationTests;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.lang.Nullable;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

@WireMockTest
@Incubating(since="1.8.8")
public abstract class HttpClientTimingInstrumentationVerificationTests
extends InstrumentationVerificationTests {
    protected String timerName() {
        return "http.client.requests";
    }

    protected abstract void sendHttpRequest(HttpMethod var1, @Nullable byte[] var2, URI var3, String var4, String ... var5);

    protected String substitutePathVariables(String templatedPath, String ... pathVariables) {
        if (pathVariables.length == 0) {
            return templatedPath;
        }
        String substituted = templatedPath;
        for (String substitution : pathVariables) {
            substituted = substituted.replaceFirst("\\{.*?}", substitution);
        }
        return substituted;
    }

    @Test
    void getTemplatedPathForUri(WireMockRuntimeInfo wmRuntimeInfo) {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.anyUrl()).willReturn(WireMock.ok()));
        String templatedPath = "/customers/{customerId}/carts/{cartId}";
        this.sendHttpRequest(HttpMethod.GET, null, URI.create(wmRuntimeInfo.getHttpBaseUrl()), templatedPath, "112", "5");
        Timer timer = this.getRegistry().get(this.timerName()).tags(new String[]{"method", "GET", "status", "200", "uri", templatedPath}).timer();
        Assertions.assertThat((long)timer.count()).isEqualTo(1L);
        Assertions.assertThat((double)timer.totalTime(TimeUnit.NANOSECONDS)).isPositive();
    }

    @Test
    @Disabled(value="apache/jetty http client instrumentation currently fails this test")
    void timedWhenServerIsMissing() throws IOException {
        int unusedPort = 0;
        try (ServerSocket server2 = new ServerSocket(0);){
            unusedPort = server2.getLocalPort();
        }
        try {
            this.sendHttpRequest(HttpMethod.GET, null, URI.create("http://localhost:" + unusedPort), "/anything", new String[0]);
        }
        catch (Throwable server2) {
            // empty catch block
        }
        Timer timer = this.getRegistry().get(this.timerName()).tags(new String[]{"method", "GET"}).timer();
        Assertions.assertThat((long)timer.count()).isEqualTo(1L);
        Assertions.assertThat((double)timer.totalTime(TimeUnit.NANOSECONDS)).isPositive();
    }

    @Test
    void serverException(WireMockRuntimeInfo wmRuntimeInfo) {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.anyUrl()).willReturn(WireMock.serverError()));
        this.sendHttpRequest(HttpMethod.GET, null, URI.create(wmRuntimeInfo.getHttpBaseUrl()), "/socks", new String[0]);
        Timer timer = this.getRegistry().get(this.timerName()).tags(new String[]{"method", "GET", "status", "500"}).timer();
        Assertions.assertThat((long)timer.count()).isEqualTo(1L);
        Assertions.assertThat((double)timer.totalTime(TimeUnit.NANOSECONDS)).isPositive();
    }

    @Test
    void clientException(WireMockRuntimeInfo wmRuntimeInfo) {
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlPattern)WireMock.anyUrl()).willReturn(WireMock.badRequest()));
        this.sendHttpRequest(HttpMethod.POST, new byte[0], URI.create(wmRuntimeInfo.getHttpBaseUrl()), "/socks", new String[0]);
        Timer timer = this.getRegistry().get(this.timerName()).tags(new String[]{"method", "POST", "status", "400"}).timer();
        Assertions.assertThat((long)timer.count()).isEqualTo(1L);
        Assertions.assertThat((double)timer.totalTime(TimeUnit.NANOSECONDS)).isPositive();
    }

    public static enum HttpMethod {
        GET,
        POST;

    }
}

