/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.prometheusmetrics;

import io.micrometer.core.instrument.AbstractTimer;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.distribution.CountAtBucket;
import io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import io.micrometer.core.instrument.distribution.Histogram;
import io.micrometer.core.instrument.distribution.HistogramSnapshot;
import io.micrometer.core.instrument.distribution.TimeWindowMax;
import io.micrometer.core.instrument.distribution.pause.PauseDetector;
import io.micrometer.core.instrument.util.TimeUtils;
import io.micrometer.prometheusmetrics.ExemplarSamplerFactory;
import io.micrometer.prometheusmetrics.PrometheusHistogram;
import io.prometheus.metrics.core.exemplars.ExemplarSampler;
import io.prometheus.metrics.model.snapshots.Exemplars;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import org.jspecify.annotations.Nullable;

public class PrometheusTimer
extends AbstractTimer {
    private static final CountAtBucket[] EMPTY_HISTOGRAM = new CountAtBucket[0];
    private final LongAdder count = new LongAdder();
    private final LongAdder totalTime = new LongAdder();
    private final TimeWindowMax max;
    private final @Nullable Histogram histogram;
    private final @Nullable ExemplarSampler exemplarSampler;

    PrometheusTimer(Meter.Id id, Clock clock, DistributionStatisticConfig distributionStatisticConfig, PauseDetector pauseDetector, @Nullable ExemplarSamplerFactory exemplarSamplerFactory) {
        super(id, clock, DistributionStatisticConfig.builder().percentilesHistogram(Boolean.valueOf(false)).serviceLevelObjectives(new double[0]).build().merge(distributionStatisticConfig), pauseDetector, TimeUnit.SECONDS, false);
        this.max = new TimeWindowMax(clock, distributionStatisticConfig);
        if (distributionStatisticConfig.isPublishingHistogram()) {
            this.histogram = new PrometheusHistogram(clock, distributionStatisticConfig, exemplarSamplerFactory);
            this.exemplarSampler = null;
        } else {
            this.histogram = null;
            this.exemplarSampler = exemplarSamplerFactory != null ? exemplarSamplerFactory.createExemplarSampler(1) : null;
        }
    }

    protected void recordNonNegative(long amount, TimeUnit unit) {
        this.count.increment();
        long nanoAmount = TimeUnit.NANOSECONDS.convert(amount, unit);
        this.totalTime.add(nanoAmount);
        this.max.record((double)nanoAmount, TimeUnit.NANOSECONDS);
        if (this.histogram != null) {
            this.histogram.recordLong(nanoAmount);
        } else if (this.exemplarSampler != null) {
            this.exemplarSampler.observe((double)nanoAmount);
        }
    }

    Exemplars exemplars() {
        if (this.histogram != null) {
            return ((PrometheusHistogram)this.histogram).exemplars();
        }
        return this.exemplarSampler != null ? this.exemplarSampler.collect() : Exemplars.EMPTY;
    }

    public long count() {
        return this.count.longValue();
    }

    public double totalTime(TimeUnit unit) {
        return TimeUtils.nanosToUnit((double)this.totalTime.doubleValue(), (TimeUnit)unit);
    }

    public double max(TimeUnit unit) {
        return this.max.poll(unit);
    }

    public CountAtBucket[] histogramCounts() {
        return this.histogram == null ? EMPTY_HISTOGRAM : this.histogram.takeSnapshot(0L, 0.0, 0.0).histogramCounts();
    }

    public HistogramSnapshot takeSnapshot() {
        HistogramSnapshot snapshot = super.takeSnapshot();
        if (this.histogram == null) {
            return snapshot;
        }
        return new HistogramSnapshot(snapshot.count(), snapshot.total(), snapshot.max(), snapshot.percentileValues(), this.histogramCounts(), (arg_0, arg_1) -> ((HistogramSnapshot)snapshot).outputSummary(arg_0, arg_1));
    }
}

