/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.binder;

import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.binder.MeterConvention;
import java.util.Objects;
import java.util.function.Function;
import org.jspecify.annotations.Nullable;

public class SimpleMeterConvention<C>
implements MeterConvention<C> {
    private final String name;
    private final @Nullable Tags tags;
    private final @Nullable Function<C, Tags> tagsFunction;

    public SimpleMeterConvention(String name) {
        this(name, Tags.empty());
    }

    public SimpleMeterConvention(String name, Tags tags) {
        this.name = name;
        this.tags = tags;
        this.tagsFunction = null;
    }

    public SimpleMeterConvention(String name, Function<C, Tags> tagsFunction) {
        this.name = name;
        this.tags = null;
        this.tagsFunction = Objects.requireNonNull(tagsFunction);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Tags getTags(C context) {
        return this.tags == null ? Objects.requireNonNull(this.tagsFunction).apply(context) : this.tags;
    }
}

