/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.failover.metrics;

import io.lettuce.core.failover.metrics.CumulativeMeasurement;
import io.lettuce.core.failover.metrics.Outcome;
import java.util.Arrays;

class PackedAggregation
implements CumulativeMeasurement {
    private int[] counts = new int[4];
    private static final int TOTAL_FAILED_CALLS_INDEX = 0;
    private static final int TOTAL_CALLS_INDEX = 1;
    private static final int FAILED_CALLS_INDEX = 2;
    private static final int CALLS_INDEX = 3;

    public PackedAggregation() {
    }

    public PackedAggregation(int[] counts) {
        this.counts = counts;
    }

    PackedAggregation copy() {
        return new PackedAggregation((int[])this.counts.clone());
    }

    void discard(PackedAggregation discarded) {
        this.counts[0] = this.counts[0] - discarded.counts[2];
        this.counts[1] = this.counts[1] - discarded.counts[3];
        this.counts[2] = 0;
        this.counts[3] = 0;
    }

    @Override
    public void record(Outcome outcome) {
        this.counts[1] = this.counts[1] + 1;
        this.counts[3] = this.counts[3] + 1;
        if (outcome == Outcome.FAILURE) {
            this.counts[0] = this.counts[0] + 1;
            this.counts[2] = this.counts[2] + 1;
        }
    }

    @Override
    public int getNumberOfFailedCalls() {
        return this.counts[0];
    }

    @Override
    public int getNumberOfCalls() {
        return this.counts[1];
    }

    public String toString() {
        return "PackedAggregation{counts=" + Arrays.toString(this.counts) + '}';
    }
}

