/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.failover.metrics;

import io.lettuce.core.failover.metrics.MetricsSnapshot;

class MetricsSnapshotImpl
implements MetricsSnapshot {
    private final long successCount;
    private final long failureCount;

    public MetricsSnapshotImpl(long successCount, long failureCount) {
        this.successCount = successCount;
        this.failureCount = failureCount;
    }

    @Override
    public long getSuccessCount() {
        return this.successCount;
    }

    @Override
    public long getFailureCount() {
        return this.failureCount;
    }

    @Override
    public long getTotalCount() {
        return this.successCount + this.failureCount;
    }

    @Override
    public double getFailureRate() {
        long total = this.getTotalCount();
        if (total == 0L) {
            return 0.0;
        }
        return (double)this.failureCount * 100.0 / (double)total;
    }

    @Override
    public double getSuccessRate() {
        return 100.0 - this.getFailureRate();
    }

    public String toString() {
        return "MetricsSnapshot{success=" + this.successCount + ", failure=" + this.failureCount + ", total=" + this.getTotalCount() + ", failureRate=" + String.format("%.2f", this.getFailureRate()) + "%" + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetricsSnapshotImpl that = (MetricsSnapshotImpl)o;
        if (this.successCount != that.successCount) {
            return false;
        }
        return this.failureCount == that.failureCount;
    }
}

