/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.failover.metrics;

import io.lettuce.core.failover.metrics.CircuitBreakerMetrics;
import io.lettuce.core.failover.metrics.Clock;
import io.lettuce.core.failover.metrics.MetricsSnapshot;
import io.lettuce.core.failover.metrics.MetricsSnapshotImpl;
import io.lettuce.core.failover.metrics.Outcome;
import io.lettuce.core.failover.metrics.PackedAggregation;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

class LockFreeSlidingTimeWindowMetrics
implements CircuitBreakerMetrics {
    private static final long TIME_SLICE_DURATION_IN_NANOS = TimeUnit.SECONDS.toNanos(1L);
    private static final AtomicReferenceFieldUpdater<LockFreeSlidingTimeWindowMetrics, Node> HEAD = AtomicReferenceFieldUpdater.newUpdater(LockFreeSlidingTimeWindowMetrics.class, Node.class, "headRef");
    private static final AtomicReferenceFieldUpdater<LockFreeSlidingTimeWindowMetrics, Node> TAIL = AtomicReferenceFieldUpdater.newUpdater(LockFreeSlidingTimeWindowMetrics.class, Node.class, "tailRef");
    private static final AtomicReferenceFieldUpdater<Node, TimeSlice> TIME_SLICE = AtomicReferenceFieldUpdater.newUpdater(Node.class, TimeSlice.class, "timeSlice");
    private static final AtomicReferenceFieldUpdater<Node, Node> NEXT = AtomicReferenceFieldUpdater.newUpdater(Node.class, Node.class, "next");
    private final Clock clock;
    private final int windowSize;
    private volatile Node headRef;
    private volatile Node tailRef;

    LockFreeSlidingTimeWindowMetrics(int windowSize) {
        this(windowSize, Clock.SYSTEM);
    }

    LockFreeSlidingTimeWindowMetrics(int windowSize, Clock clock) {
        if (windowSize < 2) {
            throw new IllegalArgumentException("Window duration must be at least 2 second, got: " + windowSize);
        }
        long time = clock.monotonicTime();
        this.clock = clock;
        this.windowSize = windowSize;
        this.tailRef = this.headRef = new Node(new TimeSlice(0, time, new PackedAggregation(), false), null);
        for (int i = 1; i < this.windowSize; ++i) {
            Node newNode;
            this.tailRef.next = newNode = new Node(new TimeSlice(i, time, new PackedAggregation(), false), null);
            this.tailRef = newNode;
        }
    }

    private MetricsSnapshot record(Outcome outcome) {
        TimeSlice next;
        while (true) {
            this.advanceTimeSlice();
            Node tail = this.tailRef;
            TimeSlice current = tail.timeSlice;
            if (current.processed) continue;
            next = current.copy();
            next.record(outcome);
            if (TIME_SLICE.compareAndSet(tail, current, next)) break;
        }
        return this.snapshot(next);
    }

    @Override
    public void recordSuccess() {
        this.record(Outcome.SUCCESS);
    }

    @Override
    public void recordFailure() {
        this.record(Outcome.FAILURE);
    }

    @Override
    public MetricsSnapshot getSnapshot() {
        this.advanceTimeSlice();
        return this.snapshot(this.tailRef.timeSlice);
    }

    private void advanceTimeSlice() {
        while (true) {
            long elapsedSlices;
            long elapsedTimeInNextSlice;
            Node tail = this.tailRef;
            TimeSlice current = tail.timeSlice;
            long now = this.clock.monotonicTime();
            long elapsedTime = now - current.time;
            if (elapsedTime < TIME_SLICE_DURATION_IN_NANOS) {
                return;
            }
            if (!current.processed) {
                TimeSlice processed = new TimeSlice(current.second, current.time, current.stats, true);
                if (!TIME_SLICE.compareAndSet(tail, current, processed)) continue;
                current = processed;
            }
            if ((elapsedTimeInNextSlice = elapsedTime - (elapsedSlices = Math.min(elapsedTime / TIME_SLICE_DURATION_IN_NANOS, (long)this.windowSize)) * TIME_SLICE_DURATION_IN_NANOS) >= TIME_SLICE_DURATION_IN_NANOS) {
                elapsedTimeInNextSlice = 0L;
            }
            int nextSecond = (current.second + 1) % this.windowSize;
            long nextTime = now - (elapsedSlices - 1L) * TIME_SLICE_DURATION_IN_NANOS - elapsedTimeInNextSlice;
            this.updateWindow(nextSecond, nextTime);
        }
    }

    private void updateWindow(int second, long time) {
        while (true) {
            Node head = this.headRef;
            Node headNext = head.next;
            Node tail = this.tailRef;
            Node tailNext = tail.next;
            if (head != this.headRef || tail != this.tailRef) continue;
            TimeSlice headTimeSlice = head.timeSlice;
            TimeSlice tailTimeSlice = tail.timeSlice;
            int nextSecond = (tailTimeSlice.second + 1) % this.windowSize;
            if (second != nextSecond || time < tailTimeSlice.time) {
                return;
            }
            if (tailNext == null) {
                PackedAggregation nextStats = tailTimeSlice.stats.copy();
                nextStats.discard(headTimeSlice.stats);
                TimeSlice nextTimeSlice = new TimeSlice(nextSecond, time, nextStats, false);
                Node nextNode = new Node(nextTimeSlice, null);
                if (!NEXT.compareAndSet(tail, null, nextNode) || !HEAD.compareAndSet(this, head, headNext)) continue;
                TAIL.compareAndSet(this, tail, nextNode);
                return;
            }
            if (tailNext.timeSlice.second == headTimeSlice.second) {
                if (!HEAD.compareAndSet(this, head, headNext)) continue;
                TAIL.compareAndSet(this, tail, tailNext);
                continue;
            }
            TAIL.compareAndSet(this, tail, tailNext);
        }
    }

    private MetricsSnapshot snapshot(TimeSlice slice) {
        long successCalls = slice.stats.getNumberOfCalls() - slice.stats.getNumberOfFailedCalls();
        return new MetricsSnapshotImpl(successCalls, slice.stats.getNumberOfFailedCalls());
    }

    private static class Node {
        volatile TimeSlice timeSlice;
        volatile Node next;

        Node(TimeSlice timeSlice, Node next) {
            TIME_SLICE.set(this, timeSlice);
            NEXT.set(this, next);
        }
    }

    static class TimeSlice {
        final int second;
        final long time;
        final PackedAggregation stats;
        final boolean processed;

        public TimeSlice(int second, long time, PackedAggregation stats, boolean processed) {
            this.second = second;
            this.time = time;
            this.stats = stats;
            this.processed = processed;
        }

        public TimeSlice copy() {
            return new TimeSlice(this.second, this.time, this.stats.copy(), this.processed);
        }

        public void record(Outcome outcome) {
            this.stats.record(outcome);
        }
    }
}

