/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.failover.health;

import io.lettuce.core.RedisURI;
import io.lettuce.core.annotations.Experimental;
import io.lettuce.core.failover.health.HealthCheck;
import io.lettuce.core.failover.health.HealthCheckCollection;
import io.lettuce.core.failover.health.HealthCheckImpl;
import io.lettuce.core.failover.health.HealthCheckStrategy;
import io.lettuce.core.failover.health.HealthStatus;
import io.lettuce.core.failover.health.HealthStatusChangeEvent;
import io.lettuce.core.failover.health.HealthStatusListener;
import io.lettuce.core.failover.health.HealthStatusManager;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

@Experimental
public class HealthStatusManagerImpl
implements HealthStatusManager,
AutoCloseable {
    private final HealthCheckCollection healthChecks = new HealthCheckCollection();
    private final List<HealthStatusListener> listeners = new CopyOnWriteArrayList<HealthStatusListener>();
    private final Map<RedisURI, List<HealthStatusListener>> endpointListeners = new ConcurrentHashMap<RedisURI, List<HealthStatusListener>>();

    @Override
    public void registerListener(HealthStatusListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void unregisterListener(HealthStatusListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void registerListener(RedisURI endpoint, HealthStatusListener listener) {
        this.endpointListeners.computeIfAbsent(endpoint, k -> new CopyOnWriteArrayList()).add(listener);
    }

    @Override
    public void unregisterListener(RedisURI endpoint, HealthStatusListener listener) {
        this.endpointListeners.computeIfPresent(endpoint, (k, v) -> {
            v.remove(listener);
            return v;
        });
    }

    public void notifyListeners(HealthStatusChangeEvent eventArgs) {
        this.endpointListeners.computeIfPresent(eventArgs.getEndpoint(), (k, v) -> {
            for (HealthStatusListener listener : v) {
                listener.onStatusChange(eventArgs);
            }
            return v;
        });
        for (HealthStatusListener listener : this.listeners) {
            listener.onStatusChange(eventArgs);
        }
    }

    @Override
    public HealthCheck add(RedisURI endpoint, HealthCheckStrategy strategy) {
        HealthCheckImpl hc = new HealthCheckImpl(endpoint, strategy);
        hc.addListener(this::notifyListeners);
        HealthCheck old = this.healthChecks.add(hc);
        hc.start();
        if (old != null) {
            old.stop();
        }
        return hc;
    }

    @Override
    public void remove(RedisURI endpoint) {
        HealthCheck old = this.healthChecks.remove(endpoint);
        if (old != null) {
            old.stop();
        }
    }

    @Override
    public HealthStatus getHealthStatus(RedisURI endpoint) {
        HealthCheck healthCheck = this.healthChecks.get(endpoint);
        return healthCheck != null ? healthCheck.getStatus() : HealthStatus.UNKNOWN;
    }

    @Override
    public long getMaxWaitFor(RedisURI endpoint) {
        HealthCheck healthCheck = this.healthChecks.get(endpoint);
        return healthCheck != null ? healthCheck.getMaxWaitFor() : 0L;
    }

    @Override
    public void close() {
        this.healthChecks.close();
    }
}

