/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.failover;

import io.lettuce.core.RedisConnectionException;
import io.lettuce.core.RedisURI;
import io.lettuce.core.failover.health.HealthStatus;
import io.lettuce.core.failover.health.HealthStatusChangeEvent;
import io.lettuce.core.failover.health.HealthStatusListener;
import io.lettuce.core.failover.health.HealthStatusManager;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

class StatusTracker {
    private final HealthStatusManager healthStatusManager;

    public StatusTracker(HealthStatusManager healthStatusManager) {
        this.healthStatusManager = healthStatusManager;
    }

    public HealthStatus waitForHealthStatus(final RedisURI endpoint) {
        HealthStatus currentStatus = this.healthStatusManager.getHealthStatus(endpoint);
        if (currentStatus != HealthStatus.UNKNOWN) {
            return currentStatus;
        }
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicReference resultStatus = new AtomicReference();
        HealthStatusListener tempListener = new HealthStatusListener(){

            @Override
            public void onStatusChange(HealthStatusChangeEvent event) {
                if (event.getEndpoint().equals(endpoint) && event.getNewStatus() != HealthStatus.UNKNOWN) {
                    resultStatus.set(event.getNewStatus());
                    latch.countDown();
                }
            }
        };
        this.healthStatusManager.registerListener(endpoint, tempListener);
        try {
            currentStatus = this.healthStatusManager.getHealthStatus(endpoint);
            if (currentStatus != HealthStatus.UNKNOWN) {
                HealthStatus healthStatus = currentStatus;
                return healthStatus;
            }
            boolean completed = latch.await(this.healthStatusManager.getMaxWaitFor(endpoint), TimeUnit.MILLISECONDS);
            if (!completed) {
                throw new RedisConnectionException("Timeout while waiting for health check result");
            }
            HealthStatus healthStatus = (HealthStatus)((Object)resultStatus.get());
            return healthStatus;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RedisConnectionException("Interrupted while waiting for health check result", e);
        }
        finally {
            this.healthStatusManager.unregisterListener(endpoint, tempListener);
        }
    }
}

