/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.failover;

import io.lettuce.core.ClientOptions;
import io.lettuce.core.RedisURI;
import io.lettuce.core.annotations.Experimental;
import io.lettuce.core.api.BaseRedisClient;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.failover.DatabaseConfig;
import io.lettuce.core.failover.MultiDbClientImpl;
import io.lettuce.core.failover.api.StatefulRedisMultiDbConnection;
import io.lettuce.core.failover.api.StatefulRedisMultiDbPubSubConnection;
import io.lettuce.core.resource.ClientResources;
import java.util.Collection;

@Experimental
public interface MultiDbClient
extends BaseRedisClient {
    public static MultiDbClient create(Collection<DatabaseConfig> databaseConfigs) {
        if (databaseConfigs == null || databaseConfigs.isEmpty()) {
            throw new IllegalArgumentException("Database configs must not be empty");
        }
        return new MultiDbClientImpl(databaseConfigs);
    }

    public static MultiDbClient create(ClientResources resources, Collection<DatabaseConfig> databaseConfigs) {
        if (resources == null) {
            throw new IllegalArgumentException("Client resources must not be null");
        }
        if (databaseConfigs == null || databaseConfigs.isEmpty()) {
            throw new IllegalArgumentException("Database configs must not be empty");
        }
        return new MultiDbClientImpl(resources, databaseConfigs);
    }

    public static MultiDbClient create(ClientOptions options, ClientResources resources, Collection<DatabaseConfig> databaseConfigs) {
        MultiDbClientImpl client = new MultiDbClientImpl(resources, databaseConfigs);
        client.setOptions(options);
        return client;
    }

    public void setOptions(ClientOptions var1);

    public Collection<RedisURI> getRedisURIs();

    public <K, V> StatefulRedisMultiDbConnection<K, V> connect(RedisCodec<K, V> var1);

    public StatefulRedisMultiDbConnection<String, String> connect();

    public <K, V> StatefulRedisMultiDbPubSubConnection<K, V> connectPubSub(RedisCodec<K, V> var1);

    public StatefulRedisMultiDbPubSubConnection<String, String> connectPubSub();
}

