/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.failover;

import io.lettuce.core.RedisCommandTimeoutException;
import io.lettuce.core.RedisConnectionException;
import io.lettuce.core.annotations.Experimental;
import io.lettuce.core.failover.CircuitBreakerGeneration;
import io.lettuce.core.failover.api.CircuitBreakerStateListener;
import io.lettuce.core.failover.metrics.MetricsSnapshot;
import io.lettuce.core.internal.LettuceAssert;
import java.io.Closeable;
import java.io.IOException;
import java.net.ConnectException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeoutException;

@Experimental
public interface CircuitBreaker
extends Closeable {
    public MetricsSnapshot getSnapshot();

    public CircuitBreakerGeneration getGeneration();

    public State getCurrentState();

    public boolean isClosed();

    public void addListener(CircuitBreakerStateListener var1);

    public void removeListener(CircuitBreakerStateListener var1);

    @Override
    public void close();

    public static class CircuitBreakerConfig {
        private static final float DEFAULT_FAILURE_RATE_THRESHOLD = 10.0f;
        private static final int DEFAULT_MINIMUM_NUMBER_OF_FAILURES = 1000;
        private static final int DEFAULT_METRICS_WINDOW_SIZE = 2;
        private static final Set<Class<? extends Throwable>> DEFAULT_TRACKED_EXCEPTIONS = new HashSet<Class>(Arrays.asList(RedisConnectionException.class, IOException.class, ConnectException.class, RedisCommandTimeoutException.class, TimeoutException.class));
        public static final CircuitBreakerConfig DEFAULT = CircuitBreakerConfig.builder().build();
        private final Set<Class<? extends Throwable>> trackedExceptions;
        private final float failureThreshold;
        private final int minimumNumberOfFailures;
        private final int metricsWindowSize;

        CircuitBreakerConfig(Builder builder) {
            this.trackedExceptions = new HashSet<Class<? extends Throwable>>(builder.trackedExceptions);
            this.failureThreshold = builder.failureThreshold;
            this.minimumNumberOfFailures = builder.minimumNumberOfFailures;
            this.metricsWindowSize = builder.metricsWindowSize;
        }

        public static Builder builder() {
            return new Builder();
        }

        public Set<Class<? extends Throwable>> getTrackedExceptions() {
            return this.trackedExceptions;
        }

        public float getFailureRateThreshold() {
            return this.failureThreshold;
        }

        public int getMinimumNumberOfFailures() {
            return this.minimumNumberOfFailures;
        }

        public int getMetricsWindowSize() {
            return this.metricsWindowSize;
        }

        public String toString() {
            return "CircuitBreakerConfig{trackedExceptions=" + this.trackedExceptions + ", failureThreshold=" + this.failureThreshold + ", minimumNumberOfFailures=" + this.minimumNumberOfFailures + ", metricsWindowSize=" + this.metricsWindowSize + '}';
        }

        public static class Builder {
            private Set<Class<? extends Throwable>> trackedExceptions = CircuitBreakerConfig.access$500();
            private float failureThreshold = 10.0f;
            private int minimumNumberOfFailures = 1000;
            private int metricsWindowSize = 2;

            private Builder() {
            }

            public Builder failureRateThreshold(float failureThreshold) {
                this.failureThreshold = failureThreshold;
                return this;
            }

            public Builder minimumNumberOfFailures(int minimumNumberOfFailures) {
                this.minimumNumberOfFailures = minimumNumberOfFailures;
                return this;
            }

            public Builder trackedExceptions(Set<Class<? extends Throwable>> trackedExceptions) {
                LettuceAssert.notNull(trackedExceptions, "Tracked exceptions must not be null");
                this.trackedExceptions = trackedExceptions;
                return this;
            }

            @SafeVarargs
            public final Builder addTrackedExceptions(Class<? extends Throwable> ... exceptionClasses) {
                LettuceAssert.notNull(exceptionClasses, "Exception classes must not be null");
                LettuceAssert.noNullElements((Object[])exceptionClasses, "Exception classes must not contain null elements");
                LettuceAssert.notEmpty((Object[])exceptionClasses, "Exception classes must contain at least one element");
                if (this.trackedExceptions == DEFAULT_TRACKED_EXCEPTIONS) {
                    this.trackedExceptions = new HashSet<Class<? extends Throwable>>(DEFAULT_TRACKED_EXCEPTIONS);
                }
                this.trackedExceptions.addAll(Arrays.asList(exceptionClasses));
                return this;
            }

            @SafeVarargs
            public final Builder removeTrackedExceptions(Class<? extends Throwable> ... exceptionClasses) {
                LettuceAssert.notNull(exceptionClasses, "Exception classes must not be null");
                LettuceAssert.noNullElements((Object[])exceptionClasses, "Exception classes must not contain null elements");
                LettuceAssert.notEmpty((Object[])exceptionClasses, "Exception classes must contain at least one element");
                if (this.trackedExceptions == DEFAULT_TRACKED_EXCEPTIONS) {
                    this.trackedExceptions = new HashSet<Class<? extends Throwable>>(DEFAULT_TRACKED_EXCEPTIONS);
                }
                Arrays.asList(exceptionClasses).forEach(this.trackedExceptions::remove);
                return this;
            }

            public Builder metricsWindowSize(int metricsWindowSize) {
                LettuceAssert.isTrue(metricsWindowSize >= 2, "Metrics window size must be at least 2 seconds");
                this.metricsWindowSize = metricsWindowSize;
                return this;
            }

            public CircuitBreakerConfig build() {
                return new CircuitBreakerConfig(this);
            }
        }
    }

    public static enum State {
        CLOSED,
        OPEN;

    }
}

