/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.search.arguments;

import io.lettuce.core.annotations.Experimental;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.protocol.CommandArgs;
import io.lettuce.core.protocol.CommandKeyword;

@Experimental
public class CombineArgs<K> {
    private final CombineMethod<K> method;
    private K scoreAlias;

    private CombineArgs(CombineMethod<K> method) {
        this.method = method;
    }

    public static <K> CombineArgs<K> of(CombineMethod<K> method) {
        return new CombineArgs<K>(method);
    }

    public CombineArgs<K> as(K alias) {
        LettuceAssert.notNull(alias, "Alias must not be null");
        this.scoreAlias = alias;
        return this;
    }

    public <V> void build(CommandArgs<K, V> args) {
        this.method.build(args);
        if (this.scoreAlias != null) {
            args.add(CommandKeyword.YIELD_SCORE_AS);
            args.addKey(this.scoreAlias);
        }
    }

    public static class Linear<K>
    implements CombineMethod<K> {
        private Double alpha;
        private Double beta;

        public Linear<K> alpha(double alpha) {
            LettuceAssert.isTrue(alpha >= 0.0, "Alpha must be non-negative");
            this.alpha = alpha;
            return this;
        }

        public Linear<K> beta(double beta) {
            LettuceAssert.isTrue(beta >= 0.0, "Beta must be non-negative");
            this.beta = beta;
            return this;
        }

        @Override
        public <V> void build(CommandArgs<K, V> args) {
            args.add(CommandKeyword.LINEAR);
            int itemCount = 0;
            if (this.alpha != null) {
                itemCount += 2;
            }
            if (this.beta != null) {
                itemCount += 2;
            }
            args.add(itemCount);
            if (this.alpha != null) {
                args.add(CommandKeyword.ALPHA);
                args.add(this.alpha);
            }
            if (this.beta != null) {
                args.add(CommandKeyword.BETA);
                args.add(this.beta);
            }
        }
    }

    public static class RRF<K>
    implements CombineMethod<K> {
        private Integer window;
        private Double constant;

        public RRF<K> window(int window) {
            LettuceAssert.isTrue(window > 0, "Window must be positive");
            this.window = window;
            return this;
        }

        public RRF<K> constant(double constant) {
            LettuceAssert.isTrue(constant > 0.0, "Constant must be positive");
            this.constant = constant;
            return this;
        }

        @Override
        public <V> void build(CommandArgs<K, V> args) {
            args.add(CommandKeyword.RRF);
            int itemCount = 0;
            if (this.window != null) {
                itemCount += 2;
            }
            if (this.constant != null) {
                itemCount += 2;
            }
            args.add(itemCount);
            if (this.window != null) {
                args.add(CommandKeyword.WINDOW);
                args.add(this.window.intValue());
            }
            if (this.constant != null) {
                args.add(CommandKeyword.CONSTANT);
                args.add(this.constant);
            }
        }
    }

    public static interface CombineMethod<K> {
        public <V> void build(CommandArgs<K, V> var1);
    }
}

