/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.api.sync;

import io.lettuce.core.CompareCondition;
import io.lettuce.core.CopyArgs;
import io.lettuce.core.ExpireArgs;
import io.lettuce.core.KeyScanCursor;
import io.lettuce.core.MigrateArgs;
import io.lettuce.core.RestoreArgs;
import io.lettuce.core.ScanArgs;
import io.lettuce.core.ScanCursor;
import io.lettuce.core.SortArgs;
import io.lettuce.core.StreamScanCursor;
import io.lettuce.core.annotations.Experimental;
import io.lettuce.core.output.KeyStreamingChannel;
import io.lettuce.core.output.ValueStreamingChannel;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.List;

public interface RedisKeyCommands<K, V> {
    public Boolean copy(K var1, K var2);

    public Boolean copy(K var1, K var2, CopyArgs var3);

    public Long del(K ... var1);

    @Experimental
    public Long delex(K var1, CompareCondition<V> var2);

    @Experimental
    public String digestKey(K var1);

    public Long unlink(K ... var1);

    public byte[] dump(K var1);

    public Long exists(K ... var1);

    public Boolean expire(K var1, long var2);

    public Boolean expire(K var1, long var2, ExpireArgs var4);

    public Boolean expire(K var1, Duration var2);

    public Boolean expire(K var1, Duration var2, ExpireArgs var3);

    public Boolean expireat(K var1, long var2);

    public Boolean expireat(K var1, long var2, ExpireArgs var4);

    public Boolean expireat(K var1, Date var2);

    public Boolean expireat(K var1, Date var2, ExpireArgs var3);

    public Boolean expireat(K var1, Instant var2);

    public Boolean expireat(K var1, Instant var2, ExpireArgs var3);

    public Long expiretime(K var1);

    public List<K> keys(String var1);

    @Deprecated
    public List<K> keysLegacy(K var1);

    public Long keys(KeyStreamingChannel<K> var1, String var2);

    @Deprecated
    public Long keysLegacy(KeyStreamingChannel<K> var1, K var2);

    public String migrate(String var1, int var2, K var3, int var4, long var5);

    public String migrate(String var1, int var2, int var3, long var4, MigrateArgs<K> var6);

    public Boolean move(K var1, int var2);

    public String objectEncoding(K var1);

    public Long objectFreq(K var1);

    public Long objectIdletime(K var1);

    public Long objectRefcount(K var1);

    public Boolean persist(K var1);

    public Boolean pexpire(K var1, long var2);

    public Boolean pexpire(K var1, long var2, ExpireArgs var4);

    public Boolean pexpire(K var1, Duration var2);

    public Boolean pexpire(K var1, Duration var2, ExpireArgs var3);

    public Boolean pexpireat(K var1, long var2);

    public Boolean pexpireat(K var1, long var2, ExpireArgs var4);

    public Boolean pexpireat(K var1, Date var2);

    public Boolean pexpireat(K var1, Date var2, ExpireArgs var3);

    public Boolean pexpireat(K var1, Instant var2);

    public Boolean pexpireat(K var1, Instant var2, ExpireArgs var3);

    public Long pexpiretime(K var1);

    public Long pttl(K var1);

    public K randomkey();

    public String rename(K var1, K var2);

    public Boolean renamenx(K var1, K var2);

    public String restore(K var1, long var2, byte[] var4);

    public String restore(K var1, byte[] var2, RestoreArgs var3);

    public List<V> sort(K var1);

    public Long sort(ValueStreamingChannel<V> var1, K var2);

    public List<V> sort(K var1, SortArgs var2);

    public Long sort(ValueStreamingChannel<V> var1, K var2, SortArgs var3);

    public List<V> sortReadOnly(K var1);

    public Long sortReadOnly(ValueStreamingChannel<V> var1, K var2);

    public List<V> sortReadOnly(K var1, SortArgs var2);

    public Long sortReadOnly(ValueStreamingChannel<V> var1, K var2, SortArgs var3);

    public Long sortStore(K var1, SortArgs var2, K var3);

    public Long touch(K ... var1);

    public Long ttl(K var1);

    public String type(K var1);

    public KeyScanCursor<K> scan();

    public KeyScanCursor<K> scan(ScanArgs var1);

    public KeyScanCursor<K> scan(ScanCursor var1, ScanArgs var2);

    public KeyScanCursor<K> scan(ScanCursor var1);

    public StreamScanCursor scan(KeyStreamingChannel<K> var1);

    public StreamScanCursor scan(KeyStreamingChannel<K> var1, ScanArgs var2);

    public StreamScanCursor scan(KeyStreamingChannel<K> var1, ScanCursor var2, ScanArgs var3);

    public StreamScanCursor scan(KeyStreamingChannel<K> var1, ScanCursor var2);
}

